/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.Stat;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.fingerprint.FileCollectionSnapshotter;
import org.gradle.internal.fingerprint.impl.PatternSetSnapshottingFilter;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemSnapshotter;
import org.gradle.internal.snapshot.SnapshottingFilter;

public class DefaultFileCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final Stat stat;

    public DefaultFileCollectionSnapshotter(FileSystemSnapshotter fileSystemSnapshotter, Stat stat) {
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.stat = stat;
    }

    @Override
    public List<FileSystemSnapshot> snapshot(FileCollection fileCollection) {
        SnapshotingVisitor visitor = new SnapshotingVisitor();
        ((FileCollectionInternal)fileCollection).visitStructure((FileCollectionStructureVisitor)visitor);
        return visitor.getRoots();
    }

    private FileSystemSnapshot snapshotFileTree(FileTreeInternal tree) {
        return this.fileSystemSnapshotter.snapshotWithBuilder(builder -> tree.visit(new FileVisitor((FileSystemSnapshotBuilder)builder){
            final /* synthetic */ FileSystemSnapshotBuilder val$builder;
            {
                this.val$builder = fileSystemSnapshotBuilder;
            }

            public void visitDir(FileVisitDetails dirDetails) {
                this.val$builder.addDir(dirDetails.getFile(), dirDetails.getRelativePath().getSegments());
            }

            public void visitFile(FileVisitDetails fileDetails) {
                this.val$builder.addFile(fileDetails.getFile(), fileDetails.getRelativePath().getSegments(), fileDetails.getName(), (FileMetadataSnapshot)new DefaultFileMetadata(FileType.RegularFile, fileDetails.getLastModified(), fileDetails.getSize()));
            }
        }));
    }

    private class SnapshotingVisitor
    implements FileCollectionStructureVisitor {
        private final List<FileSystemSnapshot> roots = new ArrayList<FileSystemSnapshot>();

        private SnapshotingVisitor() {
        }

        public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
            for (File file : contents) {
                this.roots.add((FileSystemSnapshot)DefaultFileCollectionSnapshotter.this.fileSystemSnapshotter.snapshot(file));
            }
        }

        public void visitGenericFileTree(FileTreeInternal fileTree) {
            this.roots.add(DefaultFileCollectionSnapshotter.this.snapshotFileTree(fileTree));
        }

        public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
            this.roots.add(DefaultFileCollectionSnapshotter.this.fileSystemSnapshotter.snapshotDirectoryTree(root, (SnapshottingFilter)new PatternSetSnapshottingFilter(patterns, DefaultFileCollectionSnapshotter.this.stat)));
        }

        public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree) {
            this.roots.add((FileSystemSnapshot)DefaultFileCollectionSnapshotter.this.fileSystemSnapshotter.snapshot(file));
        }

        public List<FileSystemSnapshot> getRoots() {
            return this.roots;
        }
    }
}

