/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrDeclarationToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsClassGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrClassModel;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020!H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsClassGenerator;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)V", "baseClass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "baseClassName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "classBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsGlobalBlock;", "classModel", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrClassModel;", "className", "classNameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "classPrototypeRef", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "generate", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "generateClassMetadata", "generateInheritanceCode", "", "generateMemberFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "generateSuperClasses", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "generateSuspendArity", "isCoroutineClass", "", "backend.js"})
public final class JsClassGenerator {
    private final JsName className;
    private final JsNameRef classNameRef;
    private final IrType baseClass;
    private final JsName baseClassName;
    private final JsNameRef classPrototypeRef;
    private final JsGlobalBlock classBlock;
    private final JsIrClassModel classModel;
    private final IrClass irClass;
    @NotNull
    private final JsGenerationContext context;

    @NotNull
    public final JsStatement generate() {
        boolean bl = !this.irClass.getDescriptor().isExpect();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        IrDeclarationToJsTransformer transformer = new IrDeclarationToJsTransformer();
        bl3 = false;
        Set properties2 = new LinkedHashSet();
        for (IrDeclaration declaration2 : this.irClass.getDeclarations()) {
            boolean bl5;
            Object object;
            IrDeclaration irDeclaration = declaration2;
            if (irDeclaration instanceof IrConstructor) {
                object = this.classBlock.getStatements();
                Object object2 = declaration2.accept(transformer, this.context);
                bl5 = false;
                object.add(object2);
                object = this.classModel.getPreDeclarationBlock().getStatements();
                object2 = this.generateInheritanceCode();
                bl5 = false;
                kotlin.collections.CollectionsKt.addAll((Collection)object, object2);
                continue;
            }
            if (irDeclaration instanceof IrSimpleFunction) {
                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)declaration2).getCorrespondingPropertySymbol();
                CollectionsKt.addIfNotNull(properties2, irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null);
                if (this.generateMemberFunction((IrSimpleFunction)declaration2) != null) {
                    boolean bl6 = false;
                    bl5 = false;
                    Object it = object;
                    boolean bl7 = false;
                    Collection collection = this.classBlock.getStatements();
                    boolean bl8 = false;
                    collection.add(it);
                }
                continue;
            }
            if (irDeclaration instanceof IrClass) {
                object = this.classBlock.getStatements();
                JsStatement jsStatement = new JsClassGenerator((IrClass)declaration2, this.context).generate();
                bl5 = false;
                object.add(jsStatement);
                continue;
            }
            if (irDeclaration instanceof IrField) continue;
            object = "Unexpected declaration in class: " + declaration2;
            boolean bl9 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        Collection declaration2 = this.classBlock.getStatements();
        Iterator iterator2 = this.generateClassMetadata();
        boolean bl10 = false;
        declaration2.add(iterator2);
        if (!(IrUtilsKt.isInterface(this.irClass) || IrUtilsKt.isEnumClass(this.irClass) || IrUtilsKt.isEnumEntry(this.irClass))) {
            for (IrProperty property : properties2) {
                IrSimpleFunction irSimpleFunction = property.getGetter();
                if ((irSimpleFunction != null ? irSimpleFunction.getExtensionReceiverParameter() : null) != null) continue;
                IrSimpleFunction irSimpleFunction2 = property.getSetter();
                if ((irSimpleFunction2 != null ? irSimpleFunction2.getExtensionReceiverParameter() : null) != null || Intrinsics.areEqual((Object)property.getVisibility(), (Object)Visibilities.PUBLIC) ^ true || Intrinsics.areEqual((Object)property.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE)) continue;
                Function1<IrSimpleFunction, JsNameRef> $fun$accessorRef$2 = new Function1<IrSimpleFunction, JsNameRef>(this){
                    final /* synthetic */ JsClassGenerator this$0;

                    @Nullable
                    public final JsNameRef invoke(@NotNull IrSimpleFunction $this$accessorRef) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$accessorRef, (String)"$this$accessorRef");
                        Visibility visibility = $this$accessorRef.getVisibility();
                        return Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PRIVATE) ? null : new JsNameRef(this.this$0.getContext().getNameForMemberFunction($this$accessorRef), (JsExpression)JsClassGenerator.access$getClassPrototypeRef$p(this.this$0));
                    }
                    {
                        this.this$0 = jsClassGenerator;
                        super(1);
                    }
                };
                IrSimpleFunction irSimpleFunction3 = property.getGetter();
                JsNameRef getterRef = irSimpleFunction3 != null ? $fun$accessorRef$2.invoke(irSimpleFunction3) : null;
                IrSimpleFunction irSimpleFunction4 = property.getSetter();
                JsNameRef setterRef = irSimpleFunction4 != null ? $fun$accessorRef$2.invoke(irSimpleFunction4) : null;
                Collection collection = this.classBlock.getStatements();
                JsExpression jsExpression = this.classPrototypeRef;
                String string = this.context.getNameForProperty(property).getIdent();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.getNameForProperty(property).ident");
                JsExpressionStatement jsExpressionStatement = new JsExpressionStatement(JsAstUtilsKt.defineProperty(jsExpression, string, getterRef, setterRef));
                boolean bl11 = false;
                collection.add(jsExpressionStatement);
            }
        }
        this.context.getStaticContext().getClassModels().put((IrClassSymbol)this.irClass.getSymbol(), this.classModel);
        return this.classBlock;
    }

    private final JsStatement generateMemberFunction(IrSimpleFunction declaration2) {
        boolean bl;
        IrSimpleFunction irSimpleFunction = declaration2;
        boolean bl2 = false;
        boolean bl3 = false;
        IrSimpleFunction $this$run = irSimpleFunction;
        boolean bl4 = false;
        JsFunction translatedFunction = IrUtilsKt.isReal($this$run) ? (JsFunction)$this$run.accept(new IrFunctionToJsTransformer(), this.context) : null;
        boolean bl5 = !IrFunctionKt.isStaticMethodOfClass(declaration2);
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl5) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        JsName memberName = this.context.getNameForMemberFunction(IrResolveUtilsKt.getRealOverrideTarget(declaration2));
        JsNameRef memberRef = new JsNameRef(memberName, (JsExpression)this.classPrototypeRef);
        JsFunction jsFunction = translatedFunction;
        if (jsFunction != null) {
            JsFunction jsFunction2 = jsFunction;
            boolean bl7 = false;
            bl = false;
            JsFunction it = jsFunction2;
            boolean bl8 = false;
            JsFunction jsFunction3 = it;
            JsExpression jsExpression = memberRef;
            boolean bl9 = false;
            boolean bl10 = false;
            JsFunction $this$apply = jsFunction3;
            boolean bl11 = false;
            $this$apply.setName(null);
            JsFunction jsFunction4 = jsFunction3;
            return JsAstUtilsKt.jsAssignment(jsExpression, jsFunction4).makeStmt();
        }
        if (!IrUtilsKt.isInterface(this.irClass)) {
            IrSimpleFunction irSimpleFunction2 = IrResolveUtilsKt.getRealOverrideTarget(declaration2);
            boolean bl12 = false;
            bl = false;
            IrSimpleFunction it = irSimpleFunction2;
            boolean bl13 = false;
            IrDeclarationParent irDeclarationParent = it.getParent();
            if (irDeclarationParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            IrClass implClassDeclaration = (IrClass)irDeclarationParent;
            if (!IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(implClassDeclaration)) && !IrUtilsKt.isEffectivelyExternal(it)) {
                JsName implMethodName = this.context.getNameForMemberFunction(it);
                JsName implClassName = this.context.getNameForClass(implClassDeclaration);
                JsNameRef jsNameRef = implClassName.makeRef();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"implClassName.makeRef()");
                JsNameRef implClassPrototype = JsAstUtilsKt.prototypeOf(jsNameRef);
                JsNameRef implMemberRef = new JsNameRef(implMethodName, (JsExpression)implClassPrototype);
                Collection collection = this.classModel.getPostDeclarationBlock().getStatements();
                JsStatement jsStatement = JsAstUtilsKt.jsAssignment(memberRef, implMemberRef).makeStmt();
                boolean bl14 = false;
                collection.add(jsStatement);
            }
        }
        return null;
    }

    private final List<JsStatement> generateInheritanceCode() {
        if (this.baseClass == null || IrTypePredicatesKt.isAny(this.baseClass)) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        JsExpression jsExpression = this.classPrototypeRef;
        JsExpression jsExpression2 = Namer.INSTANCE.getJS_OBJECT_CREATE_FUNCTION();
        JsExpression[] jsExpressionArray = new JsExpression[1];
        JsName jsName = this.baseClassName;
        if (jsName == null) {
            Intrinsics.throwNpe();
        }
        JsNameRef jsNameRef = jsName.makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"baseClassName!!.makeRef()");
        jsExpressionArray[0] = JsAstUtilsKt.prototypeOf(jsNameRef);
        JsStatement jsStatement = JsAstUtilsKt.jsAssignment(jsExpression, new JsInvocation(jsExpression2, jsExpressionArray)).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"jsAssignment(\n          \u2026()))\n        ).makeStmt()");
        JsStatement createCall = jsStatement;
        JsStatement jsStatement2 = JsAstUtilsKt.jsAssignment(new JsNameRef(Namer.INSTANCE.getCONSTRUCTOR_NAME(), (JsExpression)this.classPrototypeRef), this.classNameRef).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement2, (String)"jsAssignment(JsNameRef(N\u2026 classNameRef).makeStmt()");
        JsStatement ctorAssign = jsStatement2;
        return kotlin.collections.CollectionsKt.listOf((Object[])new JsStatement[]{createCall, ctorAssign});
    }

    private final JsStatement generateClassMetadata() {
        Collection collection;
        JsObjectLiteral metadataLiteral = new JsObjectLiteral(true);
        Name simpleName = this.irClass.getName();
        if (!simpleName.isSpecial()) {
            JsPropertyInitializer simpleNameProp = new JsPropertyInitializer(new JsNameRef(Namer.INSTANCE.getMETADATA_SIMPLE_NAME()), new JsStringLiteral(simpleName.getIdentifier()));
            collection = metadataLiteral.getPropertyInitializers();
            boolean bl = false;
            collection.add(simpleNameProp);
        }
        JsStringLiteral classKind = new JsStringLiteral(IrUtilsKt.isInterface(this.irClass) ? "interface" : (IrUtilsKt.isObject(this.irClass) ? "object" : "class"));
        collection = metadataLiteral.getPropertyInitializers();
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(new JsNameRef(Namer.INSTANCE.getMETADATA_CLASS_KIND()), classKind);
        boolean bl = false;
        collection.add(jsPropertyInitializer);
        collection = metadataLiteral.getPropertyInitializers();
        jsPropertyInitializer = this.generateSuperClasses();
        bl = false;
        collection.add(jsPropertyInitializer);
        if (this.isCoroutineClass()) {
            collection = metadataLiteral.getPropertyInitializers();
            jsPropertyInitializer = this.generateSuspendArity();
            bl = false;
            collection.add(jsPropertyInitializer);
        }
        JsStatement jsStatement = JsAstUtilsKt.jsAssignment(new JsNameRef(Namer.INSTANCE.getMETADATA(), (JsExpression)this.classNameRef), metadataLiteral).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"jsAssignment(JsNameRef(N\u2026tadataLiteral).makeStmt()");
        return jsStatement;
    }

    private final boolean isCoroutineClass() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.irClass.getSuperTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrType it = (IrType)element$iv;
                    boolean bl2 = false;
                    if (!IrTypeUtilsKt.isSuspendFunctionTypeOrSubtype(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final JsPropertyInitializer generateSuspendArity() {
        Object element$iv2;
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.irClass.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$first$iv = (List)destination$iv$iv;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv2;
                boolean bl = false;
                if (!it.isSuspend()) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        int arity = ((IrSimpleFunction)element$iv2).getValueParameters().size();
        return new JsPropertyInitializer(new JsNameRef(Namer.INSTANCE.getMETADATA_SUSPEND_ARITY()), new JsIntLiteral(arity));
    }

    /*
     * WARNING - void declaration
     */
    private final JsPropertyInitializer generateSuperClasses() {
        List list2;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        boolean functionTypeOrSubtype = IrTypeUtilsKt.isFunctionTypeOrSubtype(IrUtilsKt.getDefaultType(this.irClass));
        Iterable iterable = this.irClass.getSuperTypes();
        JsExpression jsExpression = new JsNameRef(Namer.INSTANCE.getMETADATA_INTERFACES());
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JsNameRef jsNameRef;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrType it = (IrType)element$iv$iv;
            boolean bl2 = false;
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(it);
            if (irClassifierSymbol == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
            }
            IrClassSymbol symbol2 = (IrClassSymbol)irClassifierSymbol;
            if ((JsClassGeneratorKt.access$isInterface$p(symbol2) && !functionTypeOrSubtype && !JsClassGeneratorKt.access$isEffectivelyExternal$p(symbol2) ? new JsNameRef(this.context.getNameForClass((IrClass)symbol2.getOwner())) : null) == null) continue;
            jsNameRef = jsNameRef;
            boolean bl3 = false;
            boolean bl4 = false;
            JsNameRef it$iv$iv = jsNameRef;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = list2 = (List)destination$iv$iv;
        JsExpression jsExpression2 = new JsArrayLiteral(list3);
        JsExpression jsExpression3 = jsExpression;
        return new JsPropertyInitializer(jsExpression3, jsExpression2);
    }

    @NotNull
    public final JsGenerationContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public JsClassGenerator(@NotNull IrClass irClass, @NotNull JsGenerationContext context2) {
        JsName jsName;
        JsName jsName2;
        JsClassGenerator jsClassGenerator;
        Object object;
        block4: {
            void $this$firstOrNull$iv;
            Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            this.irClass = irClass;
            this.context = context2;
            this.className = this.context.getNameForClass(this.irClass);
            JsNameRef jsNameRef = this.className.makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"className.makeRef()");
            this.classNameRef = jsNameRef;
            object = this.irClass.getSuperTypes();
            jsClassGenerator = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrType it = (IrType)element$iv;
                boolean bl = false;
                if (!(!JsClassGeneratorKt.access$isInterface$p(IrTypesKt.getClassifierOrFail(it)))) continue;
                jsName2 = (JsName)element$iv;
                break block4;
            }
            jsName2 = null;
        }
        JsName jsName3 = jsName2;
        jsClassGenerator.baseClass = (IrType)((Object)jsName3);
        JsClassGenerator jsClassGenerator2 = this;
        IrType irType = this.baseClass;
        if (irType != null) {
            object = irType;
            jsClassGenerator = jsClassGenerator2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(this.baseClass).getOwner();
            if (irSymbolOwner == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            }
            jsName3 = this.context.getNameForClass((IrClass)irSymbolOwner);
            jsClassGenerator2 = jsClassGenerator;
            jsName = jsName3;
        } else {
            jsName = null;
        }
        jsClassGenerator2.baseClassName = jsName;
        this.classPrototypeRef = JsAstUtilsKt.prototypeOf(this.classNameRef);
        this.classBlock = new JsGlobalBlock();
        this.classModel = new JsIrClassModel(this.irClass);
    }

    public static final /* synthetic */ JsNameRef access$getClassPrototypeRef$p(JsClassGenerator $this) {
        return $this.classPrototypeRef;
    }
}

