/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J,\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J(\u0010&\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020%H\u0002J \u0010*\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020%H\u0002J \u0010-\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0002J \u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u0002002\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u00101\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\u0007H\u0002J(\u00102\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\tH\u0002J \u00106\u001a\u00020\u00182\u0006\u00107\u001a\u00020!2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u00108\u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u00109\u001a\u00020\u000eH\u0002J\u0010\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010>\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InlineChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "inlinableKtParameters", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "inlinableParameters", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "kotlin.jvm.PlatformType", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "isEffectivelyPrivateApiFunction", "", "<set-?>", "supportDefaultValueInline", "getSupportDefaultValueInline", "()Z", "setSupportDefaultValueInline", "(Z)V", "supportDefaultValueInline$delegate", "Lkotlin/properties/ReadWriteProperty;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallWithReceiver", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkLambdaInvokeOrExtensionCall", "lambdaDescriptor", "callDescriptor", "receiverExpression", "checkNonLocalReturn", "inlinableParameterDescriptor", "parameterUsage", "checkNotInDefaultParameter", "checkPrivateClassMemberAccess", "declarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkRecursion", "checkValueParameter", "targetArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "targetParameterDescriptor", "checkVisibilityAndAccess", "calledDescriptor", "getCalleeDescriptor", "unwrapVariableAsFunction", "isDefinedInInlineFunction", "startDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "isInsideCall", "isInvokeOrInlineExtension", "frontend"})
public final class InlineChecker
implements CallChecker {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final EffectiveVisibility inlineFunEffectiveVisibility;
    private final boolean isEffectivelyPrivateApiFunction;
    private final List<ValueParameterDescriptor> inlinableParameters;
    private final List<KtElement> inlinableKtParameters;
    private final ReadWriteProperty supportDefaultValueInline$delegate;
    private final FunctionDescriptor descriptor;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(InlineChecker.class), "supportDefaultValueInline", "getSupportDefaultValueInline()Z"))};
    }

    private final boolean getSupportDefaultValueInline() {
        return (Boolean)this.supportDefaultValueInline$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setSupportDefaultValueInline(boolean bl) {
        this.supportDefaultValueInline$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Object targetDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        KtExpression ktExpression = call2.getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"resolvedCall.call.calleeExpression ?: return");
        KtExpression expression2 = ktExpression;
        this.setSupportDefaultValueInline(context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineDefaultFunctionalParameters));
        Object obj = targetDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"targetDescriptor");
        if (PsiContractsUtilsKt.isFromContractDsl((DeclarationDescriptor)obj)) {
            return;
        }
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall2.getDispatchReceiver(), expression2);
        this.checkCallWithReceiver(context2, (CallableDescriptor)targetDescriptor, resolvedCall2.getExtensionReceiver(), expression2);
        if (CollectionsKt.contains((Iterable)this.inlinableParameters, targetDescriptor)) {
            if (this.checkNotInDefaultParameter(context2, (CallableDescriptor)targetDescriptor, expression2) && !this.isInsideCall(expression2)) {
                context2.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
            }
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"resolvedCall.valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map3 = map2;
        boolean bl = false;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            ValueParameterDescriptor valueDescriptor = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            ResolvedValueArgument value = entry2.getValue();
            if (value instanceof DefaultValueArgument) continue;
            ResolvedValueArgument resolvedValueArgument = value;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"value");
            Iterator<ValueArgument> iterator3 = resolvedValueArgument.getArguments().iterator();
            while (iterator3.hasNext()) {
                ValueArgument argument;
                ValueArgument valueArgument = argument = iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"argument");
                ValueParameterDescriptor valueParameterDescriptor = valueDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"valueDescriptor");
                this.checkValueParameter(context2, (CallableDescriptor)targetDescriptor, valueArgument, valueParameterDescriptor);
            }
        }
        this.checkVisibilityAndAccess((CallableDescriptor)targetDescriptor, expression2, context2);
        this.checkRecursion(context2, (CallableDescriptor)targetDescriptor, expression2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkNotInDefaultParameter(CallCheckerContext context2, CallableDescriptor targetDescriptor, KtExpression expression2) {
        boolean allow;
        void $this$getParentOfType$iv;
        if (!this.getSupportDefaultValueInline()) return true;
        PsiElement psiElement = expression2;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtParameter ktParameter = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtParameter.class, strict$iv);
        if (ktParameter == null) return true;
        psiElement = ktParameter;
        boolean bl = false;
        boolean bl2 = false;
        PsiElement it = psiElement;
        boolean bl3 = false;
        if (!this.inlinableKtParameters.contains(it)) {
            return true;
        }
        boolean bl4 = allow = false;
        if (!allow) {
            context2.getTrace().report(Errors.NOT_SUPPORTED_INLINE_PARAMETER_IN_INLINE_PARAMETER_DEFAULT_VALUE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
        }
        boolean bl5 = allow;
        if (!bl5) return false;
        return true;
    }

    private final boolean isInsideCall(KtExpression expression2) {
        KtToken token;
        KtExpression parent2 = KtPsiUtil.getParentCallIfPresent(expression2);
        if (parent2 instanceof KtBinaryExpression && ((token = KtPsiUtil.getOperationToken((KtOperationExpression)parent2)) == KtTokens.EQ || token == KtTokens.ANDAND || token == KtTokens.OROR)) {
            return false;
        }
        if (parent2 != null) {
            PsiElement current = expression2;
            while (current != parent2) {
                if (current instanceof KtBinaryExpressionWithTypeRHS) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)current.getParent(), (String)"current.parent");
            }
        }
        return parent2 != null;
    }

    private final void checkValueParameter(CallCheckerContext context2, CallableDescriptor targetDescriptor, ValueArgument targetArgument, ValueParameterDescriptor targetParameterDescriptor) {
        KtExpression ktExpression = targetArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        CallableDescriptor argumentCallee = this.getCalleeDescriptor(context2, argumentExpression, false);
        if (argumentCallee != null && CollectionsKt.contains((Iterable)this.inlinableParameters, (Object)argumentCallee)) {
            if (this.checkNotInDefaultParameter(context2, argumentCallee, argumentExpression)) {
                if (InlineUtil.isInline(targetDescriptor) && InlineUtil.isInlineParameter(targetParameterDescriptor)) {
                    if (InlineUtil.allowsNonLocalReturns(argumentCallee) && !InlineUtil.allowsNonLocalReturns(targetParameterDescriptor)) {
                        context2.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on((KtElement)((PsiElement)argumentExpression), argumentExpression));
                    } else {
                        this.checkNonLocalReturn(context2, argumentCallee, argumentExpression);
                    }
                } else {
                    context2.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)argumentExpression), argumentExpression, this.descriptor));
                }
            }
        }
    }

    private final void checkCallWithReceiver(CallCheckerContext context2, CallableDescriptor targetDescriptor, ReceiverValue receiver, KtExpression expression2) {
        if (receiver == null) {
            return;
        }
        CallableDescriptor varDescriptor = null;
        KtExpression receiverExpression = null;
        ReceiverValue receiverValue = receiver;
        if (receiverValue instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = this.getCalleeDescriptor(context2, receiverExpression, true);
        } else if (receiverValue instanceof ExtensionReceiver) {
            CallableDescriptor callableDescriptor = ((ExtensionReceiver)receiver).getDeclarationDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"receiver.declarationDescriptor");
            CallableDescriptor extension = callableDescriptor;
            varDescriptor = extension.getExtensionReceiverParameter();
            boolean bl = varDescriptor != null;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Extension should have receiverParameterDescriptor: " + extension;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            receiverExpression = expression2;
        } else {
            varDescriptor = null;
            receiverExpression = null;
        }
        if (CollectionsKt.contains((Iterable)this.inlinableParameters, (Object)varDescriptor)) {
            CallableDescriptor callableDescriptor = varDescriptor;
            if (callableDescriptor == null) {
                Intrinsics.throwNpe();
            }
            KtExpression ktExpression = receiverExpression;
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            this.checkLambdaInvokeOrExtensionCall(context2, callableDescriptor, targetDescriptor, ktExpression);
        }
    }

    private final CallableDescriptor getCalleeDescriptor(CallCheckerContext context2, KtExpression expression2, boolean unwrapVariableAsFunction) {
        if (!(expression2 instanceof KtSimpleNameExpression) && !(expression2 instanceof KtThisExpression)) {
            return null;
        }
        KtElement ktElement = expression2;
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> thisCall = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (unwrapVariableAsFunction && thisCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)thisCall)).getVariableCall().getResultingDescriptor();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = thisCall;
        return resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
    }

    private final void checkLambdaInvokeOrExtensionCall(CallCheckerContext context2, CallableDescriptor lambdaDescriptor, CallableDescriptor callDescriptor, KtExpression receiverExpression) {
        boolean inlinableCall = this.isInvokeOrInlineExtension(callDescriptor);
        if (!inlinableCall) {
            context2.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)receiverExpression), receiverExpression, this.descriptor));
        } else {
            this.checkNonLocalReturn(context2, lambdaDescriptor, receiverExpression);
        }
    }

    private final void checkRecursion(CallCheckerContext context2, CallableDescriptor targetDescriptor, KtElement expression2) {
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context2.getTrace().report(Errors.RECURSION_IN_INLINE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInvokeOrInlineExtension(CallableDescriptor descriptor2) {
        if (!(descriptor2 instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.getContainingDeclaration()");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (Intrinsics.areEqual((Object)descriptor2.getName(), (Object)OperatorNameConventions.INVOKE) && containingDeclaration instanceof ClassDescriptor) {
            SimpleType simpleType2 = ((ClassDescriptor)containingDeclaration).getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"containingDeclaration.defaultType");
            if (FunctionTypesKt.isBuiltinFunctionalType(simpleType2)) {
                return true;
            }
        }
        boolean bl = false;
        boolean isInvoke = bl;
        if (isInvoke) return true;
        if (!InlineUtil.isInline(descriptor2)) return false;
        return true;
    }

    private final void checkVisibilityAndAccess(CallableDescriptor calledDescriptor, KtElement expression2, CallCheckerContext context2) {
        EffectiveVisibility effectiveVisibility;
        if (this.isDefinedInInlineFunction(calledDescriptor)) {
            effectiveVisibility = EffectiveVisibility.Public.INSTANCE;
        } else {
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = calledDescriptor;
            Visibility visibility = calledDescriptor.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"calledDescriptor.visibility");
            effectiveVisibility = EffectiveVisibilityKt.effectiveVisibility(declarationDescriptorWithVisibility, visibility, true);
        }
        EffectiveVisibility calledFunEffectiveVisibility = effectiveVisibility;
        boolean isCalledFunPublicOrPublishedApi = calledFunEffectiveVisibility.getPublicApi();
        boolean isInlineFunPublicOrPublishedApi = this.inlineFunEffectiveVisibility.getPublicApi();
        if (isInlineFunPublicOrPublishedApi && !isCalledFunPublicOrPublishedApi && calledDescriptor.getVisibility() != Visibilities.LOCAL) {
            context2.getTrace().report(Errors.NON_PUBLIC_CALL_FROM_PUBLIC_INLINE.on((KtElement)((PsiElement)expression2), calledDescriptor, this.descriptor));
        } else {
            this.checkPrivateClassMemberAccess(calledDescriptor, expression2, context2);
        }
        if (!(calledDescriptor instanceof ConstructorDescriptor) && isInlineFunPublicOrPublishedApi && this.inlineFunEffectiveVisibility.toVisibility() != Visibilities.PROTECTED && calledFunEffectiveVisibility.toVisibility() == Visibilities.PROTECTED) {
            context2.getTrace().report(Errors.PROTECTED_CALL_FROM_PUBLIC_INLINE.on(expression2, calledDescriptor));
        }
    }

    private final void checkPrivateClassMemberAccess(DeclarationDescriptor declarationDescriptor, KtElement expression2, CallCheckerContext context2) {
        if (!this.isEffectivelyPrivateApiFunction && DescriptorUtilsKt.isInsidePrivateClass(declarationDescriptor)) {
            context2.getTrace().report(Errors.PRIVATE_CLASS_MEMBER_FROM_INLINE.on((KtElement)((PsiElement)expression2), declarationDescriptor, this.descriptor));
        }
    }

    private final boolean isDefinedInInlineFunction(DeclarationDescriptorWithVisibility startDescriptor) {
        DeclarationDescriptorWithVisibility parent2 = startDescriptor;
        while (parent2 != null) {
            if (parent2.getContainingDeclaration() == this.descriptor) {
                return true;
            }
            parent2 = DescriptorUtils.getParentOfType(parent2, DeclarationDescriptorWithVisibility.class);
        }
        return false;
    }

    private final void checkNonLocalReturn(CallCheckerContext context2, CallableDescriptor inlinableParameterDescriptor, KtExpression parameterUsage) {
        if (!InlineUtil.allowsNonLocalReturns(inlinableParameterDescriptor)) {
            return;
        }
        if (!InlineUtil.checkNonLocalReturnUsage(this.descriptor, parameterUsage, context2.getResolutionContext())) {
            context2.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on((KtElement)((PsiElement)parameterUsage), parameterUsage));
        }
    }

    /*
     * WARNING - void declaration
     */
    public InlineChecker(@NotNull FunctionDescriptor descriptor2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List list2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        this.descriptor = descriptor2;
        boolean bl = InlineUtil.isInline(this.descriptor);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InlineChecker$22 = false;
            String $i$a$-assert-InlineChecker$22 = "This extension should be created only for inline functions: " + this.descriptor;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-InlineChecker$22));
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = this.descriptor;
        Visibility visibility = this.descriptor.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"descriptor.visibility");
        this.inlineFunEffectiveVisibility = EffectiveVisibilityKt.effectiveVisibility(declarationDescriptorWithVisibility, visibility, true);
        this.isEffectivelyPrivateApiFunction = DescriptorUtilsKt.isEffectivelyPrivateApi(this.descriptor);
        List<ValueParameterDescriptor> list3 = this.descriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"descriptor.valueParameters");
        Iterable iterable = list3;
        InlineChecker inlineChecker = this;
        boolean $i$f$filter = false;
        void $i$a$-assert-InlineChecker$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl3 = false;
            if (!InlineUtil.isInlineParameter(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        inlineChecker.inlinableParameters = list2 = (List)destination$iv$iv;
        $this$filter$iv = this.inlinableParameters;
        inlineChecker = this;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtElement ktElement;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            boolean bl5 = false;
            ValueParameterDescriptor valueParameterDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
            SourceElement sourceElement = valueParameterDescriptor.getSource();
            if (!(sourceElement instanceof KotlinSourceElement)) {
                sourceElement = null;
            }
            KotlinSourceElement kotlinSourceElement = (KotlinSourceElement)sourceElement;
            if ((kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null) == null) continue;
            ktElement = ktElement;
            boolean bl6 = false;
            boolean bl7 = false;
            KtElement it$iv$iv = ktElement;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        inlineChecker.inlinableKtParameters = list2 = (List)destination$iv$iv;
        this.supportDefaultValueInline$delegate = Delegates.INSTANCE.notNull();
    }
}

