/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.CollectionPropertyInternal;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.Collectors;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValidatingValueCollector;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.Provider;
import org.gradle.internal.DisplayName;

public abstract class AbstractCollectionProperty<T, C extends Collection<T>>
extends AbstractProperty<C>
implements CollectionPropertyInternal<T, C> {
    private static final Collectors.EmptyCollection EMPTY_COLLECTION = new Collectors.EmptyCollection();
    private static final Collectors.NoValueCollector NO_VALUE_COLLECTOR = new Collectors.NoValueCollector();
    private final Class<? extends Collection> collectionType;
    private final Class<T> elementType;
    private final ValueCollector<T> valueCollector;
    private Collector<T> convention = NO_VALUE_COLLECTOR;
    private Collector<T> defaultValue = EMPTY_COLLECTION;
    private Collector<T> value;

    AbstractCollectionProperty(Class<? extends Collection> collectionType, Class<T> elementType) {
        this.applyDefaultValue();
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.valueCollector = new ValidatingValueCollector<T>(collectionType, elementType, ValueSanitizers.forType(elementType));
    }

    @Override
    protected ValueSupplier getSupplier() {
        return this.value;
    }

    protected abstract C fromValue(Collection<T> var1);

    public void add(T element) {
        Preconditions.checkNotNull(element, (Object)String.format("Cannot add a null element to a property of type %s.", this.collectionType.getSimpleName()));
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.SingleElement<T>(element));
    }

    public void add(Provider<? extends T> providerOfElement) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementFromProvider<T>(Providers.internal(providerOfElement)));
    }

    public void addAll(T ... elements) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementsFromArray<T>(elements));
    }

    public void addAll(Iterable<? extends T> elements) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementsFromCollection<T>(elements));
    }

    public void addAll(Provider<? extends Iterable<? extends T>> provider) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementsFromCollectionProvider(Providers.internal(provider)));
    }

    private void addCollector(Collector<T> collector) {
        this.value = new PlusCollector<T>(this.value, collector);
    }

    @Override
    @Nullable
    public Class<C> getType() {
        return this.collectionType;
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    public List<ProviderInternal<? extends Iterable<? extends T>>> getProviders() {
        ArrayList sources = new ArrayList();
        this.value.visit(sources);
        return sources;
    }

    public void providers(List<ProviderInternal<? extends Iterable<? extends T>>> providers) {
        if (!this.beforeMutate()) {
            return;
        }
        this.value = this.defaultValue;
        for (ProviderInternal<Iterable<T>> providerInternal : providers) {
            this.value = new PlusCollector<T>(this.value, new Collectors.ElementsFromCollectionProvider<T>(providerInternal));
        }
    }

    @Override
    public boolean isPresent() {
        this.beforeRead();
        return this.value.present();
    }

    public C get() {
        this.beforeRead();
        ArrayList values = new ArrayList();
        this.value.collectInto(this.getDisplayName(), this.valueCollector, values);
        return this.fromValue(values);
    }

    @Override
    @Nullable
    public C getOrNull() {
        this.beforeRead();
        return this.doGetOrNull();
    }

    @Nullable
    private C doGetOrNull() {
        ArrayList values = new ArrayList();
        if (!this.value.maybeCollectInto(this.valueCollector, values)) {
            return null;
        }
        return this.fromValue(values);
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            if (object != null && !(object instanceof Iterable)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.collectionType.getName(), object.getClass().getName()));
            }
            this.set((Iterable)object);
        }
    }

    public void set(@Nullable Iterable<? extends T> elements) {
        if (elements == null) {
            if (this.beforeReset()) {
                this.set(this.convention);
                this.defaultValue = NO_VALUE_COLLECTOR;
            }
            return;
        }
        if (this.beforeMutate()) {
            this.set(new Collectors.ElementsFromCollection<T>(elements));
        }
    }

    public void set(Provider<? extends Iterable<? extends T>> provider) {
        CollectionPropertyInternal collectionProp;
        if (!this.beforeMutate()) {
            return;
        }
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal<Iterable<T>> p = Providers.internal(provider);
        if (p.getType() != null && !Iterable.class.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", this.collectionType.getName(), p.getType().getName()));
        }
        if (p instanceof CollectionPropertyInternal && !this.elementType.isAssignableFrom((collectionProp = (CollectionPropertyInternal)p).getElementType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s with element type %s using a provider with element type %s.", this.collectionType.getName(), this.elementType.getName(), collectionProp.getElementType().getName()));
        }
        this.set(new Collectors.ElementsFromCollectionProvider(p));
    }

    public HasMultipleValues<T> value(@Nullable Iterable<? extends T> elements) {
        this.set(elements);
        return this;
    }

    public HasMultipleValues<T> value(Provider<? extends Iterable<? extends T>> provider) {
        this.set(provider);
        return this;
    }

    public HasMultipleValues<T> empty() {
        if (!this.beforeMutate()) {
            return this;
        }
        this.set(EMPTY_COLLECTION);
        return this;
    }

    @Override
    protected void applyDefaultValue() {
        this.value = this.defaultValue;
    }

    @Override
    protected void makeFinal() {
        C collection = this.doGetOrNull();
        if (collection != null) {
            this.set(new Collectors.ElementsFromCollection(collection));
        } else {
            this.set(NO_VALUE_COLLECTOR);
        }
        this.convention = NO_VALUE_COLLECTOR;
    }

    private void set(Collector<T> collector) {
        this.value = collector;
    }

    public HasMultipleValues<T> convention(Iterable<? extends T> elements) {
        this.convention(new Collectors.ElementsFromCollection<T>(elements));
        return this;
    }

    public HasMultipleValues<T> convention(Provider<? extends Iterable<? extends T>> provider) {
        this.convention(new Collectors.ElementsFromCollectionProvider(Providers.internal(provider)));
        return this;
    }

    private void convention(Collector<T> collector) {
        if (this.shouldApplyConvention()) {
            this.value = collector;
        }
        this.convention = collector;
    }

    @Override
    protected String describeContents() {
        return String.format("%s(%s, %s)", this.collectionType.getSimpleName().toLowerCase(), this.elementType, this.value.toString());
    }

    private static class PlusCollector<T>
    implements Collector<T> {
        private final Collector<T> left;
        private final Collector<T> right;

        public PlusCollector(Collector<T> left, Collector<T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean present() {
            return this.left.present() && this.right.present();
        }

        @Override
        public int size() {
            return this.left.size() + this.right.size();
        }

        @Override
        public void collectInto(DisplayName owner, ValueCollector<T> collector, Collection<T> dest) {
            this.left.collectInto(owner, collector, dest);
            this.right.collectInto(owner, collector, dest);
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> dest) {
            if (this.left.maybeCollectInto(collector, dest)) {
                return this.right.maybeCollectInto(collector, dest);
            }
            return false;
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            this.left.visit(sources);
            this.right.visit(sources);
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            if (this.left.maybeVisitBuildDependencies(context)) {
                return this.right.maybeVisitBuildDependencies(context);
            }
            return false;
        }

        @Override
        public boolean isContentProducedByTask() {
            return this.left.isContentProducedByTask() || this.right.isContentProducedByTask();
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.left.isValueProducedByTask() || this.right.isValueProducedByTask();
        }
    }
}

