/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.Nullability;
import org.jetbrains.kotlin.com.intellij.codeInsight.NullabilityAnnotationInfo;
import org.jetbrains.kotlin.com.intellij.codeInsight.NullableNotNullManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassObjectAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

class CheckerFrameworkNullityUtil {
    @Nullable
    static NullabilityAnnotationInfo isCheckerDefault(PsiAnnotation anno, PsiAnnotation.TargetType[] types2) {
        String qName = anno.getQualifiedName();
        if ("org.checkerframework.framework.qual.DefaultQualifier".equals(qName)) {
            PsiClass valueClass;
            PsiAnnotationMemberValue value = anno.findAttributeValue("value");
            if (value instanceof PsiClassObjectAccessExpression && CheckerFrameworkNullityUtil.hasAppropriateTarget(types2, anno.findAttributeValue("locations")) && (valueClass = PsiUtil.resolveClassInClassTypeOnly(((PsiClassObjectAccessExpression)value).getOperand().getType())) != null) {
                NullableNotNullManager instance = NullableNotNullManager.getInstance(value.getProject());
                if (instance.getNullables().contains(valueClass.getQualifiedName())) {
                    return new NullabilityAnnotationInfo(anno, Nullability.NULLABLE, true);
                }
                if (instance.getNotNulls().contains(valueClass.getQualifiedName())) {
                    return new NullabilityAnnotationInfo(anno, Nullability.NOT_NULL, true);
                }
            }
            return null;
        }
        if ("org.checkerframework.framework.qual.DefaultQualifiers".equals(qName)) {
            PsiAnnotationMemberValue value = anno.findAttributeValue("value");
            for (PsiAnnotationMemberValue initializer2 : AnnotationUtil.arrayAttributeValues(value)) {
                NullabilityAnnotationInfo result2;
                if (!(initializer2 instanceof PsiAnnotation) || (result2 = CheckerFrameworkNullityUtil.isCheckerDefault((PsiAnnotation)initializer2, types2)) == null) continue;
                return result2;
            }
        }
        return null;
    }

    private static boolean hasAppropriateTarget(PsiAnnotation.TargetType[] types2, PsiAnnotationMemberValue locations) {
        Set<String> locationNames = ContainerUtil.map2SetNotNull(AnnotationUtil.arrayAttributeValues(locations), l -> l instanceof PsiReferenceExpression ? ((PsiReferenceExpression)l).getReferenceName() : null);
        if (locationNames.contains("ALL")) {
            return true;
        }
        for (PsiAnnotation.TargetType type2 : types2) {
            if (type2 == PsiAnnotation.TargetType.FIELD) {
                return locationNames.contains("FIELD");
            }
            if (type2 == PsiAnnotation.TargetType.METHOD) {
                return locationNames.contains("RETURN");
            }
            if (type2 != PsiAnnotation.TargetType.PARAMETER) continue;
            return locationNames.contains("PARAMETER");
        }
        return false;
    }
}

