/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

public abstract class AbstractMappingProvider<OUT, IN>
extends AbstractMinimalProvider<OUT> {
    private final Class<OUT> type;
    private final ProviderInternal<? extends IN> provider;

    public AbstractMappingProvider(Class<OUT> type, ProviderInternal<? extends IN> provider) {
        this.type = type;
        this.provider = provider;
    }

    @Override
    @Nullable
    public Class<OUT> getType() {
        return this.type;
    }

    public ProviderInternal<? extends IN> getProvider() {
        return this.provider;
    }

    @Override
    public boolean isValueProducedByTask() {
        return this.provider.isContentProducedByTask();
    }

    @Override
    public boolean isContentProducedByTask() {
        return this.provider.isContentProducedByTask();
    }

    @Override
    public boolean isPresent() {
        return this.provider.isPresent();
    }

    public OUT get() {
        return this.mapValue(this.provider.get());
    }

    @Override
    public OUT getOrNull() {
        Object value = this.provider.getOrNull();
        if (value != null) {
            return this.mapValue(value);
        }
        return null;
    }

    protected abstract OUT mapValue(IN var1);

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        return this.provider.maybeVisitBuildDependencies(context);
    }

    @Override
    public String toString() {
        return "map(" + this.provider + ")";
    }
}

