/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.internal.DisplayName;

public class Collectors {

    public static class TypedCollector<T>
    implements ProvidedCollector<T> {
        private final Class<? extends T> type;
        protected final Collector<T> delegate;
        private final ValueCollector<T> valueCollector;

        public TypedCollector(@Nullable Class<? extends T> type, Collector<T> delegate) {
            this.type = type;
            this.delegate = delegate;
            this.valueCollector = ValueSanitizers.collectorFor(type);
        }

        @Nullable
        public Class<? extends T> getType() {
            return this.type;
        }

        @Override
        public boolean present() {
            return this.delegate.present();
        }

        public void collectInto(Collection<T> collection) {
            this.delegate.collectInto(null, this.valueCollector, collection);
        }

        @Override
        public void collectInto(DisplayName owner, ValueCollector<T> collector, Collection<T> dest) {
            this.delegate.collectInto(owner, collector, dest);
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> dest) {
            return this.delegate.maybeCollectInto(collector, dest);
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return this.delegate instanceof ProvidedCollector && ((ProvidedCollector)this.delegate).isProvidedBy(provider);
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            this.delegate.visit(sources);
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return this.delegate.maybeVisitBuildDependencies(context);
        }

        @Override
        public boolean isContentProducedByTask() {
            return this.delegate.isContentProducedByTask();
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.delegate.isValueProducedByTask();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedCollector that = (TypedCollector)o;
            return Objects.equal(this.type, that.type) && Objects.equal(this.delegate, that.delegate);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.delegate});
        }
    }

    public static class ElementsFromArray<T>
    implements Collector<T> {
        private final T[] value;

        ElementsFromArray(T[] value) {
            this.value = value;
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(DisplayName owner, ValueCollector<T> collector, Collection<T> dest) {
            for (T t : this.value) {
                collector.add(t, dest);
            }
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> dest) {
            this.collectInto(null, collector, dest);
            return true;
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            sources.add(Providers.of(ImmutableList.copyOf((Object[])this.value)));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return false;
        }

        @Override
        public boolean isContentProducedByTask() {
            return false;
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }

        @Override
        public int size() {
            return this.value.length;
        }
    }

    public static class NoValueCollector
    implements Collector<Object> {
        @Override
        public boolean present() {
            return false;
        }

        @Override
        public void collectInto(DisplayName owner, ValueCollector<Object> collector, Collection<Object> dest) {
            throw Providers.nullValue((Describable)owner);
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<Object> collector, Collection<Object> collection) {
            return false;
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<?>>> sources) {
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return true;
        }

        @Override
        public boolean isContentProducedByTask() {
            return false;
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    public static class ElementsFromCollectionProvider<T>
    implements ProvidedCollector<T> {
        private final ProviderInternal<? extends Iterable<? extends T>> provider;

        public ElementsFromCollectionProvider(ProviderInternal<? extends Iterable<? extends T>> provider) {
            this.provider = provider;
        }

        @Override
        public boolean present() {
            return this.provider.isPresent();
        }

        @Override
        public void collectInto(DisplayName owner, ValueCollector<T> collector, Collection<T> collection) {
            Iterable value = (Iterable)this.provider.get();
            collector.addAll(value, collection);
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> collection) {
            Iterable value = (Iterable)this.provider.getOrNull();
            if (value == null) {
                return false;
            }
            collector.addAll(value, collection);
            return true;
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            sources.add(this.provider);
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return this.provider.maybeVisitBuildDependencies(context);
        }

        @Override
        public boolean isContentProducedByTask() {
            return this.provider.isContentProducedByTask();
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.provider.isValueProducedByTask();
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return Objects.equal(provider, provider);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementsFromCollectionProvider that = (ElementsFromCollectionProvider)o;
            return Objects.equal(this.provider, that.provider);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.provider});
        }

        @Override
        public int size() {
            if (this.provider instanceof CollectionProviderInternal) {
                return ((CollectionProviderInternal)this.provider).size();
            }
            throw new UnsupportedOperationException();
        }
    }

    public static class ElementsFromCollection<T>
    implements Collector<T> {
        private final Iterable<? extends T> value;

        public ElementsFromCollection(Iterable<? extends T> value) {
            this.value = value;
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(DisplayName owner, ValueCollector<T> collector, Collection<T> collection) {
            collector.addAll(this.value, collection);
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> collection) {
            collector.addAll(this.value, collection);
            return true;
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            sources.add(Providers.of(this.value));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return false;
        }

        @Override
        public boolean isContentProducedByTask() {
            return false;
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementsFromCollection that = (ElementsFromCollection)o;
            return Objects.equal(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value});
        }

        @Override
        public int size() {
            return Iterables.size(this.value);
        }
    }

    public static class ElementFromProvider<T>
    implements ProvidedCollector<T> {
        private final ProviderInternal<? extends T> providerOfElement;

        public ElementFromProvider(ProviderInternal<? extends T> providerOfElement) {
            this.providerOfElement = providerOfElement;
        }

        @Override
        public boolean present() {
            return this.providerOfElement.isPresent();
        }

        @Override
        public void collectInto(DisplayName owner, ValueCollector<T> collector, Collection<T> collection) {
            Object value = this.providerOfElement.get();
            collector.add(value, collection);
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> collection) {
            Object value = this.providerOfElement.getOrNull();
            if (value == null) {
                return false;
            }
            collector.add(value, collection);
            return true;
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return Objects.equal(provider, this.providerOfElement);
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            sources.add((ProviderInternal<Iterable<T>>)this.providerOfElement.map(e -> ImmutableList.of((Object)e)));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return this.providerOfElement.maybeVisitBuildDependencies(context);
        }

        @Override
        public boolean isContentProducedByTask() {
            return this.providerOfElement.isContentProducedByTask();
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.providerOfElement.isValueProducedByTask();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementFromProvider that = (ElementFromProvider)o;
            return Objects.equal(this.providerOfElement, that.providerOfElement);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.providerOfElement});
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static class SingleElement<T>
    implements Collector<T> {
        private final T element;

        public SingleElement(T element) {
            this.element = element;
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(DisplayName owner, ValueCollector<T> collector, Collection<T> collection) {
            collector.add(this.element, collection);
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<T> collector, Collection<T> collection) {
            collector.add(this.element, collection);
            return true;
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<? extends T>>> sources) {
            sources.add(Providers.of(ImmutableList.of(this.element)));
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return false;
        }

        @Override
        public boolean isContentProducedByTask() {
            return false;
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleElement that = (SingleElement)o;
            return Objects.equal(this.element, that.element);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.element});
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static class EmptyCollection
    implements Collector<Object> {
        @Override
        public boolean present() {
            return true;
        }

        @Override
        public boolean maybeCollectInto(ValueCollector<Object> collector, Collection<Object> collection) {
            return true;
        }

        @Override
        public void collectInto(DisplayName owner, ValueCollector<Object> collector, Collection<Object> dest) {
        }

        @Override
        public void visit(List<ProviderInternal<? extends Iterable<?>>> sources) {
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return true;
        }

        @Override
        public boolean isContentProducedByTask() {
            return false;
        }

        @Override
        public boolean isValueProducedByTask() {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    public static interface ProvidedCollector<T>
    extends Collector<T> {
        public boolean isProvidedBy(Provider<?> var1);
    }
}

