/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.multiproject;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryBase;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryJvm;
import org.jetbrains.kotlin.incremental.multiproject.ModulesApiHistoryKt;
import org.jetbrains.kotlin.incremental.util.Either;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\r\u001a\u00020\nH\u0014J*\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryAndroid;", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryBase;", "modulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "(Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;)V", "delegate", "Lorg/jetbrains/kotlin/incremental/multiproject/ModulesApiHistoryJvm;", "getBuildHistoryFilesForJar", "Lorg/jetbrains/kotlin/incremental/util/Either;", "", "Ljava/io/File;", "jar", "getBuildHistoryForDir", "file", "getHistoryForModuleNames", "path", "Ljava/nio/file/Path;", "moduleNames", "", "", "getPossibleModuleNamesForDir", "", "getPossibleModuleNamesFromJar", "", "historyFilesForChangedFiles", "changedFiles", "incremental-compilation-impl"})
public final class ModulesApiHistoryAndroid
extends ModulesApiHistoryBase {
    private final ModulesApiHistoryJvm delegate;

    @Override
    @NotNull
    public Either<Set<File>> historyFilesForChangedFiles(@NotNull Set<? extends File> changedFiles) {
        Intrinsics.checkParameterIsNotNull(changedFiles, (String)"changedFiles");
        Either<Set<File>> historyFromDelegate = this.delegate.historyFilesForChangedFiles(changedFiles);
        if (historyFromDelegate instanceof Either.Success) {
            return historyFromDelegate;
        }
        return super.historyFilesForChangedFiles(changedFiles);
    }

    @Override
    @NotNull
    protected Either<Set<File>> getBuildHistoryFilesForJar(@NotNull File jar) {
        Path jarPath;
        Intrinsics.checkParameterIsNotNull((Object)jar, (String)"jar");
        if (!ModulesApiHistoryKt.access$isParentOf(this.getProjectRootPath(), jar)) {
            return new Either.Error("Non-project jar is modified " + jar);
        }
        Path path2 = jarPath = Paths.get(jar.getAbsolutePath(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"jarPath");
        return this.getHistoryForModuleNames(path2, (Iterable<String>)this.getPossibleModuleNamesFromJar(jarPath));
    }

    @Override
    @NotNull
    protected Either<Set<File>> getBuildHistoryForDir(@NotNull File file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!ModulesApiHistoryKt.access$isParentOf(this.getProjectRootPath(), file2)) {
            return new Either.Error("Non-project file while looking for history " + file2);
        }
        List moduleNames = CollectionsKt.plus((Collection)this.getPossibleModuleNamesForDir(FilesKt.resolve((File)file2, (String)"meta-inf")), (Iterable)this.getPossibleModuleNamesForDir(FilesKt.resolve((File)file2, (String)"META-INF")));
        if (moduleNames.isEmpty()) {
            Either either;
            if (file2.getParentFile() == null) {
                either = new Either.Error("Unable to find history for " + file2);
            } else {
                File file3 = file2.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file.parentFile");
                either = this.getBuildHistoryForDir(file3);
            }
            return either;
        }
        Path path2 = file2.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file.toPath()");
        return this.getHistoryForModuleNames(path2, moduleNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Collection<String> getPossibleModuleNamesFromJar(Path path2) {
        HashSet<String> result2 = new HashSet<String>();
        try {
            Closeable closeable = new ZipFile(path2.toFile());
            boolean bl = false;
            Throwable throwable = null;
            try {
                ZipFile zip2 = (ZipFile)closeable;
                boolean bl2 = false;
                Enumeration<? extends ZipEntry> entries2 = zip2.entries();
                while (entries2.hasMoreElements()) {
                    String name;
                    ZipEntry entry;
                    ZipEntry zipEntry = entry = entries2.nextElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"entry");
                    String string = name = zipEntry.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                    if (!StringsKt.endsWith((String)string, (String)".kotlin_module", (boolean)true)) continue;
                    result2.add(FilesKt.getNameWithoutExtension((File)new File(name)));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable t) {
            return CollectionsKt.emptyList();
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPossibleModuleNamesForDir(File path2) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        if (!path2.isDirectory()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        File[] fileArray = path2.listFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"path.listFiles()");
        File[] $this$filter$iv = fileArray;
        boolean $i$f$filter = false;
        File[] fileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv;
        int n = ((void)iterator2).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = iterator2[i];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = v1.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
            if (!StringsKt.endsWith((String)string, (String)".kotlin_module", (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            String string = FilesKt.getNameWithoutExtension((File)v3);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Either<Set<File>> getHistoryForModuleNames(Path path2, Iterable<String> moduleNames) {
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        void $this$flatMapTo$iv;
        Iterable<String> iterable = moduleNames;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Set<IncrementalModuleEntry> set = this.getModulesInfo().getNameToModules().get(it);
            Iterable list$iv = set != null ? (Iterable)set : (Iterable)SetsKt.emptySet();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet possibleModules = (HashSet)destination$iv;
        Iterable $this$filter$iv = possibleModules;
        boolean $i$f$filter22 = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IncrementalModuleEntry it = (IncrementalModuleEntry)element$iv$iv;
            boolean bl = false;
            Path path3 = Paths.get(it.getBuildDir().getAbsolutePath(), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(it.buildDir.absolutePath)");
            if (!ModulesApiHistoryKt.access$isParentOf(path3, path2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modules = (List)destination$iv$iv;
        if (modules.isEmpty()) {
            return new Either.Error("Unknown module for " + path2 + " (candidates: " + CollectionsKt.joinToString$default((Iterable)possibleModules, null, null, null, (int)0, null, null, (int)63, null) + ')');
        }
        Iterable $i$f$filter22 = modules;
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (IncrementalModuleEntry)item$iv;
            Collection collection = destination$iv2;
            boolean bl = false;
            File file2 = it.getBuildHistoryFile();
            collection.add(file2);
        }
        HashSet result2 = (HashSet)destination$iv2;
        return new Either.Success<HashSet>(result2);
    }

    public ModulesApiHistoryAndroid(@NotNull IncrementalModuleInfo modulesInfo) {
        Intrinsics.checkParameterIsNotNull((Object)modulesInfo, (String)"modulesInfo");
        super(modulesInfo);
        this.delegate = new ModulesApiHistoryJvm(modulesInfo);
    }
}

