/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.api.tasks.TaskState;
import org.gradle.execution.taskgraph.TaskListenerInternal;
import org.gradle.internal.logging.slf4j.ContextAwareTaskLogger;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CallableBuildOperation;

public class EventFiringTaskExecuter
implements TaskExecuter {
    private final BuildOperationExecutor buildOperationExecutor;
    private final TaskExecutionListener taskExecutionListener;
    private final TaskListenerInternal taskListener;
    private final TaskExecuter delegate;

    public EventFiringTaskExecuter(BuildOperationExecutor buildOperationExecutor, TaskExecutionListener taskExecutionListener, TaskListenerInternal taskListener, TaskExecuter delegate) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.taskExecutionListener = taskExecutionListener;
        this.taskListener = taskListener;
        this.delegate = delegate;
    }

    @Override
    public TaskExecuterResult execute(final TaskInternal task, final TaskStateInternal state, final TaskExecutionContext context) {
        return (TaskExecuterResult)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<TaskExecuterResult>(){

            public TaskExecuterResult call(BuildOperationContext operationContext) {
                TaskExecuterResult result = this.executeTask(operationContext);
                operationContext.setStatus(state.getFailure() != null ? "FAILED" : state.getSkipMessage());
                operationContext.failed(state.getFailure());
                return result;
            }

            private TaskExecuterResult executeTask(BuildOperationContext operationContext) {
                Logger logger = task.getLogger();
                ContextAwareTaskLogger contextAwareTaskLogger = null;
                try {
                    EventFiringTaskExecuter.this.taskListener.beforeExecute(task.getTaskIdentity());
                    EventFiringTaskExecuter.this.taskExecutionListener.beforeExecute((Task)task);
                    BuildOperationRef currentOperation = EventFiringTaskExecuter.this.buildOperationExecutor.getCurrentOperation();
                    if (logger instanceof ContextAwareTaskLogger) {
                        contextAwareTaskLogger = (ContextAwareTaskLogger)logger;
                        contextAwareTaskLogger.setFallbackBuildOperationId(currentOperation.getId());
                    }
                }
                catch (Throwable t) {
                    state.setOutcome((RuntimeException)((Object)new TaskExecutionException(task, t)));
                    return TaskExecuterResult.WITHOUT_OUTPUTS;
                }
                TaskExecuterResult result = EventFiringTaskExecuter.this.delegate.execute(task, state, context);
                if (contextAwareTaskLogger != null) {
                    contextAwareTaskLogger.setFallbackBuildOperationId(null);
                }
                operationContext.setResult((Object)new ExecuteTaskBuildOperationResult(state, result.getCachingState(), result.getReusedOutputOriginMetadata().orElse(null), result.executedIncrementally(), result.getExecutionReasons()));
                try {
                    EventFiringTaskExecuter.this.taskExecutionListener.afterExecute((Task)task, (TaskState)state);
                    EventFiringTaskExecuter.this.taskListener.afterExecute(task.getTaskIdentity(), state);
                }
                catch (Throwable t) {
                    state.addFailure(new TaskExecutionException(task, t));
                }
                return result;
            }

            public BuildOperationDescriptor.Builder description() {
                ExecuteTaskBuildOperationDetails taskOperation = new ExecuteTaskBuildOperationDetails(context.getLocalTaskNode());
                return BuildOperationDescriptor.displayName((String)("Task " + task.getIdentityPath())).name(task.getIdentityPath().toString()).progressDisplayName(task.getIdentityPath().toString()).operationType(BuildOperationCategory.TASK).details((Object)taskOperation);
            }
        });
    }
}

