/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.gradle.cache.internal.FileContentCache;
import org.gradle.cache.internal.FileContentCacheFactory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.vfs.AdditiveCacheLocations;

public class SplitFileContentCacheFactory
implements FileContentCacheFactory,
Closeable {
    private final FileContentCacheFactory globalFactory;
    private final FileContentCacheFactory localFactory;
    private final AdditiveCacheLocations additiveCacheLocations;

    public SplitFileContentCacheFactory(FileContentCacheFactory globalFactory, FileContentCacheFactory localFactory, AdditiveCacheLocations additiveCacheLocations) {
        this.globalFactory = globalFactory;
        this.localFactory = localFactory;
        this.additiveCacheLocations = additiveCacheLocations;
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable((Object[])new Object[]{this.localFactory}).stop();
    }

    public <V> FileContentCache<V> newCache(String name, int normalizedCacheSize, FileContentCacheFactory.Calculator<? extends V> calculator, Serializer<V> serializer) {
        FileContentCache globalCache = this.globalFactory.newCache(name, normalizedCacheSize, calculator, serializer);
        FileContentCache localCache = this.localFactory.newCache(name, normalizedCacheSize, calculator, serializer);
        return new SplitFileContentCache(globalCache, localCache, this.additiveCacheLocations);
    }

    private static final class SplitFileContentCache<V>
    implements FileContentCache<V> {
        private final FileContentCache<V> globalCache;
        private final FileContentCache<V> localCache;
        private final AdditiveCacheLocations additiveCacheLocations;

        private SplitFileContentCache(FileContentCache<V> globalCache, FileContentCache<V> localCache, AdditiveCacheLocations additiveCacheLocations) {
            this.globalCache = globalCache;
            this.localCache = localCache;
            this.additiveCacheLocations = additiveCacheLocations;
        }

        public V get(File file) {
            if (this.additiveCacheLocations.isInsideAdditiveCache(file.getPath())) {
                return (V)this.globalCache.get(file);
            }
            return (V)this.localCache.get(file);
        }
    }
}

