/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.model;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;

public class Checksum {
    private final ChecksumKind kind;
    private final String value;
    private final Set<String> alternatives;
    private final String origin;
    private final int hashCode;

    public Checksum(ChecksumKind kind, String value, @Nullable Set<String> alternatives, @Nullable String origin) {
        this.kind = kind;
        this.value = value;
        this.alternatives = alternatives == null ? null : ImmutableSet.copyOf(alternatives);
        this.origin = origin;
        this.hashCode = this.computeHashcode();
    }

    private int computeHashcode() {
        int result = this.kind.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + (this.alternatives != null ? this.alternatives.hashCode() : 0);
        result = 31 * result + (this.origin != null ? this.origin.hashCode() : 0);
        return result;
    }

    public ChecksumKind getKind() {
        return this.kind;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public Set<String> getAlternatives() {
        return this.alternatives;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checksum checksum = (Checksum)o;
        if (this.kind != checksum.kind) {
            return false;
        }
        if (!this.value.equals(checksum.value)) {
            return false;
        }
        if (this.alternatives != null ? !this.alternatives.equals(checksum.alternatives) : checksum.alternatives != null) {
            return false;
        }
        return this.origin != null ? this.origin.equals(checksum.origin) : checksum.origin == null;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

