/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Namer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.collections.FilteredList;
import org.gradle.api.internal.collections.IndexedElementSource;
import org.gradle.api.internal.collections.ListElementSource;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.DeprecationLogger;

public class DefaultNamedDomainObjectList<T>
extends DefaultNamedDomainObjectCollection<T>
implements NamedDomainObjectList<T> {
    public DefaultNamedDomainObjectList(DefaultNamedDomainObjectList<? super T> objects, CollectionFilter<T> filter, Instantiator instantiator, Namer<? super T> namer) {
        super(objects, filter, instantiator, namer);
    }

    @Deprecated
    public DefaultNamedDomainObjectList(Class<T> type, Instantiator instantiator, Namer<? super T> namer) {
        super(type, new ListElementSource(), instantiator, namer, CollectionCallbackActionDecorator.NOOP);
        DeprecationLogger.nagUserOfDeprecated((String)"Internal API constructor DefaultNamedDomainObjectList(Class<T>, Instantiator, Namer<T>)", (String)"Please use ObjectFactory.namedDomainObjectList(Class<T>) instead.");
    }

    public DefaultNamedDomainObjectList(Class<T> type, Instantiator instantiator, Namer<? super T> namer, CollectionCallbackActionDecorator decorator) {
        super(type, new ListElementSource(), instantiator, namer, decorator);
    }

    public void add(int index, T element) {
        this.assertMutable("add(int, T)");
        this.assertCanAdd(element);
        this.getStore().add(index, element);
        this.didAdd(element);
        this.getEventRegister().fireObjectAdded(element);
    }

    public boolean addAll(int index, Collection<? extends T> c) {
        this.assertMutable("addAll(int, Collection)");
        boolean changed = false;
        int current = index;
        for (T t : c) {
            if (this.hasWithName(this.getNamer().determineName(t))) continue;
            this.getStore().add(current, t);
            this.didAdd(t);
            this.getEventRegister().fireObjectAdded(t);
            changed = true;
            ++current;
        }
        return changed;
    }

    @Override
    protected IndexedElementSource<T> getStore() {
        return (IndexedElementSource)super.getStore();
    }

    public T get(int index) {
        return this.getStore().get(index);
    }

    public T set(int index, T element) {
        this.assertMutable("set(int, T)");
        this.assertCanAdd(element);
        T oldElement = this.getStore().set(index, element);
        if (oldElement != null) {
            this.didRemove(oldElement);
        }
        this.getEventRegister().fireObjectRemoved(oldElement);
        this.didAdd(element);
        this.getEventRegister().fireObjectAdded(element);
        return oldElement;
    }

    public T remove(int index) {
        this.assertMutable("remove(int)");
        Object element = this.getStore().remove(index);
        if (element != null) {
            this.didRemove(element);
        }
        this.getEventRegister().fireObjectRemoved(element);
        return element;
    }

    public int indexOf(Object o) {
        return this.getStore().indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.getStore().lastIndexOf(o);
    }

    public ListIterator<T> listIterator() {
        return new ListIteratorImpl(this.getStore().listIterator());
    }

    public ListIterator<T> listIterator(int index) {
        return new ListIteratorImpl(this.getStore().listIterator(index));
    }

    public List<T> subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(this.getStore().subList(fromIndex, toIndex));
    }

    @Override
    protected <S extends T> IndexedElementSource<S> filteredStore(CollectionFilter<S> filter, ElementSource<T> elementSource) {
        return new FilteredList<T, S>(elementSource, filter);
    }

    @Override
    public NamedDomainObjectList<T> matching(Closure spec) {
        return this.matching((Spec<? super T>)Specs.convertClosureToSpec((Closure)spec));
    }

    @Override
    public NamedDomainObjectList<T> matching(Spec<? super T> spec) {
        return new DefaultNamedDomainObjectList<T>(this, this.createFilter(spec), this.getInstantiator(), this.getNamer());
    }

    @Override
    public <S extends T> NamedDomainObjectList<S> withType(Class<S> type) {
        return new DefaultNamedDomainObjectList<S>(this, this.createFilter(type), this.getInstantiator(), this.getNamer());
    }

    @Override
    public List<T> findAll(Closure cl) {
        return this.findAll(cl, new ArrayList());
    }

    private class ListIteratorImpl
    implements ListIterator<T> {
        private final ListIterator<T> iterator;
        private T lastElement;

        public ListIteratorImpl(ListIterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T next() {
            this.lastElement = this.iterator.next();
            return this.lastElement;
        }

        @Override
        public T previous() {
            this.lastElement = this.iterator.previous();
            return this.lastElement;
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void add(T t) {
            DefaultNamedDomainObjectList.this.assertMutable("listIterator().add(T)");
            DefaultNamedDomainObjectList.this.assertCanAdd(t);
            this.iterator.add(t);
            DefaultNamedDomainObjectList.this.didAdd(t);
            DefaultNamedDomainObjectList.this.getEventRegister().fireObjectAdded(t);
        }

        @Override
        public void remove() {
            DefaultNamedDomainObjectList.this.assertMutable("listIterator().remove()");
            this.iterator.remove();
            DefaultNamedDomainObjectList.this.didRemove(this.lastElement);
            DefaultNamedDomainObjectList.this.getEventRegister().fireObjectRemoved(this.lastElement);
            this.lastElement = null;
        }

        @Override
        public void set(T t) {
            DefaultNamedDomainObjectList.this.assertMutable("listIterator().set(T)");
            DefaultNamedDomainObjectList.this.assertCanAdd(t);
            this.iterator.set(t);
            DefaultNamedDomainObjectList.this.didRemove(this.lastElement);
            DefaultNamedDomainObjectList.this.getEventRegister().fireObjectRemoved(this.lastElement);
            DefaultNamedDomainObjectList.this.didAdd(t);
            DefaultNamedDomainObjectList.this.getEventRegister().fireObjectAdded(t);
            this.lastElement = null;
        }
    }
}

