/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.Activity;
import org.jetbrains.kotlin.com.intellij.diagnostic.ParallelActivity;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.ide.IdeBundle;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import org.jetbrains.kotlin.com.intellij.ide.plugins.LoadDescriptorsContext;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginXmlPathResolver;
import org.jetbrains.kotlin.com.intellij.ide.plugins.cl.PluginClassLoader;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationInfoEx;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import org.jetbrains.kotlin.com.intellij.openapi.util.BuildNumber;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.util.InvalidDataException;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeJdomFactory;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.serialization.SerializationException;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.LineSeparator;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.execution.ParametersListUtil;
import org.jetbrains.kotlin.com.intellij.util.graph.CachingSemiGraph;
import org.jetbrains.kotlin.com.intellij.util.graph.DFSTBuilder;
import org.jetbrains.kotlin.com.intellij.util.graph.Graph;
import org.jetbrains.kotlin.com.intellij.util.graph.GraphGenerator;
import org.jetbrains.kotlin.com.intellij.util.graph.InboundSemiGraph;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;
import org.jetbrains.kotlin.com.intellij.util.lang.UrlClassLoader;
import org.jetbrains.kotlin.com.intellij.util.text.VersionComparatorUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMXIncluder;
import org.jetbrains.kotlin.org.jdom.JDOMException;

public class PluginManagerCore {
    public static String BUILD_NUMBER;
    private static final TObjectIntHashMap<PluginId> ourId2Index;
    private static final Map<String, IdeaPluginDescriptorImpl> ourModulesToContainingPlugins;
    private static Set<String> ourDisabledPlugins;
    private static MultiMap<String, String> ourBrokenPluginVersions;
    private static final AtomicReference<IdeaPluginDescriptor[]> ourPlugins;
    private static List<IdeaPluginDescriptor> ourLoadedPlugins;
    public static volatile boolean isUnitTestMode;
    private static boolean ourUnitTestWithBundledPlugins;
    static String myPluginError;
    static List<String> myPlugins2Disable;
    static LinkedHashSet<String> myPlugins2Enable;
    private static final List<Runnable> ourDisabledPluginsListeners;

    @NotNull
    public static IdeaPluginDescriptor[] getPlugins() {
        IdeaPluginDescriptor[] result2 = ourPlugins.get();
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = result2 == null ? PluginManagerCore.initPlugins() : result2;
        if (ideaPluginDescriptorArray == null) {
            PluginManagerCore.$$$reportNull$$$0(0);
        }
        return ideaPluginDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<String> disabledPlugins) {
        File file2;
        if (configPath == null) {
            PluginManagerCore.$$$reportNull$$$0(3);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(4);
        }
        if ((file2 = new File(configPath, "disabled_plugins.txt")).isFile()) {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            List<String> requiredPlugins = StringUtil.split(System.getProperty("idea.required.plugins.id", ""), ",");
            try {
                boolean updateDisablePluginsList = false;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8));){
                    String id;
                    while ((id = reader.readLine()) != null) {
                        if (!requiredPlugins.contains(id = id.trim()) && !appInfo.isEssentialPlugin(id)) {
                            disabledPlugins.add(id);
                            continue;
                        }
                        updateDisablePluginsList = true;
                    }
                }
                finally {
                    if (updateDisablePluginsList) {
                        PluginManagerCore.savePluginsList(disabledPlugins, false, file2);
                        PluginManagerCore.fireEditDisablePlugins();
                    }
                }
            }
            catch (IOException e) {
                PluginManagerCore.getLogger().info("Unable to load disabled plugins list from " + file2, e);
            }
        }
    }

    public static void dontLoadDisabledPlugins() {
        ourDisabledPlugins = Collections.emptySet();
    }

    private static void loadDisabledPlugins() {
        if (ourDisabledPlugins == null) {
            ourDisabledPlugins = new LinkedHashSet<String>();
            if (System.getProperty("idea.ignore.disabled.plugins") == null) {
                PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), ourDisabledPlugins);
            }
        }
    }

    @NotNull
    public static Collection<String> disabledPlugins() {
        PluginManagerCore.loadDisabledPlugins();
        Collection<String> collection = Collections.unmodifiableCollection(ourDisabledPlugins);
        if (collection == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public static boolean isDisabled(@NotNull String pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        PluginManagerCore.loadDisabledPlugins();
        return ourDisabledPlugins.contains(pluginId);
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId pluginId;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(8);
        }
        return (pluginId = descriptor2.getPluginId()) == null || PluginManagerCore.getBrokenPluginVersions().get(pluginId.getIdString()).contains(descriptor2.getVersion());
    }

    @NotNull
    private static MultiMap<String, String> getBrokenPluginVersions() {
        if (ourBrokenPluginVersions == null) {
            ourBrokenPluginVersions = MultiMap.createSet();
            if (System.getProperty("idea.ignore.disabled.plugins") == null) {
                try (InputStream resource = PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt");
                     BufferedReader br = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));){
                    String s;
                    while ((s = br.readLine()) != null) {
                        List<String> tokens;
                        if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse(s)).isEmpty()) continue;
                        if (tokens.size() == 1) {
                            throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                        }
                        String pluginId = tokens.get(0);
                        List<String> versions2 = tokens.subList(1, tokens.size());
                        ourBrokenPluginVersions.putValues(pluginId, versions2);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
                }
            }
        }
        MultiMap<String, String> multiMap = ourBrokenPluginVersions;
        if (multiMap == null) {
            PluginManagerCore.$$$reportNull$$$0(9);
        }
        return multiMap;
    }

    private static void fireEditDisablePlugins() {
        for (Runnable listener : ourDisabledPluginsListeners) {
            listener.run();
        }
    }

    public static void savePluginsList(@NotNull Collection<String> ids, boolean append2, @NotNull File plugins) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        if (plugins == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        if (!plugins.isFile()) {
            FileUtil.ensureCanCreateFile(plugins);
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(plugins, append2), StandardCharsets.UTF_8));){
            PluginManagerCore.writePluginsList(ids, writer);
        }
    }

    public static void writePluginsList(@NotNull Collection<String> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        Object[] sortedIds = ArrayUtilRt.toStringArray(ids);
        Arrays.sort(sortedIds);
        String separator = LineSeparator.getSystemLineSeparator().getSeparatorString();
        for (Object id : sortedIds) {
            writer.write((String)id);
            writer.write(separator);
        }
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        return dependentPluginId.getIdString().startsWith("org.jetbrains.kotlin.com.intellij.module");
    }

    public static void checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<? super PluginId, ? extends IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<? super PluginId> check2) {
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        if (pluginId2Descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        if (check2 == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        PluginManagerCore.checkDependants(pluginDescriptor, pluginId2Descriptor, check2, (Set<? super PluginId>)new THashSet());
    }

    private static boolean checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<? super PluginId, ? extends IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<? super PluginId> check2, @NotNull Set<? super PluginId> processed) {
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (pluginId2Descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        if (check2 == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        if (processed == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        processed.add(pluginDescriptor.getPluginId());
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        THashSet optionalDependencies = new THashSet(Arrays.asList(pluginDescriptor.getOptionalDependentPluginIds()));
        for (PluginId dependentPluginId : dependentPluginIds) {
            if (processed.contains(dependentPluginId) || PluginManagerCore.isModuleDependency(dependentPluginId) && (ourModulesToContainingPlugins.isEmpty() || ourModulesToContainingPlugins.containsKey(dependentPluginId.getIdString())) || optionalDependencies.contains(dependentPluginId)) continue;
            if (!check2.value(dependentPluginId)) {
                return false;
            }
            IdeaPluginDescriptor dependantPluginDescriptor = pluginId2Descriptor.fun(dependentPluginId);
            if (dependantPluginDescriptor == null || PluginManagerCore.checkDependants(dependantPluginDescriptor, pluginId2Descriptor, check2, processed)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className2) {
        PluginId id;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(33);
        }
        return (id = PluginManagerCore.getPluginOrPlatformByClassName(className2)) == null || "org.jetbrains.kotlin.com.intellij".equals(id.getIdString()) ? null : id;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className2) {
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(34);
        }
        if (className2.startsWith("java.") || className2.startsWith("javax.") || className2.startsWith("kotlin.") || className2.startsWith("groovy.")) {
            return null;
        }
        PluginDescriptor result2 = null;
        for (IdeaPluginDescriptor o : PluginManagerCore.getPlugins()) {
            if (!PluginManagerCore.hasLoadedClass(className2, o.getPluginClassLoader())) continue;
            result2 = o;
            break;
        }
        if (result2 == null) {
            return null;
        }
        if (!result2.getPluginId().getIdString().equals("org.jetbrains.kotlin.com.intellij") || className2.startsWith("com.jetbrains.") || className2.startsWith("org.jetbrains.") || className2.startsWith("org.jetbrains.kotlin.com.intellij.") || className2.startsWith("org.intellij.") || className2.startsWith("com.android.") || className2.startsWith("git4idea.") || className2.startsWith("org.angularjs.")) {
            return result2.getPluginId();
        }
        String root2 = PathManager.getResourceRoot(result2.getPluginClassLoader(), "/" + className2.replace('.', '/') + ".class");
        if (root2 == null) {
            return null;
        }
        for (IdeaPluginDescriptor o : PluginManagerCore.getPlugins()) {
            String pluginPath;
            if (!o.getUseIdeaClassLoader()) continue;
            File path2 = o.getPath();
            String string2 = pluginPath = path2 == null ? null : FileUtil.toSystemIndependentName(path2.getPath());
            if (pluginPath == null || !root2.startsWith(pluginPath)) continue;
            result2 = o;
            break;
        }
        return result2.getPluginId();
    }

    private static boolean hasLoadedClass(@NotNull String className2, ClassLoader loader) {
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className2);
        }
        try {
            return (Boolean)loader.getClass().getMethod("hasLoadedClass", String.class).invoke((Object)loader, className2);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isDependent(@NotNull IdeaPluginDescriptor descriptor2, @NotNull PluginId on, @NotNull Map<PluginId, IdeaPluginDescriptor> map2, boolean checkModuleDependencies) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        if (on == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        if (map2 == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        for (PluginId id : descriptor2.getDependentPluginIds()) {
            if (ArrayUtil.contains(id, descriptor2.getOptionalDependentPluginIds()) || !checkModuleDependencies && PluginManagerCore.isModuleDependency(id)) continue;
            if (id.equals(on)) {
                return true;
            }
            IdeaPluginDescriptor depDescriptor = map2.get(id);
            if (depDescriptor == null || !PluginManagerCore.isDependent(depDescriptor, on, map2, checkModuleDependencies)) continue;
            return true;
        }
        return false;
    }

    private static IdeaPluginDescriptor getImplicitDependency(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        if (!ourModulesToContainingPlugins.containsKey("org.jetbrains.kotlin.com.intellij.modules.all") || descriptor2.getPluginId().getIdString().equals("org.jetbrains.kotlin.com.intellij")) {
            return null;
        }
        boolean isLegacyPlugin = !PluginManagerCore.hasModuleDependencies(descriptor2);
        boolean isCustomPlugin = !descriptor2.isBundled();
        return isLegacyPlugin || isCustomPlugin ? (IdeaPluginDescriptor)ourModulesToContainingPlugins.get("org.jetbrains.kotlin.com.intellij.modules.java") : null;
    }

    private static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId[] dependentPluginIds;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        for (PluginId dependentPluginId : dependentPluginIds = descriptor2.getDependentPluginIds()) {
            if (!PluginManagerCore.isModuleDependency(dependentPluginId)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldLoadPlugins() {
        try {
            Class.forName("org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        String loadPlugins = System.getProperty("idea.load.plugins");
        return loadPlugins == null || Boolean.TRUE.toString().equals(loadPlugins);
    }

    public static void configureExtensions() {
        Extensions.registerAreaClass("IDEA_PROJECT", null);
        Extensions.registerAreaClass("IDEA_MODULE", "IDEA_PROJECT");
    }

    @NotNull
    private static Method getAddUrlMethod(@NotNull ClassLoader loader) {
        Class loaderClass;
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(41);
        }
        Class clazz = loaderClass = loader instanceof URLClassLoader ? URLClassLoader.class : loader.getClass();
        while (loaderClass != null && !Object.class.equals(loaderClass)) {
            Method method = ReflectionUtil.getDeclaredMethod(loaderClass, "addURL", URL.class);
            if (method != null) {
                Method method2 = method;
                if (method2 == null) {
                    PluginManagerCore.$$$reportNull$$$0(42);
                }
                return method2;
            }
            loaderClass = loaderClass.getSuperclass();
        }
        if (null == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        return null;
    }

    @Nullable
    private static ClassLoader createPluginClassLoader(@NotNull File[] classPath2, @NotNull ClassLoader[] parentLoaders, @NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (classPath2 == null) {
            PluginManagerCore.$$$reportNull$$$0(44);
        }
        if (parentLoaders == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        if (pluginDescriptor.getUseIdeaClassLoader()) {
            try {
                ClassLoader loader = PluginManagerCore.class.getClassLoader();
                Method addUrlMethod = PluginManagerCore.getAddUrlMethod(loader);
                for (File pathElement : classPath2) {
                    addUrlMethod.invoke((Object)loader, pathElement.toPath().normalize().toUri().toURL());
                }
                return loader;
            }
            catch (IOException | IllegalAccessException | InvocationTargetException e) {
                PluginManagerCore.getLogger().warn(e);
            }
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        File pluginRoot2 = pluginDescriptor.getPath();
        if (isUnitTestMode && !ourUnitTestWithBundledPlugins) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(classPath2.length);
            for (File pathElement : classPath2) {
                urls.add(pathElement.toPath().normalize().toUri().toURL());
            }
            return new PluginClassLoader(urls, parentLoaders, pluginId, pluginDescriptor.getVersion(), pluginRoot2);
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().warn(e);
            return null;
        }
    }

    private static void logPlugins(@NotNull IdeaPluginDescriptorImpl[] plugins) {
        if (plugins == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        ArrayList<String> bundled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        ArrayList<String> custom = new ArrayList<String>();
        for (IdeaPluginDescriptorImpl descriptor2 : plugins) {
            String version = descriptor2.getVersion();
            String s = descriptor2.getName() + (version != null ? " (" + version + ")" : "");
            if (!descriptor2.isEnabled()) {
                disabled.add(s);
                continue;
            }
            if ("IDEA CORE".equals(descriptor2.getName()) || descriptor2.isBundled()) {
                bundled.add(s);
                continue;
            }
            custom.add(s);
        }
        Collections.sort(bundled);
        Collections.sort(custom);
        Collections.sort(disabled);
        Logger logger = PluginManagerCore.getLogger();
        logger.info("Loaded bundled plugins: " + StringUtil.join(bundled, ", "));
        if (!custom.isEmpty()) {
            logger.info("Loaded custom plugins: " + StringUtil.join(custom, ", "));
        }
        if (!disabled.isEmpty()) {
            logger.info("Disabled plugins: " + StringUtil.join(disabled, ", "));
        }
    }

    @NotNull
    private static ClassLoader[] getParentLoaders(@NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        if (isUnitTestMode && !ourUnitTestWithBundledPlugins) {
            ClassLoader[] classLoaderArray = new ClassLoader[]{};
            if (classLoaderArray == null) {
                PluginManagerCore.$$$reportNull$$$0(51);
            }
            return classLoaderArray;
        }
        PluginId[] pluginIds = pluginDescriptor.getDependentPluginIds();
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>(pluginIds.length);
        IdeaPluginDescriptor implicitDep = PluginManagerCore.getImplicitDependency(pluginDescriptor);
        if (implicitDep != null) {
            loaders.add(implicitDep.getPluginClassLoader());
        }
        for (PluginId id : pluginIds) {
            IdeaPluginDescriptor depPluginDescriptor = idToDescriptorMap.get(id);
            if (depPluginDescriptor == null) continue;
            ClassLoader loader = depPluginDescriptor.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error("Plugin class loader should be initialized for plugin " + id);
                continue;
            }
            loaders.add(loader);
        }
        ClassLoader[] classLoaderArray = loaders.toArray(new ClassLoader[0]);
        if (classLoaderArray == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        return classLoaderArray;
    }

    public static boolean isRunningFromSources() {
        return Holder.ourIsRunningFromSources;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<String> errors) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(53);
        }
        if (!errors.isEmpty()) {
            String errorMessage2 = IdeBundle.message("error.problems.found.loading.plugins", new Object[0]) + StringUtil.join(errors, "<p/>");
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isHeadlessEnvironment() && !isUnitTestMode) {
                myPluginError = myPluginError == null ? errorMessage2 : myPluginError + "\n" + errorMessage2;
            } else {
                PluginManagerCore.getLogger().error(errorMessage2);
            }
        }
    }

    private static void addModulesAsDependents(@NotNull Map<PluginId, ? super IdeaPluginDescriptorImpl> map2) {
        if (map2 == null) {
            PluginManagerCore.$$$reportNull$$$0(54);
        }
        for (Map.Entry<String, IdeaPluginDescriptorImpl> entry : ourModulesToContainingPlugins.entrySet()) {
            map2.put(PluginId.getId(entry.getKey()), entry.getValue());
        }
    }

    @NotNull
    private static String reportCycles(@NotNull DFSTBuilder<PluginId> builder, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap) {
        String cyclePresentation;
        if (builder == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        List<Collection> cycles = ContainerUtil.filter(builder.getComponents(), c -> c.size() > 1);
        cycles.stream().flatMap(Collection::stream).forEach(id -> ((IdeaPluginDescriptor)idToDescriptorMap.get(id)).setEnabled(false));
        Application app = ApplicationManager.getApplication();
        if (app != null ? app.isInternal() : SystemProperties.is("idea.is.internal")) {
            cyclePresentation = cycles.stream().map(c -> StringUtil.join(c, " ")).collect(Collectors.joining("; "));
        } else {
            Couple<PluginId> loop2 = builder.getCircularDependency();
            cyclePresentation = loop2.first + "->" + loop2.second + "->...->" + loop2.first;
        }
        String string2 = IdeBundle.message("error.plugins.should.not.have.cyclic.dependencies", new Object[0]) + " " + cyclePresentation;
        if (string2 == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        return string2;
    }

    @NotNull
    private static Comparator<IdeaPluginDescriptor> getPluginDescriptorComparator(@NotNull DFSTBuilder<PluginId> builder) {
        if (builder == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        Comparator<PluginId> idComparator = builder.comparator();
        Comparator comparator = (o1, o2) -> {
            PluginId pluginId1 = o1.getPluginId();
            PluginId pluginId2 = o2.getPluginId();
            if (pluginId1.getIdString().equals("org.jetbrains.kotlin.com.intellij")) {
                return -1;
            }
            if (pluginId2.getIdString().equals("org.jetbrains.kotlin.com.intellij")) {
                return 1;
            }
            return idComparator.compare(pluginId1, pluginId2);
        };
        if (comparator == null) {
            PluginManagerCore.$$$reportNull$$$0(59);
        }
        return comparator;
    }

    @NotNull
    private static Graph<PluginId> createPluginIdGraph(final @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap) {
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        final ArrayList<PluginId> ids = new ArrayList<PluginId>(idToDescriptorMap.keySet());
        ids.sort((o1, o2) -> o2.getIdString().compareTo(o1.getIdString()));
        Graph<PluginId> graph2 = GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<PluginId>(){

            @Override
            @NotNull
            public Collection<PluginId> getNodes() {
                List list2 = ids;
                if (list2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @NotNull
            public Iterator<PluginId> getIn(PluginId pluginId) {
                IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                ArrayList<PluginId> plugins = new ArrayList<PluginId>();
                IdeaPluginDescriptor implicitDep = PluginManagerCore.getImplicitDependency(descriptor2);
                if (implicitDep != null) {
                    plugins.add(implicitDep.getPluginId());
                }
                for (PluginId dependentPluginId : descriptor2.getDependentPluginIds()) {
                    PluginId realPluginId;
                    IdeaPluginDescriptor dep = (IdeaPluginDescriptor)idToDescriptorMap.get(dependentPluginId);
                    if (dep == null || !idToDescriptorMap.containsKey(realPluginId = dep.getPluginId())) continue;
                    plugins.add(realPluginId);
                }
                Iterator<PluginId> iterator2 = plugins.iterator();
                if (iterator2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
        if (graph2 == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        return graph2;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull File file2, @NotNull String pathName, @Nullable File pluginPath, @NotNull LoadingContext loadingContext) {
        File descriptorFile;
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        if (loadingContext == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        if (!(descriptorFile = new File(file2, "META-INF/" + pathName)).exists()) {
            return null;
        }
        try {
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(ObjectUtils.notNull(pluginPath, file2), loadingContext.isBundled);
            descriptor2.loadFromFile(descriptorFile, loadingContext.getXmlFactory(), isUnitTestMode);
            return descriptor2;
        }
        catch (IOException | SerializationException | JDOMException e) {
            if (loadingContext.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().warn("Cannot load " + descriptorFile, e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor."));
        }
        catch (Throwable e) {
            if (loadingContext.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().warn("Cannot load " + descriptorFile, e);
        }
        return null;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file2, @NotNull String fileName, @NotNull JDOMXIncluder.PathResolver pathResolver, @NotNull LoadingContext context2, @Nullable File pluginPath) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        if (pathResolver == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        try {
            String entryName = "META-INF/" + fileName;
            URL jarURL = URLUtil.getJarEntryURL(file2, FileUtil.toCanonicalPath(entryName, '/'));
            ZipFile zipFile2 = context2.open(file2);
            ZipEntry entry = zipFile2.getEntry(entryName);
            if (entry != null) {
                IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(ObjectUtils.notNull(pluginPath, file2), context2.isBundled);
                SafeJdomFactory factory2 = context2.getXmlFactory();
                Interner<String> interner = factory2 == null ? null : factory2.stringInterner();
                descriptor2.readExternal(JDOMUtil.load(zipFile2.getInputStream(entry), factory2), jarURL, pathResolver, interner);
                context2.lastZipWithDescriptor = file2;
                return descriptor2;
            }
        }
        catch (InvalidDataException | SerializationException e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().info("Cannot load " + file2 + "!/META-INF/" + fileName, e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor."));
        }
        catch (Throwable e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().info("Cannot load " + file2 + "!/META-INF/" + fileName, e);
        }
        return null;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file2, @NotNull String fileName, boolean bundled, boolean essential, @Nullable LoadDescriptorsContext parentContext) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        try (LoadingContext context2 = new LoadingContext(parentContext, bundled, essential);){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptor(file2, fileName, context2);
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file2, @NotNull String pathName, @NotNull LoadingContext context2) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        IdeaPluginDescriptorImpl descriptor2 = null;
        boolean isDirectory = file2.isDirectory();
        if (isDirectory) {
            descriptor2 = PluginManagerCore.loadDescriptorFromDir(file2, pathName, null, context2);
            if (descriptor2 == null) {
                File[] files2 = new File(file2, "lib").listFiles();
                if (files2 == null || files2.length == 0) {
                    return null;
                }
                PluginManagerCore.putMoreLikelyPluginJarsFirst(file2, files2);
                List<File> pluginJarFiles = null;
                for (File f : files2) {
                    if (f.isDirectory()) {
                        IdeaPluginDescriptorImpl descriptor1 = PluginManagerCore.loadDescriptorFromDir(f, pathName, file2, context2);
                        if (descriptor1 == null) continue;
                        if (descriptor2 != null) {
                            PluginManagerCore.getLogger().info("Cannot load " + file2 + " because two or more plugin.xml's detected");
                            return null;
                        }
                        descriptor2 = descriptor1;
                        continue;
                    }
                    if (!FileUtilRt.isJarOrZip(f, false)) continue;
                    if (files2.length == 1) {
                        pluginJarFiles = Collections.singletonList(f);
                        continue;
                    }
                    if (pluginJarFiles == null) {
                        pluginJarFiles = new ArrayList<File>();
                    }
                    pluginJarFiles.add(f);
                }
                if (pluginJarFiles != null) {
                    File jarFile;
                    PluginXmlPathResolver pathResolver = new PluginXmlPathResolver(files2);
                    Iterator iterator2 = pluginJarFiles.iterator();
                    while (iterator2.hasNext() && (descriptor2 = PluginManagerCore.loadDescriptorFromJar(jarFile = (File)iterator2.next(), pathName, pathResolver, context2, file2)) == null) {
                    }
                }
            }
        } else if (StringUtilRt.endsWithIgnoreCase(file2.getPath(), ".jar")) {
            descriptor2 = PluginManagerCore.loadDescriptorFromJar(file2, pathName, JDOMXIncluder.DEFAULT_PATH_RESOLVER, context2, null);
        }
        if (descriptor2 == null) {
            return null;
        }
        if ("plugin.xml".equals(pathName) && (descriptor2.getPluginId() == null || descriptor2.getName() == null)) {
            PluginManagerCore.getLogger().info("Cannot load descriptor from " + file2 + ": ID or name missing");
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("'" + file2.getName() + "' contains invalid plugin descriptor."));
            return null;
        }
        PluginManagerCore.resolveOptionalDescriptors(pathName, descriptor2, optPathName -> {
            URL resource;
            IdeaPluginDescriptorImpl optionalDescriptor = null;
            if (context2.lastZipWithDescriptor != null) {
                optionalDescriptor = PluginManagerCore.loadDescriptor(context2.lastZipWithDescriptor, optPathName, context2);
            }
            if (optionalDescriptor == null) {
                optionalDescriptor = PluginManagerCore.loadDescriptor(file2, optPathName, context2);
            }
            if (optionalDescriptor == null && (isDirectory || PluginManagerCore.resolveDescriptorsInResources()) && (resource = PluginManagerCore.class.getClassLoader().getResource("META-INF/" + optPathName)) != null) {
                optionalDescriptor = PluginManagerCore.loadDescriptorFromResource(resource, optPathName, context2.isBundled, false, context2.parentContext);
            }
            return optionalDescriptor;
        });
        return descriptor2;
    }

    private static boolean resolveDescriptorsInResources() {
        return System.getProperty("resolve.descriptors.in.resources") != null;
    }

    private static void putMoreLikelyPluginJarsFirst(File pluginDir, File[] filesInLibUnderPluginDir) {
        String pluginDirName = pluginDir.getName();
        Arrays.parallelSort(filesInLibUnderPluginDir, (o1, o2) -> {
            boolean o1StartsWithNeededName;
            boolean o1IsVersioned;
            boolean o1StartsWithResources;
            String o2Name = o2.getName();
            String o1Name = o1.getName();
            boolean o2StartsWithResources = o2Name.startsWith("resources");
            if (o2StartsWithResources != (o1StartsWithResources = o1Name.startsWith("resources"))) {
                return o2StartsWithResources ? -1 : 1;
            }
            boolean o2IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o2Name);
            if (o2IsVersioned != (o1IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o1Name))) {
                return o2IsVersioned ? -1 : 1;
            }
            boolean o2StartsWithNeededName = StringUtil.startsWithIgnoreCase(o2Name, pluginDirName);
            if (o2StartsWithNeededName != (o1StartsWithNeededName = StringUtil.startsWithIgnoreCase(o1Name, pluginDirName))) {
                return o2StartsWithNeededName ? 1 : -1;
            }
            return o1Name.length() - o2Name.length();
        });
    }

    private static boolean fileNameIsLikeVersionedLibraryName(String name) {
        int i = name.lastIndexOf(45);
        if (i == -1) {
            return false;
        }
        if (i + 1 < name.length()) {
            char c = name.charAt(i + 1);
            if (Character.isDigit(c)) {
                return true;
            }
            if ((c == 'm' || c == 'M') && i + 2 < name.length() && Character.isDigit(name.charAt(i + 2))) {
                return true;
            }
        }
        return false;
    }

    public static void resolveOptionalDescriptors(@NotNull String fileName, @NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Function<? super String, ? extends IdeaPluginDescriptorImpl> optionalDescriptorLoader) {
        Map<PluginId, List<String>> optionalConfigs;
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        if (optionalDescriptorLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        if ((optionalConfigs = descriptor2.getOptionalConfigs()) != null && !optionalConfigs.isEmpty()) {
            LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>> descriptors = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>(optionalConfigs.size());
            for (Map.Entry<PluginId, List<String>> entry : optionalConfigs.entrySet()) {
                for (String optionalDescriptorName : entry.getValue()) {
                    if (fileName.equals(optionalDescriptorName)) {
                        PluginManagerCore.getLogger().info("recursive dependency (" + fileName + ") in " + descriptor2);
                        continue;
                    }
                    IdeaPluginDescriptorImpl optionalDescriptor = optionalDescriptorLoader.fun(optionalDescriptorName);
                    if (optionalDescriptor == null) {
                        PluginManagerCore.getLogger().info("Cannot find optional descriptor " + optionalDescriptorName);
                        continue;
                    }
                    descriptors.computeIfAbsent(entry.getKey(), it -> new SmartList()).add(optionalDescriptor);
                }
            }
            descriptor2.setOptionalDescriptors(descriptors);
        }
    }

    private static void loadDescriptorsFromDir(@NotNull File dir, @NotNull List<IdeaPluginDescriptorImpl> result2, boolean bundled, @NotNull LoadDescriptorsContext context2) throws ExecutionException, InterruptedException {
        File[] files2;
        if (dir == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        if ((files2 = dir.listFiles()) == null || files2.length == 0) {
            return;
        }
        THashSet existingResults = new THashSet(result2);
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>(files2.length);
        for (File file2 : files2) {
            tasks.add(context2.getExecutorService().submit(() -> PluginManagerCore.loadDescriptor(file2, "plugin.xml", bundled, false, context2)));
        }
        for (Future future : tasks) {
            boolean newer;
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)future.get();
            if (descriptor2 == null) continue;
            if (existingResults.add(descriptor2)) {
                result2.add(descriptor2);
                continue;
            }
            int prevIndex = result2.indexOf(descriptor2);
            IdeaPluginDescriptorImpl prevDescriptor = result2.get(prevIndex);
            boolean compatible = PluginManagerCore.isCompatible(descriptor2);
            boolean prevCompatible = PluginManagerCore.isCompatible(prevDescriptor);
            boolean bl = newer = VersionComparatorUtil.compare(descriptor2.getVersion(), prevDescriptor.getVersion()) > 0;
            if ((!compatible || prevCompatible) && (compatible != prevCompatible || !newer)) continue;
            result2.set(prevIndex, descriptor2);
            PluginManagerCore.getLogger().info(descriptor2.getPath() + " overrides " + prevDescriptor.getPath());
        }
    }

    private static void filterBadPlugins(@NotNull List<? extends IdeaPluginDescriptorImpl> result2, @NotNull Map<String, String> disabledPluginNames, @NotNull List<? super String> errors) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        THashMap idToDescriptorMap = new THashMap();
        boolean pluginsWithoutIdFound = false;
        Iterator<? extends IdeaPluginDescriptorImpl> it = result2.iterator();
        while (it.hasNext()) {
            IdeaPluginDescriptor descriptor2 = it.next();
            PluginId id = descriptor2.getPluginId();
            if (id == null) {
                pluginsWithoutIdFound = true;
                continue;
            }
            if (idToDescriptorMap.containsKey(id)) {
                errors.add(IdeBundle.message("message.duplicate.plugin.id", new Object[0]) + id);
                it.remove();
                continue;
            }
            if (!descriptor2.isEnabled()) continue;
            idToDescriptorMap.put(id, descriptor2);
        }
        PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)idToDescriptorMap);
        SmartList<String> disabledPluginIds = new SmartList<String>();
        LinkedHashSet faultyDescriptors = new LinkedHashSet();
        Iterator<? extends IdeaPluginDescriptorImpl> it2 = result2.iterator();
        while (it2.hasNext()) {
            IdeaPluginDescriptor pluginDescriptor = it2.next();
            PluginManagerCore.checkDependants(pluginDescriptor, ((Map)idToDescriptorMap)::get, arg_0 -> PluginManagerCore.lambda$filterBadPlugins$10((Map)idToDescriptorMap, pluginDescriptor, faultyDescriptors, disabledPluginIds, disabledPluginNames, errors, it2, arg_0));
        }
        if (!disabledPluginIds.isEmpty()) {
            myPlugins2Disable = disabledPluginIds;
            myPlugins2Enable = faultyDescriptors;
            String error = "<br><a href=\"disable\">Disable ";
            if (disabledPluginIds.size() == 1) {
                PluginId pluginId2Disable = PluginId.getId((String)disabledPluginIds.iterator().next());
                error = error + (idToDescriptorMap.containsKey(pluginId2Disable) ? ((IdeaPluginDescriptor)idToDescriptorMap.get(pluginId2Disable)).getName() : pluginId2Disable.getIdString());
            } else {
                error = error + "not loaded plugins";
            }
            errors.add(error + "</a>");
            boolean possibleToEnable = true;
            for (String descriptor3 : faultyDescriptors) {
                if (disabledPluginNames.get(descriptor3) != null) continue;
                possibleToEnable = false;
                break;
            }
            if (possibleToEnable) {
                String name = faultyDescriptors.size() == 1 ? disabledPluginNames.get(faultyDescriptors.iterator().next()) : " all necessary plugins";
                errors.add("<a href=\"enable\">Enable " + name + "</a>");
            }
            errors.add("<a href=\"edit\">Open plugin manager</a>");
        }
        if (pluginsWithoutIdFound) {
            errors.add(IdeBundle.message("error.plugins.without.id.found", new Object[0]));
        }
    }

    private static void loadDescriptorsFromClassPath(@NotNull LinkedHashMap<URL, String> urls, @NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull LoadDescriptorsContext context2, @Nullable URL platformPluginURL) throws ExecutionException, InterruptedException {
        if (urls == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        if (urls.isEmpty()) {
            return;
        }
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>(urls.size());
        for (Map.Entry<URL, String> entry : urls.entrySet()) {
            URL uRL = entry.getKey();
            tasks.add(context2.getExecutorService().submit(() -> PluginManagerCore.loadDescriptorFromResource(url, (String)entry.getValue(), true, url.equals(platformPluginURL), context2)));
        }
        THashSet existingResults = new THashSet(result2);
        for (Future future : tasks) {
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)future.get();
            if (descriptor2 == null || !existingResults.add(descriptor2)) continue;
            descriptor2.setUseCoreClassLoader(true);
            result2.add(descriptor2);
        }
    }

    @Nullable
    private static URL computePlatformPluginUrlAndCollectPluginUrls(@NotNull ClassLoader loader, @NotNull Map<URL, String> urls) {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        if (urls == null) {
            PluginManagerCore.$$$reportNull$$$0(90);
        }
        String platformPrefix = System.getProperty("idea.platform.prefix");
        URL result2 = null;
        if (platformPrefix != null) {
            String fileName = platformPrefix + "Plugin.xml";
            URL resource = loader.getResource("META-INF/" + fileName);
            if (resource != null) {
                urls.put(resource, fileName);
                result2 = resource;
            }
        }
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                urls.put(enumeration.nextElement(), "plugin.xml");
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info(e);
        }
        return result2;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromResource(@NotNull URL resource, @NotNull String pathName, boolean bundled, boolean essential, @Nullable LoadDescriptorsContext parentContext) {
        if (resource == null) {
            PluginManagerCore.$$$reportNull$$$0(91);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(92);
        }
        try {
            if ("file".equals(resource.getProtocol())) {
                File descriptorFile = PluginManagerCore.urlToFile(resource);
                String pathname = StringUtil.trimEnd(FileUtil.toSystemIndependentName(descriptorFile.getPath()), pathName);
                File pluginDir = new File(pathname).getParentFile();
                return PluginManagerCore.loadDescriptor(pluginDir, pathName, bundled, essential, parentContext);
            }
            if ("jar".equals(resource.getProtocol())) {
                String path2 = resource.getFile();
                File pluginJar = PluginManagerCore.urlToFile(new URL(path2.substring(0, path2.indexOf("!/"))));
                return PluginManagerCore.loadDescriptor(pluginJar, pathName, bundled, essential, parentContext);
            }
        }
        catch (Throwable e) {
            if (essential) {
                ExceptionUtil.rethrow(e);
            }
            PluginManagerCore.getLogger().info("Cannot load " + resource, e);
        }
        return null;
    }

    private static File urlToFile(URL url) throws URISyntaxException, MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                return new File(new URL(StringUtil.replace(str, " ", "%20")).toURI());
            }
            throw e;
        }
    }

    private static void loadDescriptorsFromProperty(@NotNull List<? super IdeaPluginDescriptorImpl> result2, @NotNull LoadDescriptorsContext context2) {
        String pathProperty;
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(93);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(94);
        }
        if ((pathProperty = System.getProperty("plugin.path")) == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl ideaPluginDescriptor = PluginManagerCore.loadDescriptor(new File(s), "plugin.xml", false, false, context2);
            if (ideaPluginDescriptor == null) continue;
            result2.add(ideaPluginDescriptor);
        }
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] loadDescriptors(@NotNull List<? super String> errors) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(95);
        }
        Activity activity = ParallelActivity.PREPARE_APP_INIT.start("plugin descriptors loading");
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        LinkedHashMap<URL, String> urlsFromClassPath = new LinkedHashMap<URL, String>();
        URL platformPluginURL = PluginManagerCore.computePlatformPluginUrlAndCollectPluginUrls(PluginManagerCore.class.getClassLoader(), urlsFromClassPath);
        boolean parallel = SystemProperties.getBooleanProperty("parallel.pluginDescriptors.loading", true);
        try (LoadDescriptorsContext context2 = new LoadDescriptorsContext(parallel);){
            PluginManagerCore.loadDescriptorsFromDir(new File(PathManager.getPluginsPath()), result2, false, context2);
            if (!isUnitTestMode) {
                PluginManagerCore.loadDescriptorsFromDir(new File(PathManager.getPreInstalledPluginsPath()), result2, true, context2);
            }
            PluginManagerCore.loadDescriptorsFromProperty(result2, context2);
            PluginManagerCore.loadDescriptorsFromClassPath(urlsFromClassPath, result2, context2, platformPluginURL);
            if (isUnitTestMode && result2.size() <= 1) {
                ourUnitTestWithBundledPlugins = true;
                PluginManagerCore.loadDescriptorsFromDir(new File(PathManager.getPreInstalledPluginsPath()), result2, true, context2);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            ExceptionUtil.rethrow(e);
        }
        activity.end();
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = PluginManagerCore.topoSortPlugins(result2, errors);
        if (ideaPluginDescriptorImplArray == null) {
            PluginManagerCore.$$$reportNull$$$0(96);
        }
        return ideaPluginDescriptorImplArray;
    }

    @NotNull
    private static IdeaPluginDescriptorImpl[] topoSortPlugins(@NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull List<? super String> errors) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(97);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(98);
        }
        IdeaPluginDescriptorImpl[] pluginDescriptors = result2.toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        THashMap idToDescriptorMap = new THashMap();
        for (IdeaPluginDescriptorImpl descriptor2 : pluginDescriptors) {
            idToDescriptorMap.put(descriptor2.getPluginId(), descriptor2);
        }
        Graph<PluginId> graph2 = PluginManagerCore.createPluginIdGraph((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap);
        DFSTBuilder<PluginId> builder = new DFSTBuilder<PluginId>(graph2);
        if (!builder.isAcyclic()) {
            errors.add(PluginManagerCore.reportCycles(builder, (Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap));
        }
        Arrays.sort(pluginDescriptors, PluginManagerCore.getPluginDescriptorComparator(builder));
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(99);
        }
        return pluginDescriptors;
    }

    private static void mergeOptionalConfigs(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> descriptors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(100);
        }
        THashMap descriptorsWithModules = new THashMap(descriptors);
        PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)descriptorsWithModules);
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors.values()) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> optionalDescriptors = descriptor2.getOptionalDescriptors();
            if (optionalDescriptors == null || optionalDescriptors.isEmpty()) continue;
            descriptor2.setOptionalDescriptors(null);
            for (Map.Entry<PluginId, List<IdeaPluginDescriptorImpl>> entry : optionalDescriptors.entrySet()) {
                if (!descriptorsWithModules.containsKey(entry.getKey())) continue;
                for (IdeaPluginDescriptorImpl optionalDescriptor : entry.getValue()) {
                    descriptor2.mergeOptionalConfig(optionalDescriptor);
                }
            }
        }
    }

    public static void initClassLoader(@NotNull ClassLoader parentLoader, @NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(101);
        }
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(102);
        }
        List<File> classPath2 = descriptor2.getClassPath();
        ClassLoader loader = PluginManagerCore.createPluginClassLoader(classPath2.toArray(ArrayUtilRt.EMPTY_FILE_ARRAY), new ClassLoader[]{parentLoader}, descriptor2);
        descriptor2.setLoader(loader);
    }

    static BuildNumber getBuildNumber() {
        return Holder.ourBuildNumber;
    }

    @Nullable
    private static String detectReasonToNotLoad(@NotNull IdeaPluginDescriptor descriptor2, @NotNull IdeaPluginDescriptor[] loaded) {
        String reasonToNotLoad;
        boolean checkModuleDependencies;
        String idString;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(103);
        }
        if (loaded == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        if ("org.jetbrains.kotlin.com.intellij".equals(idString = descriptor2.getPluginId().getIdString())) {
            return null;
        }
        String pluginId = System.getProperty("idea.load.plugins.id");
        List<String> pluginIds = null;
        if (pluginId == null) {
            if (descriptor2 instanceof IdeaPluginDescriptorImpl && !descriptor2.isEnabled()) {
                return "Plugin is not enabled";
            }
            if (!PluginManagerCore.shouldLoadPlugins()) {
                return "Plugins should not be loaded";
            }
        } else {
            pluginIds = StringUtil.split(pluginId, ",");
        }
        boolean bl = checkModuleDependencies = !ourModulesToContainingPlugins.isEmpty() && !ourModulesToContainingPlugins.containsKey("org.jetbrains.kotlin.com.intellij.modules.all");
        if (checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor2)) {
            return "Plugin does not include any module dependency tags in its plugin.xml therefore is assumed legacy and can be loaded only in IntelliJ IDEA";
        }
        String loadPluginCategory = System.getProperty("idea.load.plugins.category");
        if (loadPluginCategory != null) {
            reasonToNotLoad = loadPluginCategory.equals(descriptor2.getCategory()) ? null : "Plugin category doesn't match 'idea.load.plugins.category' value";
        } else if (pluginIds != null) {
            String string2 = reasonToNotLoad = pluginIds.contains(idString) ? null : "'idea.load.plugins.id' doesn't contain this plugin id";
            if (reasonToNotLoad != null) {
                THashMap map2 = new THashMap();
                for (IdeaPluginDescriptor pluginDescriptor : loaded) {
                    map2.put(pluginDescriptor.getPluginId(), pluginDescriptor);
                }
                PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)map2);
                for (String id : pluginIds) {
                    IdeaPluginDescriptor descriptorFromProperty = (IdeaPluginDescriptor)map2.get(PluginId.getId(id));
                    if (descriptorFromProperty == null || !PluginManagerCore.isDependent(descriptorFromProperty, descriptor2.getPluginId(), (Map<PluginId, IdeaPluginDescriptor>)map2, checkModuleDependencies)) continue;
                    reasonToNotLoad = null;
                    break;
                }
            }
        } else {
            String string3 = reasonToNotLoad = PluginManagerCore.isDisabled(idString) ? "Plugin is disabled" : null;
        }
        if (reasonToNotLoad == null && descriptor2 instanceof IdeaPluginDescriptorImpl && PluginManagerCore.isIncompatible(descriptor2)) {
            reasonToNotLoad = "Plugin since-build(" + descriptor2.getSinceBuild() + ") or until-build(" + descriptor2.getUntilBuild() + ") don't match this product's build number(" + PluginManagerCore.getBuildNumber() + ").";
        }
        return reasonToNotLoad;
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(105);
        }
        return !PluginManagerCore.isIncompatible(descriptor2);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(107);
        }
        return PluginManagerCore.isIncompatible(descriptor2, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(108);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        try {
            return PluginManagerCore.isIncompatible(buildNumber, descriptor2.getSinceBuild(), descriptor2.getUntilBuild(), descriptor2.getName(), descriptor2.toString());
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error(e);
            return false;
        }
    }

    static boolean isIncompatible(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild, @Nullable String descriptorName, @Nullable String descriptorDebugString) {
        BuildNumber untilBuildNumber;
        BuildNumber sinceBuildNumber;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(109);
        }
        SmartList<String> messages = null;
        BuildNumber buildNumber2 = sinceBuildNumber = StringUtil.isEmpty(sinceBuild) ? null : BuildNumber.fromString(sinceBuild, descriptorName, null);
        if (sinceBuildNumber != null && sinceBuildNumber.compareTo(buildNumber) > 0) {
            messages = new SmartList<String>("since build " + sinceBuildNumber + " > " + buildNumber);
        }
        BuildNumber buildNumber3 = untilBuildNumber = StringUtil.isEmpty(untilBuild) ? null : BuildNumber.fromString(untilBuild, descriptorName, null);
        if (untilBuildNumber != null && untilBuildNumber.compareTo(buildNumber) < 0) {
            if (messages == null) {
                messages = new SmartList<String>();
            }
            messages.add("until build " + untilBuildNumber + " < " + buildNumber);
        }
        if (messages != null) {
            PluginManagerCore.getLogger().warn(ObjectUtils.chooseNotNull(descriptorName, descriptorDebugString) + " not loaded: " + StringUtil.join(messages, ", "));
            return true;
        }
        return false;
    }

    private static void checkEssentialPluginsAreAvailable(IdeaPluginDescriptorImpl[] plugins) {
        Set<String> available = ContainerUtil.map2Set(plugins, plugin -> plugin.getPluginId().getIdString());
        List<String> required = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds();
        SmartList<String> missing = new SmartList<String>();
        for (String id : required) {
            if (available.contains(id)) continue;
            missing.add(id);
        }
        if (!missing.isEmpty()) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    @NotNull
    private static IdeaPluginDescriptorImpl[] initializePlugins() {
        Activity loadPluginsActivity = ParallelActivity.PREPARE_APP_INIT.start("plugin initialization");
        PluginManagerCore.configureExtensions();
        ArrayList<String> errors = new ArrayList<String>();
        IdeaPluginDescriptorImpl[] pluginDescriptors = PluginManagerCore.loadDescriptors(errors);
        if (!isUnitTestMode) {
            PluginManagerCore.checkEssentialPluginsAreAvailable(pluginDescriptors);
        }
        Class callerClass = ReflectionUtil.findCallerClass(1);
        assert (callerClass != null);
        ClassLoader coreLoader = callerClass.getClassLoader();
        final ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        THashMap idToDescriptorMap = new THashMap();
        THashMap disabledPluginNames = new THashMap();
        SmartList brokenPluginsList = new SmartList();
        PluginManagerCore.fixDescriptors(pluginDescriptors, coreLoader, (Map<PluginId, IdeaPluginDescriptorImpl>)idToDescriptorMap, (Map<String, String>)disabledPluginNames, brokenPluginsList, result2, errors);
        Graph<PluginId> graph2 = PluginManagerCore.createPluginIdGraph((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap);
        DFSTBuilder<PluginId> builder = new DFSTBuilder<PluginId>(graph2);
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors);
        Comparator<PluginId> idComparator = builder.comparator();
        result2.sort((o1, o2) -> idComparator.compare(o1.getPluginId(), o2.getPluginId()));
        for (int i = 0; i < result2.size(); ++i) {
            ourId2Index.put((Object)((IdeaPluginDescriptorImpl)result2.get(i)).getPluginId(), i);
        }
        for (IdeaPluginDescriptorImpl pluginDescriptor : result2) {
            if (pluginDescriptor.getPluginId().getIdString().equals("org.jetbrains.kotlin.com.intellij") || pluginDescriptor.isUseCoreClassLoader()) {
                pluginDescriptor.setLoader(coreLoader);
                continue;
            }
            File[] classPath2 = pluginDescriptor.getClassPath().toArray(ArrayUtilRt.EMPTY_FILE_ARRAY);
            ClassLoader[] parentLoaders = PluginManagerCore.getParentLoaders((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap, pluginDescriptor);
            if (parentLoaders.length == 0) {
                parentLoaders = new ClassLoader[]{coreLoader};
            }
            pluginDescriptor.setLoader(PluginManagerCore.createPluginClassLoader(classPath2, parentLoaders, pluginDescriptor));
        }
        loadPluginsActivity.end("plugin count: " + pluginDescriptors.length);
        Activity registerExtensionsActivity = ParallelActivity.PREPARE_APP_INIT.start("app extension registration");
        PluginManagerCore.registerExtensionPointsAndExtensions((ExtensionsAreaImpl)Extensions.getRootArea(), result2);
        Extensions.AREA_LISTENER_EXTENSION_POINT.getPoint(null).registerExtension(new AreaListener(){

            @Override
            public void areaCreated(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (areaInstance == null) {
                    3.$$$reportNull$$$0(1);
                }
                PluginManagerCore.registerExtensionPointsAndExtensions((ExtensionsAreaImpl)Extensions.getArea(areaInstance), result2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "areaClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "areaInstance";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore$3";
                objectArray[2] = "areaCreated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        registerExtensionsActivity.end();
        ourLoadedPlugins = Collections.unmodifiableList(result2);
        ourPlugins.set(pluginDescriptors);
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(111);
        }
        return pluginDescriptors;
    }

    public static void fixDescriptors(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, @NotNull Map<String, String> disabledPluginNames, @NotNull List<? super String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull List<? super String> errors) {
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(112);
        }
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(113);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(114);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(115);
        }
        if (brokenPluginsList == null) {
            PluginManagerCore.$$$reportNull$$$0(116);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(117);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(118);
        }
        PluginManagerCore.checkCanLoadPlugins(pluginDescriptors, parentLoader, disabledPluginNames, brokenPluginsList, result2);
        PluginManagerCore.filterBadPlugins(result2, disabledPluginNames, errors);
        if (!brokenPluginsList.isEmpty()) {
            errors.add("The following plugins are incompatible with the current IDE build: " + StringUtil.join(brokenPluginsList, ", "));
        }
        PluginManagerCore.fixDependencies(result2, idToDescriptorMap);
    }

    private static void checkCanLoadPlugins(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<String, String> disabledPluginNames, @NotNull List<? super String> brokenPluginsList, @NotNull List<? super IdeaPluginDescriptorImpl> result2) {
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(119);
        }
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(120);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(121);
        }
        if (brokenPluginsList == null) {
            PluginManagerCore.$$$reportNull$$$0(122);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(123);
        }
        for (IdeaPluginDescriptorImpl descriptor2 : pluginDescriptors) {
            String toNotLoadReason = PluginManagerCore.detectReasonToNotLoad(descriptor2, pluginDescriptors);
            if (toNotLoadReason == null && PluginManagerCore.isBrokenPlugin(descriptor2)) {
                brokenPluginsList.add(descriptor2.getName());
                toNotLoadReason = "This plugin version was marked as incompatible";
            }
            if (toNotLoadReason == null) {
                List<String> modules = descriptor2.getModules();
                for (String module2 : modules) {
                    if (ourModulesToContainingPlugins.containsKey(module2)) continue;
                    ourModulesToContainingPlugins.put(module2, descriptor2);
                }
                result2.add(descriptor2);
                continue;
            }
            descriptor2.setEnabled(false);
            if (toNotLoadReason != "Plugin is disabled") {
                PluginManagerCore.getLogger().info("Plugin '" + descriptor2.getName() + "' can't be loaded because: " + toNotLoadReason);
            }
            disabledPluginNames.put(descriptor2.getPluginId().getIdString(), descriptor2.getName());
            PluginManagerCore.initClassLoader(parentLoader, descriptor2);
        }
    }

    private static void fixDependencies(@NotNull List<? extends IdeaPluginDescriptorImpl> result2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(124);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(125);
        }
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : result2) {
            idToDescriptorMap.put(ideaPluginDescriptorImpl.getPluginId(), ideaPluginDescriptorImpl);
        }
        IdeaPluginDescriptor corePluginDescriptor = idToDescriptorMap.get(PluginId.getId("org.jetbrains.kotlin.com.intellij"));
        assert (corePluginDescriptor != null) : "org.jetbrains.kotlin.com.intellij not found; platform prefix is " + System.getProperty("idea.platform.prefix");
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : result2) {
            if (ideaPluginDescriptorImpl == corePluginDescriptor) continue;
            ideaPluginDescriptorImpl.insertDependency(corePluginDescriptor);
        }
        PluginManagerCore.fixOptionalConfigs(idToDescriptorMap);
        PluginManagerCore.mergeOptionalConfigs(idToDescriptorMap);
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
    }

    private static void fixOptionalConfigs(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(126);
        }
        if (!PluginManagerCore.isRunningFromSources()) {
            return;
        }
        for (IdeaPluginDescriptorImpl descriptor2 : idToDescriptorMap.values()) {
            if (!descriptor2.isUseCoreClassLoader() || descriptor2.getOptionalDescriptors() == null) continue;
            descriptor2.getOptionalDescriptors().entrySet().removeIf(entry -> {
                IdeaPluginDescriptorImpl dependent = (IdeaPluginDescriptorImpl)idToDescriptorMap.get(entry.getKey());
                return dependent != null && !dependent.isUseCoreClassLoader();
            });
        }
    }

    private static void registerExtensionPointsAndExtensions(@NotNull ExtensionsAreaImpl area, @NotNull List<? extends IdeaPluginDescriptorImpl> loadedPlugins) {
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(127);
        }
        if (loadedPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(128);
        }
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : loadedPlugins) {
            ideaPluginDescriptorImpl.registerExtensionPoints(area);
        }
        ExtensionPointImpl[] extensionPoints = area.getExtensionPoints();
        for (IdeaPluginDescriptorImpl ideaPluginDescriptorImpl : loadedPlugins) {
            ideaPluginDescriptorImpl.registerExtensions(extensionPoints, area.getPicoContainer());
        }
        area.extensionsRegistered(extensionPoints);
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot2, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor2;
        if (pluginRoot2 == null) {
            PluginManagerCore.$$$reportNull$$$0(129);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(130);
        }
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(131);
        }
        try (LoadingContext context2 = new LoadingContext(null, true, true);){
            descriptor2 = pluginRoot2.isDirectory() ? PluginManagerCore.loadDescriptorFromDir(pluginRoot2, fileName, null, context2) : PluginManagerCore.loadDescriptorFromJar(pluginRoot2, fileName, JDOMXIncluder.DEFAULT_PATH_RESOLVER, context2, null);
        }
        if (descriptor2 != null) {
            PluginManagerCore.registerExtensionPointsAndExtensions((ExtensionsAreaImpl)area, Collections.singletonList(descriptor2));
        } else {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot2);
        }
    }

    @NotNull
    private static synchronized IdeaPluginDescriptorImpl[] initPlugins() {
        IdeaPluginDescriptorImpl[] result2;
        try {
            result2 = PluginManagerCore.initializePlugins();
        }
        catch (PicoPluginExtensionInitializationException e) {
            throw new PluginException(e, e.getPluginId());
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error(e);
            throw e;
        }
        PluginManagerCore.logPlugins(result2);
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(132);
        }
        return result2;
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(133);
        }
        return logger;
    }

    private static /* synthetic */ boolean lambda$filterBadPlugins$10(Map idToDescriptorMap, IdeaPluginDescriptor pluginDescriptor, LinkedHashSet faultyDescriptors, List disabledPluginIds, Map disabledPluginNames, List errors, Iterator it, PluginId pluginId) {
        if (!idToDescriptorMap.containsKey(pluginId)) {
            pluginDescriptor.setEnabled(false);
            if (!pluginId.getIdString().startsWith("org.jetbrains.kotlin.com.intellij.module") && !pluginDescriptor.isImplementationDetail()) {
                boolean disabled;
                String pluginName;
                faultyDescriptors.add(pluginId.getIdString());
                disabledPluginIds.add(pluginDescriptor.getPluginId().getIdString());
                String name = pluginDescriptor.getName();
                IdeaPluginDescriptor descriptor2 = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                if (descriptor2 == null) {
                    pluginName = pluginId.getIdString();
                    if (disabledPluginNames.containsKey(pluginName)) {
                        pluginName = (String)disabledPluginNames.get(pluginName);
                    }
                } else {
                    pluginName = descriptor2.getName();
                }
                errors.add(IdeBundle.message((disabled = PluginManagerCore.isDisabled(pluginId.getIdString())) ? "error.required.plugin.disabled" : "error.required.plugin.not.installed", name, pluginName));
            }
            it.remove();
            return false;
        }
        return true;
    }

    static {
        ourId2Index = new TObjectIntHashMap();
        ourModulesToContainingPlugins = new THashMap();
        ourPlugins = new AtomicReference();
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        ourUnitTestWithBundledPlugins = Boolean.getBoolean("idea.run.tests.with.bundled.plugins");
        ourDisabledPluginsListeners = new CopyOnWriteArrayList<Runnable>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 2: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 8: 
            case 36: 
            case 39: 
            case 40: 
            case 77: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 13: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 23: 
            case 26: 
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId2Descriptor";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "on";
                break;
            }
            case 38: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 41: 
            case 85: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoaders";
                break;
            }
            case 49: 
            case 56: 
            case 60: 
            case 114: 
            case 125: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDescriptorMap";
                break;
            }
            case 53: 
            case 84: 
            case 95: 
            case 98: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 62: 
            case 65: 
            case 69: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 63: 
            case 74: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingContext";
                break;
            }
            case 66: 
            case 70: 
            case 72: 
            case 76: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 68: 
            case 75: 
            case 81: 
            case 88: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionalDescriptorLoader";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 80: 
            case 82: 
            case 87: 
            case 93: 
            case 97: 
            case 117: 
            case 123: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 83: 
            case 115: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPluginNames";
                break;
            }
            case 86: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 101: 
            case 113: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoader";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaded";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 112: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptors";
                break;
            }
            case 116: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brokenPluginsList";
                break;
            }
            case 127: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedPlugins";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledPlugins";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "disabledPlugins";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginException";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddUrlMethod";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentLoaders";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "reportCycles";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptorComparator";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginIdGraph";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDescriptors";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "topoSortPlugins";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "initializePlugins";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "initPlugins";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPlugins";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadDisabledPlugins";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPluginLoadingOrder";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkDependants";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isDependent";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitDependency";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAddUrlMethod";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoader";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isPluginClass";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getParentLoaders";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "prepareLoadingPluginsErrorMessage";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addModulesAsDependents";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "reportCycles";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorComparator";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createPluginIdGraph";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDir";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromJar";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptor";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "resolveOptionalDescriptors";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromDir";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "filterBadPlugins";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromClassPath";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "computePlatformPluginUrlAndCollectPluginUrls";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromResource";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromProperty";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptors";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "topoSortPlugins";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfigs";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "initClassLoader";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "detectReasonToNotLoad";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipPlugin";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "fixDescriptors";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "checkCanLoadPlugins";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "fixDependencies";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "fixOptionalConfigs";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointsAndExtensions";
                break;
            }
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class EssentialPluginMissingException
    extends RuntimeException {
        final List<String> pluginIds;

        EssentialPluginMissingException(@NotNull List<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + StringUtil.join(ids, ", "));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "org/jetbrains/kotlin/com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }

    private static class LoadingContext
    implements AutoCloseable {
        private final Map<File, ZipFile> myOpenedFiles = new THashMap();
        @Nullable
        final LoadDescriptorsContext parentContext;
        final boolean isBundled;
        final boolean isEssential;
        File lastZipWithDescriptor;

        LoadingContext(@Nullable LoadDescriptorsContext parentContext, boolean isBundled, boolean isEssential) {
            this.parentContext = parentContext;
            this.isBundled = isBundled;
            this.isEssential = isEssential;
        }

        ZipFile open(File file2) throws IOException {
            ZipFile zipFile2 = this.myOpenedFiles.get(file2);
            if (zipFile2 == null) {
                zipFile2 = new ZipFile(file2);
                this.myOpenedFiles.put(file2, zipFile2);
            }
            return zipFile2;
        }

        @Nullable
        SafeJdomFactory getXmlFactory() {
            return this.parentContext != null ? this.parentContext.getXmlFactory() : null;
        }

        @Override
        public void close() {
            for (ZipFile file2 : this.myOpenedFiles.values()) {
                try {
                    file2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class Holder {
        private static final BuildNumber ourBuildNumber = Holder.calcBuildNumber();
        private static final boolean ourIsRunningFromSources = new File(PathManager.getHomePath(), ".idea").isDirectory();

        private static BuildNumber calcBuildNumber() {
            BuildNumber ourBuildNumber = BuildNumber.fromString(System.getProperty("idea.plugins.compatible.build"));
            if (ourBuildNumber == null) {
                BuildNumber buildNumber = ourBuildNumber = BUILD_NUMBER == null ? null : BuildNumber.fromString(BUILD_NUMBER);
                if (ourBuildNumber == null) {
                    ourBuildNumber = BuildNumber.currentVersion();
                }
            }
            return ourBuildNumber;
        }
    }
}

