/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.injection.InjectedLanguageManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiFileRange;
import org.jetbrains.kotlin.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.FileElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.Identikit;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;

class SmartPsiFileRangePointerImpl
extends SmartPsiElementPointerImpl<PsiFile>
implements SmartPsiFileRange {
    SmartPsiFileRangePointerImpl(@NotNull SmartPointerManagerImpl manager, @NotNull PsiFile containingFile, @NotNull ProperTextRange range, boolean forInjected) {
        if (manager == null) {
            SmartPsiFileRangePointerImpl.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            SmartPsiFileRangePointerImpl.$$$reportNull$$$0(1);
        }
        if (range == null) {
            SmartPsiFileRangePointerImpl.$$$reportNull$$$0(2);
        }
        super(manager, containingFile, SmartPsiFileRangePointerImpl.createElementInfo(containingFile, range, forInjected));
    }

    @NotNull
    private static SmartPointerElementInfo createElementInfo(@NotNull PsiFile containingFile, @NotNull ProperTextRange range, boolean forInjected) {
        PsiLanguageInjectionHost host;
        if (containingFile == null) {
            SmartPsiFileRangePointerImpl.$$$reportNull$$$0(3);
        }
        if (range == null) {
            SmartPsiFileRangePointerImpl.$$$reportNull$$$0(4);
        }
        Project project = containingFile.getProject();
        if (containingFile.getViewProvider() instanceof FreeThreadedFileViewProvider && (host = InjectedLanguageManager.getInstance(project).getInjectionHost(containingFile)) != null) {
            SmartPsiElementPointer<PsiLanguageInjectionHost> hostPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(host);
            InjectedSelfElementInfo injectedSelfElementInfo = new InjectedSelfElementInfo(project, containingFile, range, containingFile, hostPointer);
            if (injectedSelfElementInfo == null) {
                SmartPsiFileRangePointerImpl.$$$reportNull$$$0(5);
            }
            return injectedSelfElementInfo;
        }
        if (!forInjected && range.equals(containingFile.getTextRange())) {
            FileElementInfo fileElementInfo = new FileElementInfo(containingFile);
            if (fileElementInfo == null) {
                SmartPsiFileRangePointerImpl.$$$reportNull$$$0(6);
            }
            return fileElementInfo;
        }
        SelfElementInfo selfElementInfo = new SelfElementInfo(range, Identikit.fromTypes(PsiElement.class, null, Language.ANY), containingFile, forInjected);
        if (selfElementInfo == null) {
            SmartPsiFileRangePointerImpl.$$$reportNull$$$0(7);
        }
        return selfElementInfo;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.getElementInfo().restoreFile(this.myManager);
    }

    @Override
    public PsiFile getElement() {
        if (this.getRange() == null) {
            return null;
        }
        return this.getContainingFile();
    }

    @Override
    public String toString() {
        return "SmartPsiFileRangePointerImpl{" + this.getElementInfo() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createElementInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

