/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallLikeControlFlowExpression;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateApplicability;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.PostponedArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u001ah\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010\u00152\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0015\u001aj\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010\u00152\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0015H\u0002\u001a6\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n\u001aN\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0015\u001aL\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0015\u001a\u001c\u0010\u001f\u001a\u00020\u0005*\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0000\u001a&\u0010$\u001a\u0004\u0018\u00010\u0005*\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0005H\u0002\u001a$\u0010'\u001a\u00020\u0005*\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0002\u001aJ\u0010(\u001a\u00020\u0001*\u00020%2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00152\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0014\u0010)\u001a\u00020\u0005*\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002\u00a8\u0006*"}, d2={"checkApplicabilityForArgumentType", "", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "argumentType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "expectedType", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/SimpleConstraintSystemConstraintPosition;", "isReceiver", "", "nullableExpectedType", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "resolveArgumentExpression", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "expectedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isSafeCall", "acceptLambdaAtoms", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtomMarker;", "typeProvider", "resolveBlockArgument", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolvePlainArgumentType", "resolvePlainExpressionArgument", "resolveSubCallArgument", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "getExpectedType", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getExpectedTypeWithSAMConversion", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "candidateExpectedType", "prepareExpectedType", "resolveArgument", "varargElementType", "resolve"})
public final class ArgumentsKt {
    public static final void resolveArgumentExpression(@NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @NotNull ConeKotlinType expectedType, @NotNull FirTypeRef expectedTypeRef, @NotNull CheckerSink sink, boolean isReceiver, boolean isSafeCall, @NotNull Function1<? super PostponedResolvedAtomMarker, Unit> acceptLambdaAtoms, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider) {
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)expectedTypeRef, (String)"expectedTypeRef");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        Intrinsics.checkParameterIsNotNull(acceptLambdaAtoms, (String)"acceptLambdaAtoms");
        Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
        FirExpression firExpression2 = argument;
        if (firExpression2 instanceof FirFunctionCall || firExpression2 instanceof FirCallLikeControlFlowExpression) {
            ArgumentsKt.resolveSubCallArgument(csBuilder, (FirResolvable)((Object)argument), expectedType, sink, isReceiver, isSafeCall, typeProvider);
        } else if (!(firExpression2 instanceof FirCallableReferenceAccess)) {
            if (firExpression2 instanceof FirQualifiedAccessExpression) {
                ArgumentsKt.resolvePlainExpressionArgument(csBuilder, argument, expectedType, sink, isReceiver, isSafeCall, typeProvider);
            } else if (firExpression2 instanceof FirAnonymousFunction) {
                PostponedArgumentsKt.preprocessLambdaArgument$default(csBuilder, (FirAnonymousFunction)argument, expectedType, expectedTypeRef, acceptLambdaAtoms, false, 32, null);
            } else if (firExpression2 instanceof FirWrappedArgumentExpression) {
                ArgumentsKt.resolveArgumentExpression(csBuilder, ((FirWrappedArgumentExpression)argument).getExpression(), expectedType, expectedTypeRef, sink, isReceiver, isSafeCall, acceptLambdaAtoms, typeProvider);
            } else if (firExpression2 instanceof FirBlock) {
                ArgumentsKt.resolveBlockArgument(csBuilder, (FirBlock)argument, expectedType, expectedTypeRef, sink, isReceiver, isSafeCall, acceptLambdaAtoms, typeProvider);
            } else {
                ArgumentsKt.resolvePlainExpressionArgument(csBuilder, argument, expectedType, sink, isReceiver, isSafeCall, typeProvider);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void resolveBlockArgument(ConstraintSystemBuilder csBuilder, FirBlock block, ConeKotlinType expectedType, FirTypeRef expectedTypeRef, CheckerSink sink, boolean isReceiver, boolean isSafeCall, Function1<? super PostponedResolvedAtomMarker, Unit> acceptLambdaAtoms, Function1<? super FirExpression, ? extends FirTypeRef> typeProvider) {
        List<FirExpression> returnArguments = UtilsKt.returnExpressions(block);
        if (returnArguments.isEmpty()) {
            void $this$coneTypeUnsafe$iv;
            FirTypeRef firTypeRef = block.getTypeRef();
            ConstraintSystemBuilder constraintSystemBuilder = csBuilder;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            ConeKotlinType coneKotlinType2 = coneKotlinType;
            ArgumentsKt.checkApplicabilityForArgumentType(constraintSystemBuilder, coneKotlinType2, expectedType.getType(), SimpleConstraintSystemConstraintPosition.INSTANCE, false, ResolveUtilsKt.withNullability(expectedType.getType(), ConeNullability.NULLABLE), sink);
            return;
        }
        for (FirExpression argument : returnArguments) {
            ArgumentsKt.resolveArgumentExpression(csBuilder, argument, expectedType, expectedTypeRef, sink, isReceiver, isSafeCall, acceptLambdaAtoms, typeProvider);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void resolveSubCallArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull FirResolvable argument, @NotNull ConeKotlinType expectedType, @NotNull CheckerSink sink, boolean isReceiver, boolean isSafeCall, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider) {
        void $this$firUnsafe$iv;
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
        Candidate candidate2 = CandidateFactoryKt.candidate(argument);
        if (candidate2 == null) {
            ArgumentsKt.resolvePlainExpressionArgument(csBuilder, (FirExpression)((Object)argument), expectedType, sink, isReceiver, isSafeCall, typeProvider);
            return;
        }
        Candidate candidate3 = candidate2;
        FirBasedSymbol firBasedSymbol = candidate3.getSymbol();
        ReturnTypeCalculator returnTypeCalculator = sink.getComponents().getReturnTypeCalculator();
        boolean $i$f$firUnsafe = false;
        Object fir$iv = $this$firUnsafe$iv.getFir();
        boolean bl = fir$iv instanceof FirTypedDeclaration;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirTypedDeclaration.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType((FirElement)fir$iv);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        FirElement firElement = (FirElement)fir$iv;
        FirTypeRef $this$coneTypeUnsafe$iv = returnTypeCalculator.tryCalculateReturnType((FirTypedDeclaration)firElement);
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
        if (coneKotlinType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        ConeKotlinType type2 = coneKotlinType;
        ConeKotlinType argumentType = candidate3.getSubstitutor().substituteOrSelf(type2);
        ArgumentsKt.resolvePlainArgumentType(csBuilder, argumentType, expectedType, sink, isReceiver, isSafeCall);
    }

    public static final void resolvePlainExpressionArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, boolean isReceiver, boolean isSafeCall, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider) {
        Object object;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
                Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
                Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
                if (expectedType == null) {
                    return;
                }
                object = (FirTypeRef)typeProvider.invoke((Object)argument);
                if (object == null) break block6;
                FirTypeRef $this$coneTypeSafe$iv = object;
                boolean $i$f$coneTypeSafe = false;
                FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                    firTypeRef = null;
                }
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                Object object2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(object2 instanceof ConeKotlinType)) {
                    object2 = object = null;
                }
                if (object2 != null) break block7;
            }
            return;
        }
        Object argumentType = object;
        ArgumentsKt.resolvePlainArgumentType(csBuilder, (ConeKotlinType)argumentType, expectedType, sink, isReceiver, isSafeCall);
    }

    public static final void resolvePlainArgumentType(@NotNull ConstraintSystemBuilder csBuilder, @NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType, @NotNull CheckerSink sink, boolean isReceiver, boolean isSafeCall) {
        Intrinsics.checkParameterIsNotNull((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkParameterIsNotNull((Object)argumentType, (String)"argumentType");
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        SimpleConstraintSystemConstraintPosition position = SimpleConstraintSystemConstraintPosition.INSTANCE;
        ConeKotlinType nullableExpectedType = ResolveUtilsKt.withNullability(expectedType, ConeNullability.NULLABLE);
        if (isReceiver && isSafeCall) {
            if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            }
            return;
        }
        ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, argumentType, expectedType, position, isReceiver, nullableExpectedType, sink);
    }

    private static final void checkApplicabilityForArgumentType(ConstraintSystemBuilder csBuilder, ConeKotlinType argumentType, ConeKotlinType expectedType, SimpleConstraintSystemConstraintPosition position, boolean isReceiver, ConeKotlinType nullableExpectedType, CheckerSink sink) {
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType, position)) {
            if (!isReceiver) {
                if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                    csBuilder.addSubtypeConstraint(argumentType, expectedType, position);
                }
                return;
            }
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType, position);
                sink.reportApplicability(CandidateApplicability.WRONG_RECEIVER);
            }
        }
    }

    public static final void resolveArgument(@NotNull Candidate $this$resolveArgument, @NotNull FirExpression argument, @NotNull FirValueParameter parameter, boolean isReceiver, boolean isSafeCall, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider, @NotNull CheckerSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)$this$resolveArgument, (String)"$this$resolveArgument");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        ConeKotlinType expectedType = ArgumentsKt.prepareExpectedType($this$resolveArgument, sink.getComponents().getSession(), argument, parameter);
        ArgumentsKt.resolveArgumentExpression($this$resolveArgument.getSystem().getBuilder(), argument, expectedType, parameter.getReturnTypeRef(), sink, isReceiver, isSafeCall, (Function1<? super PostponedResolvedAtomMarker, Unit>)((Function1)new Function1<PostponedResolvedAtomMarker, Unit>($this$resolveArgument){
            final /* synthetic */ Candidate $this_resolveArgument;

            public final void invoke(@NotNull PostponedResolvedAtomMarker it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Collection collection = this.$this_resolveArgument.getPostponedAtoms();
                boolean bl = false;
                collection.add(it);
            }
            {
                this.$this_resolveArgument = candidate2;
                super(1);
            }
        }), typeProvider);
    }

    private static final ConeKotlinType prepareExpectedType(@NotNull Candidate $this$prepareExpectedType, FirSession session, FirExpression argument, FirValueParameter parameter) {
        ConeKotlinType basicExpectedType = ArgumentsKt.getExpectedType(argument, session, parameter);
        ConeKotlinType coneKotlinType = ArgumentsKt.getExpectedTypeWithSAMConversion($this$prepareExpectedType, session, argument, basicExpectedType);
        if (coneKotlinType == null) {
            coneKotlinType = basicExpectedType;
        }
        ConeKotlinType expectedType = coneKotlinType;
        return $this$prepareExpectedType.getSubstitutor().substituteOrSelf(expectedType);
    }

    private static final ConeKotlinType getExpectedTypeWithSAMConversion(@NotNull Candidate $this$getExpectedTypeWithSAMConversion, FirSession session, FirExpression argument, ConeKotlinType candidateExpectedType) {
        boolean argumentIsFunctional;
        boolean bl;
        FirExpression firExpression2;
        FirExpression firExpression3;
        if (PostponedArgumentsKt.isBuiltinFunctionalType(candidateExpectedType)) {
            return null;
        }
        Object obj = $this$getExpectedTypeWithSAMConversion.getSymbol().getFir();
        if (!(obj instanceof FirNamedFunction)) {
            obj = null;
        }
        FirNamedFunction firNamedFunction = (FirNamedFunction)obj;
        if (firNamedFunction == null) {
            return null;
        }
        FirNamedFunction firNamedFunction2 = firNamedFunction;
        if (!$this$getExpectedTypeWithSAMConversion.getSamResolver().shouldRunSamConversionForFunction(firNamedFunction2)) {
            return null;
        }
        FirExpression firExpression4 = argument;
        if (!(firExpression4 instanceof FirWrappedArgumentExpression)) {
            firExpression4 = null;
        }
        if ((firExpression3 = (FirWrappedArgumentExpression)firExpression4) == null || (firExpression3 = firExpression3.getExpression()) == null) {
            firExpression3 = firExpression2 = argument;
        }
        if (firExpression2 instanceof FirAnonymousFunction || firExpression2 instanceof FirCallableReferenceAccess) {
            bl = true;
        } else {
            FirTypeRef $this$coneTypeSafe$iv = argument.getTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            bl = argumentIsFunctional = coneKotlinType != null && PostponedArgumentsKt.isBuiltinFunctionalType(coneKotlinType);
        }
        if (!argumentIsFunctional) {
            return null;
        }
        ConeKotlinType coneKotlinType = $this$getExpectedTypeWithSAMConversion.getSamResolver().getFunctionTypeForPossibleSamType(candidateExpectedType);
        if (coneKotlinType == null) {
            return null;
        }
        return coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType getExpectedType(@NotNull FirExpression $this$getExpectedType, @NotNull FirSession session, @NotNull FirValueParameter parameter) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkParameterIsNotNull((Object)$this$getExpectedType, (String)"$this$getExpectedType");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        if (!(!parameter.isVararg() || $this$getExpectedType instanceof FirWrappedArgumentExpression && ((FirWrappedArgumentExpression)$this$getExpectedType).isSpread())) {
            FirTypeRef $this$coneTypeUnsafe$iv = parameter.getReturnTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            coneKotlinType = ArgumentsKt.varargElementType(coneKotlinType2, session);
        } else {
            FirTypeRef $this$coneTypeUnsafe$iv = parameter.getReturnTypeRef();
            boolean $i$f$coneTypeUnsafe = false;
            coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
            if (coneKotlinType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
        }
        return coneKotlinType;
    }

    private static final ConeKotlinType varargElementType(@NotNull ConeKotlinType $this$varargElementType, FirSession session) {
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$varargElementType, session);
        if (coneKotlinType == null) {
            String string2 = "Failed to extract! " + TypeRendererKt.render($this$varargElementType) + '!';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return coneKotlinType;
    }
}

