/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.watch.impl;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkFileWatcherRegistry
implements FileWatcherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkFileWatcherRegistry.class);
    private final WatchService watchService;

    public JdkFileWatcherRegistry(WatchService watchService) {
        this.watchService = watchService;
    }

    @Override
    public void registerWatchPoint(Path path) throws IOException {
        path.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW}, SensitivityWatchEventModifier.HIGH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWatching(FileWatcherRegistry.ChangeHandler handler) throws IOException {
        try {
            boolean overflow = false;
            block3: while (!overflow) {
                WatchKey watchKey = this.watchService.poll();
                if (watchKey == null) {
                    break;
                }
                watchKey.cancel();
                Path watchRoot = (Path)watchKey.watchable();
                LOGGER.debug("Stop watching {}", (Object)watchRoot);
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    FileWatcherRegistry.Type type;
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        LOGGER.info("Too many modifications for path {} since last build, dropping all VFS state", (Object)watchRoot);
                        handler.handleOverflow();
                        overflow = true;
                        continue block3;
                    }
                    Path changedPath = watchRoot.resolve((Path)event.context());
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        type = FileWatcherRegistry.Type.ADDED;
                    } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        type = FileWatcherRegistry.Type.MODIFIED;
                    } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        type = FileWatcherRegistry.Type.REMOVED;
                    } else {
                        throw new AssertionError();
                    }
                    handler.handleChange(type, changedPath);
                }
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.watchService.close();
    }
}

