/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import org.gradle.internal.file.FileMetadataSnapshot;

public class FileMetadata {
    private final long size;
    private final long lastModified;

    public static FileMetadata from(BasicFileAttributes attributes) {
        return new FileMetadata(attributes.size(), attributes.lastModifiedTime().toMillis());
    }

    public static FileMetadata from(FileMetadataSnapshot metadataSnapshot) {
        return new FileMetadata(metadataSnapshot.getLength(), metadataSnapshot.getLastModified());
    }

    public FileMetadata(long size, long lastModified) {
        this.size = size;
        this.lastModified = lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileMetadata that = (FileMetadata)o;
        return this.size == that.size && this.lastModified == that.lastModified;
    }

    public int hashCode() {
        return Objects.hash(this.size, this.lastModified);
    }
}

