/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins.cl;

import gnu.trove.THashSet;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.diagnostic.StartUpMeasurer;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.lang.UrlClassLoader;

public final class PluginClassLoader
extends UrlClassLoader {
    private final ClassLoader[] myParents;
    private final PluginId myPluginId;
    private final String myPluginVersion;
    private final List<String> myLibDirectories;
    private final AtomicLong edtTime;
    private final AtomicLong backgroundTime;
    private final AtomicInteger loadedClassCounter;
    private static final ActionWithPluginClassLoader<Class, Void> loadClassInPluginCL;
    private static final ActionWithClassloader<Class, Void> loadClassInCl;
    private static final Set<String> KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES;
    private static final ActionWithPluginClassLoader<URL, Void> findResourceInPluginCL;
    private static final ActionWithClassloader<URL, Void> findResourceInCl;
    private static final ActionWithPluginClassLoader<InputStream, Void> getResourceAsStreamInPluginCL;
    private static final ActionWithClassloader<InputStream, Void> getResourceAsStreamInCl;
    private static final ActionWithPluginClassLoader<Void, List<Enumeration<URL>>> findResourcesInPluginCL;
    private static final ActionWithClassloader<Void, List<Enumeration<URL>>> findResourcesInCl;

    public PluginClassLoader(@NotNull List<URL> urls, @NotNull ClassLoader[] parents2, PluginId pluginId, String version, File pluginRoot2) {
        if (urls == null) {
            PluginClassLoader.$$$reportNull$$$0(0);
        }
        if (parents2 == null) {
            PluginClassLoader.$$$reportNull$$$0(1);
        }
        super(PluginClassLoader.build().urls(urls).allowLock().useCache());
        this.edtTime = new AtomicLong();
        this.backgroundTime = new AtomicLong();
        this.loadedClassCounter = new AtomicInteger();
        this.myParents = parents2;
        this.myPluginId = pluginId;
        this.myPluginVersion = version;
        this.myLibDirectories = ContainerUtil.newSmartList();
        File libDir = new File(pluginRoot2, "lib");
        if (libDir.exists()) {
            this.myLibDirectories.add(libDir.getAbsolutePath());
        }
    }

    public Class loadClass(@NotNull String name, boolean resolve2) throws ClassNotFoundException {
        Class c;
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(2);
        }
        if ((c = this.tryLoadingClass(name, resolve2, null)) == null) {
            throw new ClassNotFoundException(name + " " + this);
        }
        return c;
    }

    @Nullable
    private <Result, ParameterType> Result processResourcesInParents(String name, ActionWithPluginClassLoader<Result, ParameterType> actionWithPluginClassLoader, ActionWithClassloader<Result, ParameterType> actionWithClassloader, Set<ClassLoader> visited2, ParameterType parameter) {
        for (ClassLoader parent2 : this.myParents) {
            Result resource;
            if (visited2 == null) {
                visited2 = new THashSet();
                visited2.add(this);
            }
            if (!visited2.add((ClassLoader)parent2) || !(parent2 instanceof PluginClassLoader ? (resource = actionWithPluginClassLoader.execute(name, (PluginClassLoader)parent2, (Set<ClassLoader>)visited2, actionWithPluginClassLoader, actionWithClassloader, parameter)) != null : (resource = actionWithClassloader.execute(name, parent2, parameter)) != null)) continue;
            return resource;
        }
        return null;
    }

    @Nullable
    private Class tryLoadingClass(@NotNull String name, boolean resolve2, @Nullable Set<ClassLoader> visited2) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(3);
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        Class c = null;
        if (!PluginClassLoader.mustBeLoadedByPlatform(name)) {
            c = this.loadClassInsideSelf(name);
        }
        if (c == null) {
            c = this.processResourcesInParents(name, loadClassInPluginCL, loadClassInCl, visited2, null);
        }
        if (c != null && resolve2) {
            this.resolveClass(c);
        }
        if (this.myPluginId != null && StartUpMeasurer.measuringPluginStartupCosts) {
            Application app = ApplicationManager.getApplication();
            boolean isEdt = app == null ? EventQueue.isDispatchThread() : app.isDispatchThread();
            (isEdt ? this.edtTime : this.backgroundTime).addAndGet(StartUpMeasurer.getCurrentTime() - startTime);
        }
        return c;
    }

    private static boolean mustBeLoadedByPlatform(String className2) {
        if (className2.startsWith("java.")) {
            return true;
        }
        return className2.startsWith("kotlin.") && (className2.startsWith("kotlin.jvm.functions.") || className2.startsWith("kotlin.reflect.") && className2.indexOf(46, 15) < 0 || KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES.contains(className2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Class loadClassInsideSelf(@NotNull String name) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(4);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            try {
                c = this._findClass(name);
            }
            catch (LinkageError e) {
                throw new PluginException("While loading class " + name + ": " + e.getMessage(), e, this.myPluginId);
            }
            if (c != null) {
                this.loadedClassCounter.incrementAndGet();
            }
            return c;
        }
    }

    @Override
    public URL findResource(String name) {
        URL resource = this.findOwnResource(name);
        if (resource != null) {
            return resource;
        }
        return this.processResourcesInParents(name, findResourceInPluginCL, findResourceInCl, null, null);
    }

    @Nullable
    private URL findOwnResource(String name) {
        URL resource = super.findResource(name);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream stream = this.getOwnResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        return this.processResourcesInParents(name, getResourceAsStreamInPluginCL, getResourceAsStreamInCl, null, null);
    }

    @Nullable
    private InputStream getOwnResourceAsStream(String name) {
        InputStream stream = super.getResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<Enumeration<URL>> resources = new ArrayList<Enumeration<URL>>();
        resources.add(this.findOwnResources(name));
        this.processResourcesInParents(name, findResourcesInPluginCL, findResourcesInCl, null, resources);
        return new DeepEnumeration(resources.toArray(new Enumeration[resources.size()]));
    }

    private Enumeration<URL> findOwnResources(String name) throws IOException {
        return super.findResources(name);
    }

    @Override
    protected String findLibrary(String libName) {
        if (!this.myLibDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i = this.myLibDirectories.listIterator(this.myLibDirectories.size());
            while (i.hasPrevious()) {
                File libFile = new File(i.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    public String getPluginIdString() {
        return this.myPluginId != null ? this.myPluginId.getIdString() : "org.jetbrains.kotlin.com.intellij";
    }

    public String toString() {
        return "PluginClassLoader[" + this.myPluginId + ", " + this.myPluginVersion + "] " + super.toString();
    }

    static {
        if (PluginClassLoader.registerAsParallelCapable()) {
            PluginClassLoader.markParallelCapable(PluginClassLoader.class);
        }
        loadClassInPluginCL = new ActionWithPluginClassLoader<Class, Void>(){

            @Override
            Class execute(String name, PluginClassLoader classloader, Set<ClassLoader> visited2, ActionWithPluginClassLoader<Class, Void> actionWithPluginClassLoader, ActionWithClassloader<Class, Void> actionWithClassloader, Void parameter) {
                return classloader.tryLoadingClass(name, false, visited2);
            }

            @Override
            protected Class doExecute(String name, PluginClassLoader classloader, Void parameter) {
                return null;
            }
        };
        loadClassInCl = new ActionWithClassloader<Class, Void>(){

            @Override
            public Class execute(String name, ClassLoader classloader, Void parameter) {
                try {
                    return classloader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        };
        KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES = ContainerUtil.set("kotlin.sequences.Sequence", "kotlin.Lazy", "kotlin.Unit", "kotlin.Pair", "kotlin.Triple", "kotlin.jvm.internal.DefaultConstructorMarker", "kotlin.properties.ReadWriteProperty", "kotlin.properties.ReadOnlyProperty");
        findResourceInPluginCL = new ActionWithPluginClassLoader<URL, Void>(){

            @Override
            protected URL doExecute(String name, PluginClassLoader classloader, Void parameter) {
                return classloader.findOwnResource(name);
            }
        };
        findResourceInCl = new ActionWithClassloader<URL, Void>(){

            @Override
            public URL execute(String name, ClassLoader classloader, Void parameter) {
                return classloader.getResource(name);
            }
        };
        getResourceAsStreamInPluginCL = new ActionWithPluginClassLoader<InputStream, Void>(){

            @Override
            protected InputStream doExecute(String name, PluginClassLoader classloader, Void parameter) {
                return classloader.getOwnResourceAsStream(name);
            }
        };
        getResourceAsStreamInCl = new ActionWithClassloader<InputStream, Void>(){

            @Override
            public InputStream execute(String name, ClassLoader classloader, Void parameter) {
                return classloader.getResourceAsStream(name);
            }
        };
        findResourcesInPluginCL = new ActionWithPluginClassLoader<Void, List<Enumeration<URL>>>(){

            @Override
            protected Void doExecute(String name, PluginClassLoader classloader, List<Enumeration<URL>> enumerations) {
                try {
                    enumerations.add(classloader.findOwnResources(name));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
        findResourcesInCl = new ActionWithClassloader<Void, List<Enumeration<URL>>>(){

            @Override
            public Void execute(String name, ClassLoader classloader, List<Enumeration<URL>> enumerations) {
                try {
                    enumerations.add(classloader.getResources(name));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirectories";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/cl/PluginClassLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "tryLoadingClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadClassInsideSelf";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibDirectories";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DeepEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL>[] myEnumerations;
        private int myIndex;

        DeepEnumeration(Enumeration<URL>[] enumerations) {
            this.myEnumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.myIndex < this.myEnumerations.length) {
                Enumeration<URL> e = this.myEnumerations[this.myIndex];
                if (e != null && e.hasMoreElements()) {
                    return true;
                }
                ++this.myIndex;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.myEnumerations[this.myIndex].nextElement();
        }
    }

    private static abstract class ActionWithPluginClassLoader<Result, ParameterType> {
        private ActionWithPluginClassLoader() {
        }

        Result execute(String name, PluginClassLoader classloader, Set<ClassLoader> visited2, ActionWithPluginClassLoader<Result, ParameterType> actionWithPluginClassLoader, ActionWithClassloader<Result, ParameterType> actionWithClassloader, ParameterType parameter) {
            Result resource = this.doExecute(name, classloader, parameter);
            if (resource != null) {
                return resource;
            }
            return (Result)classloader.processResourcesInParents(name, actionWithPluginClassLoader, actionWithClassloader, visited2, parameter);
        }

        protected abstract Result doExecute(String var1, PluginClassLoader var2, ParameterType var3);
    }

    private static interface ActionWithClassloader<Result, ParameterType> {
        public Result execute(String var1, ClassLoader var2, ParameterType var3);
    }
}

