/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.gradle.internal.file.FileException;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.FileModeAccessor;
import org.gradle.internal.nativeintegration.filesystem.FileModeMutator;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Symlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenericFileSystem
implements FileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericFileSystem.class);
    private Boolean caseSensitive;
    private final boolean canCreateSymbolicLink;
    private final FileModeMutator chmod;
    private final FileModeAccessor stat;
    private final Symlink symlink;
    private final FileMetadataAccessor metadata;

    @Override
    public boolean isCaseSensitive() {
        this.initializeCaseSensitive();
        return this.caseSensitive;
    }

    @Override
    public boolean canCreateSymbolicLink() {
        return this.canCreateSymbolicLink;
    }

    @Override
    public void createSymbolicLink(File link, File target) {
        try {
            this.symlink.symlink(link, target);
        }
        catch (Exception e) {
            throw new FileException(String.format("Could not create symlink from '%s' to '%s'.", link.getPath(), target.getPath()), (Throwable)e);
        }
    }

    @Override
    public boolean isSymlink(File suspect) {
        return this.symlink.isSymlink(suspect);
    }

    public int getUnixMode(File f) {
        try {
            return this.stat.getUnixMode(f);
        }
        catch (Exception e) {
            throw new FileException(String.format("Could not get file mode for '%s'.", f), (Throwable)e);
        }
    }

    public FileMetadataSnapshot stat(File f) throws FileException {
        return this.metadata.stat(f);
    }

    public void chmod(File f, int mode) {
        try {
            this.chmod.chmod(f, mode);
        }
        catch (Exception e) {
            throw new FileException(String.format("Could not set file mode %o on '%s'.", mode, f), (Throwable)e);
        }
    }

    public GenericFileSystem(FileModeMutator chmod, FileModeAccessor stat, Symlink symlink, FileMetadataAccessor metadata) {
        this.metadata = metadata;
        this.stat = stat;
        this.symlink = symlink;
        this.chmod = chmod;
        this.canCreateSymbolicLink = symlink.isSymlinkCreationSupported();
    }

    private void initializeCaseSensitive() {
        if (this.caseSensitive == null) {
            String content = this.generateUniqueContent();
            File file = null;
            try {
                this.checkJavaIoTmpDirExists();
                file = this.createFile(content);
                this.caseSensitive = this.probeCaseSensitive(file, content);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    FileUtils.deleteQuietly(file);
                    throw throwable;
                }
            }
            FileUtils.deleteQuietly((File)file);
        }
    }

    private String generateUniqueContent() {
        return UUID.randomUUID().toString();
    }

    private File createFile(String content) throws IOException {
        File file = File.createTempFile("gradle_fs_probing", null, null);
        Files.write((CharSequence)content, (File)file, (Charset)Charsets.UTF_8);
        return file;
    }

    private boolean probeCaseSensitive(File file, String content) {
        try {
            File upperCased = new File(file.getPath().toUpperCase());
            return !this.hasContent(upperCased, content);
        }
        catch (IOException e) {
            boolean result = !new File("foo").equals(new File("FOO"));
            LOGGER.info("Failed to determine if file system is case sensitive. Best guess is '{}'.", (Object)result);
            return result;
        }
    }

    private boolean hasContent(File file, String content) throws IOException {
        return file.exists() && Files.readFirstLine((File)file, (Charset)Charsets.UTF_8).equals(content);
    }

    private void checkJavaIoTmpDirExists() throws IOException {
        File dir = new File(System.getProperty("java.io.tmpdir"));
        if (!dir.exists()) {
            throw new IOException("java.io.tmpdir is set to a directory that doesn't exist: " + dir);
        }
    }
}

