/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.lang.CompoundRuntimeException;
import org.jetbrains.kotlin.com.intellij.util.messages.ListenerDescriptor;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.Message;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusConnectionImpl;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageDeliveryListener;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusImpl");
    private static final Comparator<MessageBusImpl> MESSAGE_BUS_COMPARATOR = (bus1, bus2) -> ContainerUtil.compareLexicographically(bus1.myOrder, bus2.myOrder);
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue;
    private List<Integer> myOrder;
    private final ConcurrentMap<Topic, Object> myPublishers;
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscribers;
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscriberCache;
    private final List<MessageBusImpl> myChildBuses;
    private volatile ConcurrentMap<String, List<ListenerDescriptor>> myTopicClassToListenerClass;
    private static final Object NA = new Object();
    private MessageBusImpl myParentBus;
    RootBus myRootBus;
    private final String myOwner;
    private boolean myDisposed;
    private final Disposable myConnectionDisposable;
    private MessageDeliveryListener myListener;

    private MessageBusImpl(@NotNull Object owner) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(3);
        }
        this.myMessageQueue = MessageBusImpl.createThreadLocalQueue();
        this.myPublishers = ContainerUtil.newConcurrentMap();
        this.mySubscribers = ContainerUtil.newConcurrentMap();
        this.mySubscriberCache = ContainerUtil.newConcurrentMap();
        this.myChildBuses = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myOwner = owner + " of " + owner.getClass();
        this.myConnectionDisposable = Disposer.newDisposable(this.myOwner);
        this.myOrder = new ArrayList<Integer>();
    }

    public String toString() {
        return super.toString() + "; owner=" + this.myOwner + (this.myDisposed ? "; disposed" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChildBusDisposed(@NotNull MessageBusImpl childBus) {
        boolean removed2;
        if (childBus == null) {
            MessageBusImpl.$$$reportNull$$$0(5);
        }
        List<MessageBusImpl> list2 = this.myChildBuses;
        synchronized (list2) {
            removed2 = this.myChildBuses.remove(childBus);
        }
        Map map2 = (Map)this.myRootBus.myWaitingBuses.get();
        if (map2 != null) {
            map2.remove(childBus);
        }
        this.myRootBus.clearSubscriberCache();
        LOG.assertTrue(removed2);
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        MessageBusConnection messageBusConnection = this.connect(this.myConnectionDisposable);
        if (messageBusConnection == null) {
            MessageBusImpl.$$$reportNull$$$0(6);
        }
        return messageBusConnection;
    }

    @Override
    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MessageBusImpl.$$$reportNull$$$0(7);
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        Disposer.register(parentDisposable, connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(8);
        }
        return messageBusConnectionImpl;
    }

    @NotNull
    protected MessageBusConnection createConnectionForLazyListeners() {
        MessageBusConnection messageBusConnection = this.connect();
        if (messageBusConnection == null) {
            MessageBusImpl.$$$reportNull$$$0(9);
        }
        return messageBusConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public <L> L syncPublisher(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(10);
        }
        this.checkNotDisposed();
        Object v = this.myPublishers.get(topic);
        if (v != null) {
            Object v2 = v;
            if (v2 != null) return (L)v2;
            MessageBusImpl.$$$reportNull$$$0(11);
            return (L)v2;
        }
        Class<L> listenerClass = topic.getListenerClass();
        if (this.myTopicClassToListenerClass == null) {
            Object newInstance = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, this.createTopicHandler(topic));
            Object prev = this.myPublishers.putIfAbsent(topic, newInstance);
            Object object = prev == null ? newInstance : prev;
            if (object != null) return (L)object;
            MessageBusImpl.$$$reportNull$$$0(12);
            return (L)object;
        }
        Topic<L> topic2 = topic;
        // MONITORENTER : topic2
        Object v3 = this.myPublishers.get(topic);
        if (v3 != null) {
            Object v4 = v3;
            // MONITOREXIT : topic2
            if (v4 != null) return (L)v4;
            MessageBusImpl.$$$reportNull$$$0(13);
            return (L)v4;
        }
        List listenerDescriptors = (List)this.myTopicClassToListenerClass.remove(listenerClass.getName());
        if (listenerDescriptors != null) {
            MessageBusConnection connection = this.createConnectionForLazyListeners();
            for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
                ClassLoader classLoader = listenerDescriptor.pluginDescriptor.getPluginClassLoader();
                try {
                    Object listener = ReflectionUtil.newInstance(Class.forName(listenerDescriptor.listenerClassName, true, classLoader), false);
                    connection.subscribe(topic, listener);
                }
                catch (ClassNotFoundException e) {
                    LOG.error(e);
                }
            }
        }
        Object object = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, this.createTopicHandler(topic));
        this.myPublishers.put(topic, object);
        Object object2 = object;
        // MONITOREXIT : topic2
        if (object2 != null) return (L)object2;
        MessageBusImpl.$$$reportNull$$$0(14);
        return (L)object2;
    }

    @NotNull
    private <L> InvocationHandler createTopicHandler(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(15);
        }
        InvocationHandler invocationHandler = (proxy2, method, args) -> {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                return EventDispatcher.handleObjectMethod(proxy2, args, method.getName());
            }
            this.sendMessage(new Message(topic, method, args));
            return NA;
        };
        if (invocationHandler == null) {
            MessageBusImpl.$$$reportNull$$$0(16);
        }
        return invocationHandler;
    }

    @Override
    public void dispose() {
        this.checkNotDisposed();
        this.myDisposed = true;
        for (MessageBusImpl childBus : this.myChildBuses) {
            Disposer.dispose(childBus);
        }
        Disposer.dispose(this.myConnectionDisposable);
        Queue<DeliveryJob> jobs = this.myMessageQueue.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.onChildBusDisposed(this);
            this.myParentBus = null;
        } else {
            this.myRootBus.myWaitingBuses.remove();
        }
        this.myRootBus = null;
    }

    private void checkNotDisposed() {
        if (this.myDisposed) {
            LOG.error("Already disposed: " + this);
        }
    }

    private void calcSubscribers(@NotNull Topic topic, @NotNull List<? super MessageBusConnectionImpl> result2) {
        Topic.BroadcastDirection direction;
        List topicSubscribers;
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(18);
        }
        if (result2 == null) {
            MessageBusImpl.$$$reportNull$$$0(19);
        }
        if ((topicSubscribers = (List)this.mySubscribers.get(topic)) != null) {
            result2.addAll(topicSubscribers);
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                childBus.calcSubscribers(topic, result2);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.calcSubscribers(topic, result2);
        }
    }

    private void postMessage(@NotNull Message message2) {
        if (message2 == null) {
            MessageBusImpl.$$$reportNull$$$0(20);
        }
        this.checkNotDisposed();
        List<MessageBusConnectionImpl> topicSubscribers = this.getTopicSubscribers(message2.getTopic());
        if (!topicSubscribers.isEmpty()) {
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                subscriber.getBus().myMessageQueue.get().offer(new DeliveryJob(subscriber, message2));
                subscriber.getBus().notifyPendingJobChange(1);
                subscriber.scheduleMessageDelivery(message2);
            }
        }
    }

    @NotNull
    private List<MessageBusConnectionImpl> getTopicSubscribers(@NotNull Topic topic) {
        SmartList<MessageBusConnectionImpl> topicSubscribers;
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(21);
        }
        if ((topicSubscribers = (SmartList<MessageBusConnectionImpl>)this.mySubscriberCache.get(topic)) == null) {
            topicSubscribers = new SmartList<MessageBusConnectionImpl>();
            this.calcSubscribers(topic, topicSubscribers);
            this.mySubscriberCache.put(topic, topicSubscribers);
            if (this.myRootBus.myClearedSubscribersCache) {
                this.myRootBus.myClearedSubscribersCache = false;
            }
        }
        SmartList<MessageBusConnectionImpl> smartList = topicSubscribers;
        if (smartList == null) {
            MessageBusImpl.$$$reportNull$$$0(22);
        }
        return smartList;
    }

    private void notifyPendingJobChange(int delta) {
        Integer countObject;
        int count2;
        int newCount;
        ThreadLocal ref = this.myRootBus.myWaitingBuses;
        TreeMap<MessageBusImpl, Integer> map2 = (TreeMap<MessageBusImpl, Integer>)ref.get();
        if (map2 == null) {
            map2 = new TreeMap<MessageBusImpl, Integer>(MESSAGE_BUS_COMPARATOR);
            ref.set(map2);
        }
        if ((newCount = (count2 = (countObject = (Integer)map2.get(this)) == null ? 0 : countObject) + delta) > 0) {
            this.checkNotDisposed();
            map2.put(this, newCount);
        } else if (newCount == 0) {
            map2.remove(this);
        } else {
            LOG.error("Negative job count: " + this);
        }
    }

    private void sendMessage(@NotNull Message message2) {
        if (message2 == null) {
            MessageBusImpl.$$$reportNull$$$0(23);
        }
        this.pumpMessages();
        this.postMessage(message2);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        if (this.myParentBus != null) {
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
            this.myParentBus.pumpMessages();
        } else {
            Map map2 = (Map)this.myRootBus.myWaitingBuses.get();
            if (map2 != null && !map2.isEmpty()) {
                SmartList<MessageBusImpl> liveBuses = null;
                for (MessageBusImpl bus : map2.keySet()) {
                    if (!MessageBusImpl.ensureAlive(map2, bus)) continue;
                    if (liveBuses == null) {
                        liveBuses = new SmartList<MessageBusImpl>();
                    }
                    liveBuses.add(bus);
                }
                if (liveBuses != null) {
                    MessageBusImpl.pumpWaitingBuses(liveBuses);
                }
            }
        }
    }

    private static void pumpWaitingBuses(@NotNull List<? extends MessageBusImpl> buses) {
        if (buses == null) {
            MessageBusImpl.$$$reportNull$$$0(24);
        }
        List<Throwable> exceptions = null;
        for (MessageBusImpl messageBusImpl : buses) {
            if (messageBusImpl.myDisposed) continue;
            exceptions = MessageBusImpl.appendExceptions(exceptions, messageBusImpl.doPumpMessages());
        }
        MessageBusImpl.rethrowExceptions(exceptions);
    }

    private static List<Throwable> appendExceptions(@Nullable List<Throwable> exceptions, @NotNull List<? extends Throwable> busExceptions) {
        if (busExceptions == null) {
            MessageBusImpl.$$$reportNull$$$0(25);
        }
        if (!busExceptions.isEmpty()) {
            if (exceptions == null) {
                exceptions = new SmartList<Throwable>();
            }
            exceptions.addAll(busExceptions);
        }
        return exceptions;
    }

    private static void rethrowExceptions(@Nullable List<? extends Throwable> exceptions) {
        if (exceptions == null) {
            return;
        }
        ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
        if (pce != null) {
            throw pce;
        }
        CompoundRuntimeException.throwIfNotEmpty(exceptions);
    }

    private static boolean ensureAlive(@NotNull Map<MessageBusImpl, Integer> map2, @NotNull MessageBusImpl bus) {
        if (map2 == null) {
            MessageBusImpl.$$$reportNull$$$0(26);
        }
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(27);
        }
        if (bus.myDisposed) {
            map2.remove(bus);
            LOG.error("Accessing disposed message bus " + bus);
            return false;
        }
        return true;
    }

    @NotNull
    private List<Throwable> doPumpMessages() {
        DeliveryJob job;
        Queue<DeliveryJob> queue = this.myMessageQueue.get();
        SmartList<Throwable> exceptions = null;
        while ((job = queue.poll()) != null) {
            this.notifyPendingJobChange(-1);
            try {
                job.connection.deliverMessage(job.message);
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new SmartList<Throwable>();
                }
                exceptions.add(e);
            }
        }
        List<Throwable> list2 = exceptions == null ? Collections.emptyList() : exceptions;
        if (list2 == null) {
            MessageBusImpl.$$$reportNull$$$0(28);
        }
        return list2;
    }

    void notifyOnSubscription(@NotNull MessageBusConnectionImpl connection, @NotNull Topic<?> topic) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(29);
        }
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(30);
        }
        this.checkNotDisposed();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createLockFreeCopyOnWriteList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
        this.myRootBus.clearSubscriberCache();
    }

    void clearSubscriberCache() {
        this.mySubscriberCache.clear();
        for (MessageBusImpl bus : this.myChildBuses) {
            bus.clearSubscriberCache();
        }
    }

    void notifyConnectionTerminated(@NotNull MessageBusConnectionImpl connection) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(31);
        }
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.myDisposed) {
            return;
        }
        this.myRootBus.clearSubscriberCache();
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job = (DeliveryJob)i.next();
            if (job.connection != connection) continue;
            i.remove();
            this.notifyPendingJobChange(-1);
        }
    }

    void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        this.notifyPendingJobChange(-1);
        job.connection.deliverMessage(job.message);
    }

    @NotNull
    static <T> ThreadLocal<Queue<T>> createThreadLocalQueue() {
        ThreadLocal<Queue<T>> threadLocal = ThreadLocal.withInitial(ArrayDeque::new);
        if (threadLocal == null) {
            MessageBusImpl.$$$reportNull$$$0(32);
        }
        return threadLocal;
    }

    void notifyMessageDeliveryListener(@NotNull Topic topic, @NotNull String messageName, @NotNull Object handler2, long durationNanos) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(34);
        }
        if (messageName == null) {
            MessageBusImpl.$$$reportNull$$$0(35);
        }
        if (handler2 == null) {
            MessageBusImpl.$$$reportNull$$$0(36);
        }
        if (this.myListener != null) {
            this.myListener.messageDelivered(topic, messageName, handler2, durationNanos);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 28: 
            case 32: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 28: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childBus";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buses";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "busExceptions";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConnectionForLazyListeners";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopicHandler";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopicSubscribers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "doPumpMessages";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createThreadLocalQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLazyListeners";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onChildBusCreated";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onChildBusDisposed";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 28: 
            case 32: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTopicHandler";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasUndeliveredEvents";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calcSubscribers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "postMessage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTopicSubscribers";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sendMessage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "pumpWaitingBuses";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "appendExceptions";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "ensureAlive";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscription";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "notifyConnectionTerminated";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setMessageDeliveryListener";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "notifyMessageDeliveryListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 28: 
            case 32: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class RootBus
    extends MessageBusImpl {
        private final ThreadLocal<SortedMap<MessageBusImpl, Integer>> myWaitingBuses;
        private final MessageBusConnection myLazyConnection;
        volatile boolean myClearedSubscribersCache;

        @Override
        @NotNull
        protected MessageBusConnection createConnectionForLazyListeners() {
            MessageBusConnection messageBusConnection = this.myLazyConnection;
            if (messageBusConnection == null) {
                RootBus.$$$reportNull$$$0(0);
            }
            return messageBusConnection;
        }

        @Override
        void clearSubscriberCache() {
            if (this.myClearedSubscribersCache) {
                return;
            }
            super.clearSubscriberCache();
            this.myClearedSubscribersCache = true;
        }

        public RootBus(@NotNull Object owner) {
            if (owner == null) {
                RootBus.$$$reportNull$$$0(1);
            }
            super(owner);
            this.myWaitingBuses = new ThreadLocal();
            this.myLazyConnection = this.connect();
            this.myRootBus = this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$RootBus";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConnectionForLazyListeners";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$RootBus";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        DeliveryJob(@NotNull MessageBusConnectionImpl connection, @NotNull Message message2) {
            if (connection == null) {
                DeliveryJob.$$$reportNull$$$0(0);
            }
            if (message2 == null) {
                DeliveryJob.$$$reportNull$$$0(1);
            }
            this.connection = connection;
            this.message = message2;
        }

        @NonNls
        public String toString() {
            return "{ DJob connection:" + this.connection + "; message: " + this.message + " }";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl$DeliveryJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

