/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins.ide.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.util.CollectionUtils;

public class PlayIdeaPlugin
extends RuleSource {
    @Mutate
    public void configureIdeaModule(@Path(value="tasks.ideaModule") GenerateIdeaModule ideaModule, final @Path(value="binaries.playBinary") PlayApplicationBinarySpec playApplicationBinarySpec, final @Path(value="buildDir") File buildDir, ConfigurationContainer configurations, final FileResolver fileResolver) {
        IdeaModule module = ideaModule.getModule();
        module.setScopes(this.buildScopes(configurations));
        ConventionMapping conventionMapping = this.conventionMappingFor(module);
        conventionMapping.map("sourceDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                HashSet sourceDirs = Sets.newHashSet((Iterable)playApplicationBinarySpec.getAssets().getAssetDirs());
                return (Set)CollectionUtils.inject((Object)sourceDirs, (Iterable)playApplicationBinarySpec.getInputs(), (Action)new Action<CollectionUtils.InjectionStep<Set<File>, LanguageSourceSet>>(){

                    public void execute(CollectionUtils.InjectionStep<Set<File>, LanguageSourceSet> step) {
                        ((Set)step.getTarget()).addAll(((LanguageSourceSet)step.getItem()).getSource().getSrcDirs());
                    }
                });
            }
        });
        conventionMapping.map("testSourceDirs", (Callable)new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return Collections.singleton(fileResolver.resolve((Object)"test"));
            }
        });
        conventionMapping.map("singleEntryLibraries", (Callable)new Callable<Map<String, Iterable<File>>>(){

            @Override
            public Map<String, Iterable<File>> call() throws Exception {
                return ImmutableMap.builder().put((Object)"COMPILE", Collections.singleton(playApplicationBinarySpec.getClasses().getClassesDir())).put((Object)"RUNTIME", (Object)playApplicationBinarySpec.getClasses().getResourceDirs()).put((Object)"TEST", Collections.singleton(new File(buildDir, "playBinary/testClasses"))).build();
            }
        });
        module.setScalaPlatform(playApplicationBinarySpec.getTargetPlatform().getScalaPlatform());
        conventionMapping.map("targetBytecodeVersion", (Callable)new Callable<JavaVersion>(){

            @Override
            public JavaVersion call() throws Exception {
                return PlayIdeaPlugin.this.getTargetJavaVersion(playApplicationBinarySpec);
            }
        });
        conventionMapping.map("languageLevel", (Callable)new Callable<IdeaLanguageLevel>(){

            @Override
            public IdeaLanguageLevel call() throws Exception {
                return new IdeaLanguageLevel((Object)PlayIdeaPlugin.this.getTargetJavaVersion(playApplicationBinarySpec));
            }
        });
        ideaModule.dependsOn(new Object[]{playApplicationBinarySpec.getInputs()});
        ideaModule.dependsOn(new Object[]{playApplicationBinarySpec.getAssets()});
    }

    private ConventionMapping conventionMappingFor(IdeaModule module) {
        return new DslObject((Object)module).getConventionMapping();
    }

    private JavaVersion getTargetJavaVersion(PlayApplicationBinarySpec playApplicationBinarySpec) {
        return playApplicationBinarySpec.getTargetPlatform().getJavaPlatform().getTargetCompatibility();
    }

    private Map<String, Map<String, Collection<Configuration>>> buildScopes(ConfigurationContainer configurations) {
        return ImmutableMap.builder().put((Object)"PROVIDED", this.buildScope()).put((Object)"COMPILE", this.buildScope(configurations.getByName("play"))).put((Object)"RUNTIME", this.buildScope(configurations.getByName("playRun"))).put((Object)"TEST", this.buildScope(configurations.getByName("playTest"))).build();
    }

    private Map<String, Collection<Configuration>> buildScope() {
        return this.buildScope(null);
    }

    private Map<String, Collection<Configuration>> buildScope(Configuration plus) {
        return ImmutableMap.builder().put((Object)"plus", plus == null ? Collections.emptyList() : Collections.singletonList(plus)).put((Object)"minus", Collections.emptyList()).build();
    }
}

