/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.resources.TextResource;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class CheckstyleExtension
extends CodeQualityExtension {
    private final Project project;
    private TextResource config;
    private Map<String, Object> configProperties = new LinkedHashMap<String, Object>();
    private int maxErrors;
    private int maxWarnings = Integer.MAX_VALUE;
    private boolean showViolations = true;
    private final DirectoryProperty configDirectory;

    public CheckstyleExtension(Project project) {
        this.project = project;
        this.configDirectory = project.getObjects().directoryProperty();
    }

    public File getConfigFile() {
        return this.getConfig().asFile();
    }

    public void setConfigFile(File configFile) {
        this.setConfig(this.project.getResources().getText().fromFile((Object)configFile));
    }

    public TextResource getConfig() {
        return this.config;
    }

    public void setConfig(TextResource config) {
        this.config = config;
    }

    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    public void setConfigProperties(Map<String, Object> configProperties) {
        this.configProperties = configProperties;
    }

    @Deprecated
    @ReplacedBy(value="configDirectory")
    public File getConfigDir() {
        ((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(CheckstyleExtension.class, (String)"getConfigDir()").replaceWith((Object)"CheckstyleExtension.getConfigDirectory()")).withDslReference(CheckstyleExtension.class, "configDir").nagUser();
        return ((Directory)this.configDirectory.get()).getAsFile();
    }

    @Deprecated
    public void setConfigDir(File configDir) {
        ((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(CheckstyleExtension.class, (String)"setConfigDir()").replaceWith((Object)"CheckstyleExtension.getConfigDirectory().set()")).withDslReference(CheckstyleExtension.class, "configDir").nagUser();
        this.configDirectory.set(configDir);
    }

    public DirectoryProperty getConfigDirectory() {
        return this.configDirectory;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public int getMaxWarnings() {
        return this.maxWarnings;
    }

    public void setMaxWarnings(int maxWarnings) {
        this.maxWarnings = maxWarnings;
    }

    public boolean isShowViolations() {
        return this.showViolations;
    }

    public void setShowViolations(boolean showViolations) {
        this.showViolations = showViolations;
    }
}

