/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal.services;

import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolverProviderFactory;
import org.gradle.api.internal.resolve.DefaultLocalLibraryResolver;
import org.gradle.api.internal.resolve.LibraryResolutionErrorMessageBuilder;
import org.gradle.api.internal.resolve.LocalLibraryDependencyResolver;
import org.gradle.api.internal.resolve.LocalLibraryMetaDataAdapter;
import org.gradle.api.internal.resolve.LocalLibraryResolver;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.api.internal.resolve.VariantBinarySelector;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.scopes.AbstractPluginServiceRegistry;
import org.gradle.jvm.JvmBinarySpec;
import org.gradle.jvm.internal.JarBinaryRenderer;
import org.gradle.jvm.internal.resolve.DefaultJavaPlatformVariantAxisCompatibility;
import org.gradle.jvm.internal.resolve.DefaultLibraryResolutionErrorMessageBuilder;
import org.gradle.jvm.internal.resolve.DefaultVariantAxisCompatibilityFactory;
import org.gradle.jvm.internal.resolve.JvmLibraryResolveContext;
import org.gradle.jvm.internal.resolve.JvmLocalLibraryMetaDataAdapter;
import org.gradle.jvm.internal.resolve.JvmVariantSelector;
import org.gradle.jvm.internal.resolve.VariantAxisCompatibilityFactory;
import org.gradle.jvm.internal.resolve.VariantsMetaData;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.toolchain.internal.DefaultJavaInstallationRegistry;
import org.gradle.jvm.toolchain.internal.JavaInstallationProbe;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;

public class PlatformJvmServices
extends AbstractPluginServiceRegistry {
    public void registerGlobalServices(ServiceRegistration registration) {
        registration.add(JarBinaryRenderer.class);
        registration.add(VariantAxisCompatibilityFactory.class, (Object)DefaultVariantAxisCompatibilityFactory.of(JavaPlatform.class, new DefaultJavaPlatformVariantAxisCompatibility()));
    }

    public void registerBuildTreeServices(ServiceRegistration registration) {
        registration.add(JavaInstallationProbe.class);
    }

    public void registerBuildServices(ServiceRegistration registration) {
        registration.add(DefaultJavaInstallationRegistry.class);
        registration.addProvider((Object)new BuildScopeServices());
    }

    private static class LocalLibraryDependencyResolverFactory
    implements ResolverProviderFactory {
        private final ProjectModelResolver projectModelResolver;
        private final ModelSchemaStore schemaStore;
        private final List<VariantAxisCompatibilityFactory> factories;

        LocalLibraryDependencyResolverFactory(ProjectModelResolver projectModelResolver, ModelSchemaStore schemaStore, List<VariantAxisCompatibilityFactory> factories) {
            this.projectModelResolver = projectModelResolver;
            this.schemaStore = schemaStore;
            this.factories = factories;
        }

        public void create(ResolveContext context, Collection<ComponentResolvers> resolvers) {
            if (context instanceof JvmLibraryResolveContext) {
                VariantsMetaData variants = ((JvmLibraryResolveContext)context).getVariants();
                JvmVariantSelector variantSelector = new JvmVariantSelector(this.factories, JvmBinarySpec.class, this.schemaStore, variants);
                JvmLocalLibraryMetaDataAdapter libraryMetaDataAdapter = new JvmLocalLibraryMetaDataAdapter();
                resolvers.add((ComponentResolvers)new LocalLibraryDependencyResolver(JvmBinarySpec.class, this.projectModelResolver, (LocalLibraryResolver)new DefaultLocalLibraryResolver(), (VariantBinarySelector)variantSelector, (LocalLibraryMetaDataAdapter)libraryMetaDataAdapter, (LibraryResolutionErrorMessageBuilder)new DefaultLibraryResolutionErrorMessageBuilder(variants, this.schemaStore)));
            }
        }
    }

    private static class BuildScopeServices {
        private BuildScopeServices() {
        }

        LocalLibraryDependencyResolverFactory createResolverProviderFactory(ProjectModelResolver projectModelResolver, ModelSchemaStore schemaStore, List<VariantAxisCompatibilityFactory> factories) {
            return new LocalLibraryDependencyResolverFactory(projectModelResolver, schemaStore, factories);
        }
    }
}

