/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.gradle.internal.vfs.WatchingVirtualFileSystem;
import org.gradle.internal.vfs.impl.AbstractDelegatingVirtualFileSystem;
import org.gradle.internal.vfs.impl.AbstractVirtualFileSystem;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.gradle.internal.vfs.watch.FileWatcherRegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWatchingVirtualFileSystem
extends AbstractDelegatingVirtualFileSystem
implements WatchingVirtualFileSystem,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWatchingVirtualFileSystem.class);
    private final FileWatcherRegistryFactory watcherRegistryFactory;
    private final Predicate<String> watchFilter;
    private FileWatcherRegistry watchRegistry;

    public DefaultWatchingVirtualFileSystem(FileWatcherRegistryFactory watcherRegistryFactory, AbstractVirtualFileSystem delegate, Predicate<String> watchFilter) {
        super(delegate);
        this.watcherRegistryFactory = watcherRegistryFactory;
        this.watchFilter = watchFilter;
    }

    @Override
    public void startWatching(Collection<File> mustWatchDirectories) {
        if (this.watchRegistry != null) {
            throw new IllegalStateException("Watch service already started");
        }
        try {
            long startTime = System.currentTimeMillis();
            this.watchRegistry = this.watcherRegistryFactory.startWatching(this.getRoot(), this.watchFilter, mustWatchDirectories);
            long endTime = System.currentTimeMillis() - startTime;
            LOGGER.warn("Spent {} ms registering watches for file system events", (Object)endTime);
        }
        catch (Exception ex) {
            LOGGER.error("Couldn't create watch service, not tracking changes between builds", (Throwable)ex);
            this.invalidateAll();
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWatching() {
        if (this.watchRegistry == null) {
            return;
        }
        final AtomicInteger count = new AtomicInteger();
        final AtomicBoolean unknownEventEncountered = new AtomicBoolean();
        try {
            long startTime = System.currentTimeMillis();
            this.watchRegistry.stopWatching(new FileWatcherRegistry.ChangeHandler(){

                @Override
                public void handleChange(FileWatcherRegistry.Type type, Path path) {
                    count.incrementAndGet();
                    LOGGER.debug("Handling VFS change {} {}", (Object)type, (Object)path);
                    DefaultWatchingVirtualFileSystem.this.update(Collections.singleton(path.toString()), () -> {});
                }

                @Override
                public void handleLostState() {
                    unknownEventEncountered.set(true);
                    LOGGER.warn("Dropped VFS state due to lost state");
                    DefaultWatchingVirtualFileSystem.this.invalidateAll();
                }
            });
            if (!unknownEventEncountered.get()) {
                LOGGER.warn("Received {} file system events since last build", (Object)count);
            }
            LOGGER.warn("Spent {} ms processing file system events since last build", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (IOException ex) {
            LOGGER.error("Couldn't fetch file changes, dropping VFS state", (Throwable)ex);
            this.invalidateAll();
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.watchRegistry != null) {
            try {
                this.watchRegistry.close();
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't close watch service", (Throwable)ex);
            }
            this.watchRegistry = null;
        }
    }
}

