/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.initialization.DefaultSettingsLoader;
import org.gradle.initialization.SettingsAttachingSettingsLoader;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLoaderFactory;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.composite.ChildBuildRegisteringSettingsLoader;
import org.gradle.internal.composite.CommandLineIncludedBuildSettingsLoader;
import org.gradle.internal.composite.CompositeBuildSettingsLoader;
import org.gradle.internal.reflect.Instantiator;

public class DefaultSettingsLoaderFactory
implements SettingsLoaderFactory {
    private final SettingsProcessor settingsProcessor;
    private final BuildStateRegistry buildRegistry;
    private final ProjectStateRegistry projectRegistry;
    private final PublicBuildPath publicBuildPath;
    private final Instantiator instantiator;
    private final BuildLayoutFactory buildLayoutFactory;

    public DefaultSettingsLoaderFactory(SettingsProcessor settingsProcessor, BuildStateRegistry buildRegistry, ProjectStateRegistry projectRegistry, PublicBuildPath publicBuildPath, Instantiator instantiator, BuildLayoutFactory buildLayoutFactory) {
        this.settingsProcessor = settingsProcessor;
        this.buildRegistry = buildRegistry;
        this.projectRegistry = projectRegistry;
        this.publicBuildPath = publicBuildPath;
        this.instantiator = instantiator;
        this.buildLayoutFactory = buildLayoutFactory;
    }

    @Override
    public SettingsLoader forTopLevelBuild() {
        return new CompositeBuildSettingsLoader(new ChildBuildRegisteringSettingsLoader(new CommandLineIncludedBuildSettingsLoader(this.defaultSettingsLoader()), this.buildRegistry, this.publicBuildPath, this.instantiator), this.buildRegistry);
    }

    @Override
    public SettingsLoader forNestedBuild() {
        return new ChildBuildRegisteringSettingsLoader(this.defaultSettingsLoader(), this.buildRegistry, this.publicBuildPath, this.instantiator);
    }

    private SettingsLoader defaultSettingsLoader() {
        return new SettingsAttachingSettingsLoader(new DefaultSettingsLoader(this.settingsProcessor, this.buildLayoutFactory), this.projectRegistry);
    }
}

