/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;

public class EclipseProjectMetadata
implements IdeProjectMetadata {
    private final EclipseProject eclipseProject;
    private final File projectDir;
    private final TaskProvider<? extends Task> generatorTask;

    public EclipseProjectMetadata(EclipseProject eclipseProject, File projectDir, TaskProvider<? extends Task> generatorTask) {
        this.eclipseProject = eclipseProject;
        this.projectDir = projectDir;
        this.generatorTask = generatorTask;
    }

    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((Object)"Eclipse project", (String)this.eclipseProject.getName());
    }

    public String getName() {
        return this.eclipseProject.getName();
    }

    @Override
    public File getFile() {
        return new File(this.projectDir, ".project");
    }

    @Override
    public Set<? extends Task> getGeneratorTasks() {
        return Collections.singleton((Task)this.generatorTask.get());
    }
}

