/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.artifacts.ConfigurationVariantInternal;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.util.TextUtil;

public class JvmPluginsHelper {
    private static void registerClassesDirVariant(final SourceSet sourceSet, ObjectFactory objectFactory, Configuration configuration) {
        ConfigurationPublications publications = configuration.getOutgoing();
        ConfigurationVariantInternal variant = (ConfigurationVariantInternal)publications.getVariants().maybeCreate("classes");
        variant.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)objectFactory.named(LibraryElements.class, "classes")));
        variant.artifactsProvider((Factory)new Factory<List<PublishArtifact>>(){

            @Nullable
            public List<PublishArtifact> create() {
                Set classesDirs = sourceSet.getOutput().getClassesDirs().getFiles();
                DefaultSourceSetOutput output = (DefaultSourceSetOutput)Cast.uncheckedCast((Object)sourceSet.getOutput());
                TaskDependency compileDependencies = output.getCompileDependencies();
                ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)classesDirs.size());
                for (final File classesDir : classesDirs) {
                    artifacts.add((Object)new IntermediateJavaArtifact("java-classes-directory", compileDependencies){

                        public File getFile() {
                            return classesDir;
                        }
                    });
                }
                return artifacts.build();
            }
        });
    }

    public static void addApiToSourceSet(SourceSet sourceSet, ConfigurationContainer configurations) {
        Configuration apiConfiguration = (Configuration)configurations.maybeCreate(sourceSet.getApiConfigurationName());
        apiConfiguration.setVisible(false);
        apiConfiguration.setDescription("API dependencies for " + sourceSet + ".");
        apiConfiguration.setCanBeResolved(false);
        apiConfiguration.setCanBeConsumed(false);
        Configuration apiElementsConfiguration = configurations.getByName(sourceSet.getApiElementsConfigurationName());
        apiElementsConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
        Configuration implementationConfiguration = configurations.getByName(sourceSet.getImplementationConfigurationName());
        implementationConfiguration.extendsFrom(new Configuration[]{apiConfiguration});
        Configuration compileConfiguration = configurations.getByName(sourceSet.getCompileConfigurationName());
        apiConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
    }

    public static void configureForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, AbstractCompile compile, CompileOptions options, Project target) {
        JvmPluginsHelper.configureForSourceSet(sourceSet, sourceDirectorySet, compile, target);
        JvmPluginsHelper.configureAnnotationProcessorPath(sourceSet, sourceDirectorySet, options, target);
    }

    private static void configureForSourceSet(final SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, AbstractCompile compile, final Project target) {
        compile.setDescription("Compiles the " + sourceDirectorySet.getDisplayName() + ".");
        compile.setSource((FileTree)sourceSet.getJava());
        final ConfigurableFileCollection classpath = compile.getProject().getObjects().fileCollection();
        classpath.from(new Object[]{new Callable<Object>(){

            @Override
            public Object call() {
                return sourceSet.getCompileClasspath().plus((FileCollection)target.files(new Object[]{sourceSet.getJava().getClassesDirectory()}));
            }
        }});
        compile.getConventionMapping().map("classpath", (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                return classpath;
            }
        });
    }

    public static void configureAnnotationProcessorPath(final SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, CompileOptions options, final Project target) {
        ConventionMapping conventionMapping = new DslObject((Object)options).getConventionMapping();
        conventionMapping.map("annotationProcessorPath", (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                return sourceSet.getAnnotationProcessorPath();
            }
        });
        final String annotationProcessorGeneratedSourcesChildPath = "generated/sources/annotationProcessor/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
        conventionMapping.map("annotationProcessorGeneratedSourcesDirectory", (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                return new File(target.getBuildDir(), annotationProcessorGeneratedSourcesChildPath);
            }
        });
    }

    public static void configureOutputDirectoryForSourceSet(SourceSet sourceSet, SourceDirectorySet sourceDirectorySet, Project target, Provider<? extends AbstractCompile> compileTask, Provider<CompileOptions> options) {
        TaskProvider taskProvider = (TaskProvider)Cast.uncheckedCast(compileTask);
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, sourceDirectorySet, target, (TaskProvider<? extends AbstractCompile>)taskProvider, options);
    }

    public static void configureOutputDirectoryForSourceSet(SourceSet sourceSet, final SourceDirectorySet sourceDirectorySet, Project target, TaskProvider<? extends AbstractCompile> compileTask, Provider<CompileOptions> options) {
        String sourceSetChildPath = "classes/" + sourceDirectorySet.getName() + "/" + sourceSet.getName();
        sourceDirectorySet.getDestinationDirectory().convention(target.getLayout().getBuildDirectory().dir(sourceSetChildPath));
        DefaultSourceSetOutput sourceSetOutput = (DefaultSourceSetOutput)Cast.cast(DefaultSourceSetOutput.class, (Object)sourceSet.getOutput());
        sourceSetOutput.addClassesDir(new Callable<File>(){

            @Override
            public File call() {
                return (File)sourceDirectorySet.getDestinationDirectory().getAsFile().get();
            }
        });
        sourceSetOutput.registerCompileTask((Provider<? extends AbstractCompile>)compileTask);
        sourceSetOutput.getGeneratedSourcesDirs().from(new Object[]{options.map((Transformer)new Transformer<Object, CompileOptions>(){

            public Object transform(CompileOptions compileOptions) {
                return compileOptions.getAnnotationProcessorGeneratedSourcesDirectory();
            }
        })}).builtBy(new Object[]{compileTask});
        sourceDirectorySet.compiledBy(compileTask, AbstractCompile::getDestinationDirectory);
    }

    public static void configureClassesDirectoryVariant(final SourceSet sourceSet, final Project target, final String targetConfigName, String usage) {
        target.getConfigurations().all((Action)new Action<Configuration>(){

            public void execute(Configuration config) {
                if (targetConfigName.equals(config.getName())) {
                    JvmPluginsHelper.registerClassesDirVariant(sourceSet, target.getObjects(), config);
                }
            }
        });
    }

    public static void configureJavaDocTask(@Nullable String featureName, SourceSet sourceSet, TaskContainer tasks) {
        String javadocTaskName = sourceSet.getJavadocTaskName();
        if (!tasks.getNames().contains(javadocTaskName)) {
            tasks.register(javadocTaskName, Javadoc.class, javadoc -> {
                javadoc.setDescription("Generates Javadoc API documentation for the " + (featureName == null ? "main source code." : "'" + featureName + "' feature."));
                javadoc.setGroup("documentation");
                javadoc.setClasspath(sourceSet.getOutput().plus(sourceSet.getCompileClasspath()));
                javadoc.setSource((FileTree)sourceSet.getAllJava());
            });
        }
    }

    public static void configureDocumentationVariantWithArtifact(String variantName, @Nullable String featureName, String docsType, List<Capability> capabilities, String jarTaskName, Object artifactSource, @Nullable AdhocComponentWithVariants component, ConfigurationContainer configurations, TaskContainer tasks, ObjectFactory objectFactory) {
        Configuration variant = (Configuration)configurations.maybeCreate(variantName);
        variant.setVisible(false);
        variant.setDescription(docsType + " elements for " + (featureName == null ? "main" : featureName) + ".");
        variant.setCanBeResolved(false);
        variant.setCanBeConsumed(true);
        variant.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "java-runtime")));
        variant.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objectFactory.named(Category.class, "documentation")));
        variant.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objectFactory.named(Bundling.class, "external")));
        variant.getAttributes().attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)((DocsType)objectFactory.named(DocsType.class, docsType)));
        capabilities.forEach(arg_0 -> ((ConfigurationPublications)variant.getOutgoing()).capability(arg_0));
        if (!tasks.getNames().contains(jarTaskName)) {
            TaskProvider jarTask = tasks.register(jarTaskName, Jar.class, jar -> {
                jar.setDescription("Assembles a jar archive containing the " + (featureName == null ? "main " + docsType + "." : docsType + " of the '" + featureName + "' feature."));
                jar.setGroup("build");
                jar.from(new Object[]{artifactSource});
                jar.getArchiveClassifier().set((Object)TextUtil.camelToKebabCase((String)(featureName == null ? docsType : featureName + "-" + docsType)));
            });
            if (tasks.getNames().contains("assemble")) {
                tasks.named("assemble").configure(task -> task.dependsOn(new Object[]{jarTask}));
            }
        }
        TaskProvider jar2 = tasks.named(jarTaskName);
        variant.getOutgoing().artifact((Object)new LazyPublishArtifact((Provider)jar2));
        if (component != null) {
            component.addVariantsFromConfiguration(variant, (Action)new JavaConfigurationVariantMapping("runtime", true));
        }
    }

    @Nullable
    public static AdhocComponentWithVariants findJavaComponent(SoftwareComponentContainer components) {
        SoftwareComponent component = (SoftwareComponent)components.findByName("java");
        if (component instanceof AdhocComponentWithVariants) {
            return (AdhocComponentWithVariants)component;
        }
        return null;
    }

    public static abstract class IntermediateJavaArtifact
    extends AbstractPublishArtifact {
        private final String type;

        public IntermediateJavaArtifact(String type, Object task) {
            super(new Object[]{task});
            this.type = type;
        }

        public String getName() {
            return this.getFile().getName();
        }

        public String getExtension() {
            return "";
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public String getClassifier() {
            return null;
        }

        public Date getDate() {
            return null;
        }

        public boolean shouldBePublished() {
            return false;
        }
    }
}

