/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperator;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDynamicOperatorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrTypeBaseKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.AssignmentGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.DynamicCallsKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.OperatorConventionsKt;
import org.jetbrains.kotlin.psi2ir.generators.OperatorExpressionGenerator$WhenMappings;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.psi2ir.intermediate.SafeCallReceiverKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.NewCommonSuperTypeCalculator;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.IntersectionTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\rJ\u001a\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0002J&\u0010\u0014\u001a\u00020\f2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\rH\u0002J8\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010(J\u0018\u0010)\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010*\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020+2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0018\u0010,\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010-\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0011\u001a\u000200J\u000e\u00101\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020+J\u000e\u00102\u001a\u00020\f2\u0006\u0010\u0011\u001a\u000203J\u0018\u00104\u001a\u00020\f2\u0006\u0010\u0011\u001a\u0002032\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0018\u00105\u001a\u0002062\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u00107\u001a\u000208H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010(2\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u0010\u0010:\u001a\u0002082\u0006\u0010\u0011\u001a\u00020\bH\u0002J(\u0010;\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\fH\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u0010\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020\u001fH\u0002J\u0016\u0010C\u001a\u0004\u0018\u00010=*\u0002082\u0006\u0010D\u001a\u000208H\u0002J \u0010E\u001a\u00020\f*\u00020\b2\b\u0010F\u001a\u0004\u0018\u0001082\b\u0010G\u001a\u0004\u0018\u000108H\u0002J \u0010H\u001a\u00020\f*\u00020\f2\b\u0010I\u001a\u0004\u0018\u0001082\b\u0010D\u001a\u0004\u0018\u000108H\u0002\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/OperatorExpressionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "createErrorExpression", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrErrorExpressionImpl;", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "text", "", "generateBinaryBooleanOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "irOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "generateBinaryExpression", "expression", "generateBinaryOperatorAsCall", "origin", "generateCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "generateCastExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "generateComparisonOperator", "generateDynamicArrayAccess", "ktArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "generateDynamicBinaryExpression", "generateDynamicUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "generateElvis", "generateEquality", "startOffset", "", "endOffset", "arg1", "arg2", "comparisonInfo", "Lorg/jetbrains/kotlin/resolve/checkers/PrimitiveNumericComparisonInfo;", "generateEqualityOperator", "generateExclExclOperator", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "generateIdentityOperator", "generateInOperator", "generateInstanceOfExpression", "Lorg/jetbrains/kotlin/ir/IrStatement;", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "generatePostfixExpression", "generatePrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "generatePrefixOperatorAsCall", "getComparisonOperatorSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "primitiveNumericType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getPrimitiveNumericComparisonInfo", "getResultTypeForElvis", "invokeConversionFunction", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "receiver", "isDynamicBinaryOperator", "", "isDynamicUnaryOperator", "ktUnaryExpression", "findConversionFunctionTo", "targetType", "generateAsPrimitiveNumericComparisonOperand", "expressionType", "comparisonType", "promoteToPrimitiveNumericType", "operandType", "ir.psi2ir"})
public final class OperatorExpressionGenerator
extends StatementGeneratorExtension {
    private final IrErrorExpressionImpl createErrorExpression(KtExpression ktExpression, String text2) {
        return new IrErrorExpressionImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktExpression), PsiUtilsKt.getEndOffset(ktExpression), this.getContext().getIrBuiltIns().getNothingType(), text2);
    }

    @NotNull
    public final IrExpression generatePrefixExpression(@NotNull KtPrefixExpression expression2) {
        IrExpression irExpression;
        IrStatementOrigin irOperator;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrStatementOrigin irStatementOrigin = irOperator = OperatorConventionsKt.getPrefixOperator(ktOperator);
        if (irStatementOrigin == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected prefix operator: " + ktOperator)));
        }
        if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getINCREMENT_DECREMENT_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generatePrefixIncrementDecrement(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getOPERATORS_DESUGARED_TO_CALLS(), (Object)irStatementOrigin)) {
            irExpression = this.generatePrefixOperatorAsCall(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string2 = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ktOperator.toString()");
            irExpression = this.createErrorExpression(ktExpression, string2);
        }
        return irExpression;
    }

    @NotNull
    public final IrExpression generatePostfixExpression(@NotNull KtPostfixExpression expression2) {
        IrExpression irExpression;
        IrStatementOrigin irOperator;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrStatementOrigin irStatementOrigin = irOperator = OperatorConventionsKt.getPostfixOperator(ktOperator);
        if (irStatementOrigin == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected postfix operator: " + ktOperator)));
        }
        if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getINCREMENT_DECREMENT_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generatePostfixIncrementDecrement(expression2, irOperator);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEXCL.INSTANCE)) {
            irExpression = this.generateExclExclOperator(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string2 = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ktOperator.toString()");
            irExpression = this.createErrorExpression(ktExpression, string2);
        }
        return irExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final IrExpression generateCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        KotlinType kotlinType2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrTypeOperator irOperator = OperatorConventionsKt.getIrTypeOperator(ktOperator);
        WritableSlice<KtTypeReference, KotlinType> writableSlice = BindingContext.TYPE;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.TYPE");
        ReadOnlySlice readOnlySlice = writableSlice;
        KtTypeReference ktTypeReference = expression2.getRight();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KotlinType rhsType = (KotlinType)GeneratorKt.getOrFail(this, readOnlySlice, ktTypeReference);
        IrTypeOperator irTypeOperator = irOperator;
        if (irTypeOperator == null) throw (Throwable)((Object)new AssertionError((Object)("Unexpected IrTypeOperator: " + (Object)((Object)irOperator))));
        switch (OperatorExpressionGenerator$WhenMappings.$EnumSwitchMapping$0[irTypeOperator.ordinal()]) {
            case 1: {
                kotlinType2 = rhsType;
                break;
            }
            case 2: {
                KotlinType kotlinType3 = rhsType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"rhsType");
                kotlinType2 = TypeUtilsKt.makeNullable(kotlinType3);
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected IrTypeOperator: " + (Object)((Object)irOperator))));
            }
        }
        KotlinType resultType = kotlinType2;
        int n = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int n2 = PsiUtilsKt.getEndOffset(expression2);
        KotlinType kotlinType4 = resultType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"resultType");
        IrType irType = this.toIrType(kotlinType4);
        KotlinType kotlinType5 = rhsType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType5, (String)"rhsType");
        IrType irType2 = this.toIrType(kotlinType5);
        KtExpression ktExpression = expression2.getLeft();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left");
        return new IrTypeOperatorCallImpl(n, n2, irType, irOperator, irType2, this.genExpr(ktExpression));
    }

    @NotNull
    public final IrStatement generateInstanceOfExpression(@NotNull KtIsExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        IrTypeOperator irTypeOperator = OperatorConventionsKt.getIrTypeOperator(ktOperator);
        if (irTypeOperator == null) {
            Intrinsics.throwNpe();
        }
        IrTypeOperator irOperator = irTypeOperator;
        WritableSlice<KtTypeReference, KotlinType> writableSlice = BindingContext.TYPE;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.TYPE");
        KotlinType againstType = (KotlinType)GeneratorKt.getOrFail(this, writableSlice, expression2.getTypeReference());
        int n = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int n2 = PsiUtilsKt.getEndOffset(expression2);
        IrType irType = this.getContext().getIrBuiltIns().getBooleanType();
        KotlinType kotlinType2 = againstType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"againstType");
        IrType irType2 = this.toIrType(kotlinType2);
        KtExpression ktExpression = expression2.getLeftHandSide();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.leftHandSide");
        return new IrTypeOperatorCallImpl(n, n2, irType, irOperator, irType2, this.genExpr(ktExpression));
    }

    @NotNull
    public final IrExpression generateBinaryExpression(@NotNull KtBinaryExpression expression2) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType ktOperator = expression2.getOperationReference().getReferencedNameElementType();
        if (Intrinsics.areEqual((Object)ktOperator, (Object)KtTokens.IDENTIFIER)) {
            return this.generateBinaryOperatorAsCall(expression2, null);
        }
        IrStatementOrigin irOperator = OperatorConventionsKt.getInfixOperator(ktOperator);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (irStatementOrigin == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected infix operator: " + ktOperator)));
        }
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQ.INSTANCE)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generateAssignment(expression2);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getAUGMENTED_ASSIGNMENTS(), (Object)irStatementOrigin)) {
            irExpression = new AssignmentGenerator(this.getStatementGenerator()).generateAugmentedAssignment(expression2, irOperator);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.ELVIS.INSTANCE)) {
            irExpression = this.generateElvis(expression2);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getOPERATORS_DESUGARED_TO_CALLS(), (Object)irStatementOrigin)) {
            irExpression = this.generateBinaryOperatorAsCall(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getCOMPARISON_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateComparisonOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getEQUALITY_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateEqualityOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getIDENTITY_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateIdentityOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getIN_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateInOperator(expression2, irOperator);
        } else if (CollectionsKt.contains((Iterable)OperatorConventionsKt.getBINARY_BOOLEAN_OPERATORS(), (Object)irStatementOrigin)) {
            irExpression = this.generateBinaryBooleanOperator(expression2, irOperator);
        } else {
            KtExpression ktExpression = expression2;
            String string2 = ktOperator.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ktOperator.toString()");
            irExpression = this.createErrorExpression(ktExpression, string2);
        }
        return irExpression;
    }

    private final boolean isDynamicUnaryOperator(KtUnaryExpression ktUnaryExpression) {
        KtExpression ktExpression = ktUnaryExpression.getBaseExpression();
        if (ktExpression == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"ktUnaryExpression.baseExpression ?: return false");
        KtExpression arg = ktExpression;
        KotlinType kotlinType2 = this.getContext().getBindingContext().getType(arg);
        if (kotlinType2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.bindingContext.g\u2026Type(arg) ?: return false");
        KotlinType argType = kotlinType2;
        return DynamicTypesKt.isDynamic(argType);
    }

    private final boolean isDynamicBinaryOperator(KtBinaryExpression ktExpression) {
        KtExpression ktExpression2 = ktExpression.getLeft();
        if (ktExpression2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktExpression.left ?: return false");
        KtExpression lhs = ktExpression2;
        KotlinType kotlinType2 = this.getContext().getBindingContext().getType(lhs);
        if (kotlinType2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.bindingContext.g\u2026Type(lhs) ?: return false");
        KotlinType lhsType = kotlinType2;
        return DynamicTypesKt.isDynamic(lhsType);
    }

    private final IrExpression generateDynamicUnaryExpression(KtUnaryExpression ktExpression) {
        KtExpression ktExpression2 = ktExpression.getBaseExpression();
        if (ktExpression2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No arg in " + ktExpression.getText())));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktExpression.baseExpress\u2026in ${ktExpression.text}\")");
        KtExpression ktArg = ktExpression2;
        KotlinType kotlinType2 = this.getContext().getBindingContext().getType(ktExpression);
        if (kotlinType2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No type for " + ktExpression.getText())));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.bindingContext.g\u2026or ${ktExpression.text}\")");
        KotlinType kotlinType3 = kotlinType2;
        IrDynamicOperator operator = DynamicCallsKt.getDynamicOperator(ktExpression);
        IrDynamicOperatorExpressionImpl irDynamicOperatorExpressionImpl = new IrDynamicOperatorExpressionImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktExpression), PsiUtilsKt.getEndOffset(ktExpression), this.toIrType(kotlinType3), operator);
        boolean bl = false;
        boolean bl2 = false;
        IrDynamicOperatorExpressionImpl $this$apply = irDynamicOperatorExpressionImpl;
        boolean bl3 = false;
        $this$apply.setReceiver(this.genExpr(ktArg));
        return irDynamicOperatorExpressionImpl;
    }

    private final IrExpression generateDynamicBinaryExpression(KtBinaryExpression ktExpression) {
        KtExpression ktExpression2 = ktExpression.getLeft();
        if (ktExpression2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No LHS in " + ktExpression.getText())));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktExpression.left ?: thr\u2026in ${ktExpression.text}\")");
        KtExpression ktLeft = ktExpression2;
        KtExpression ktExpression3 = ktExpression.getRight();
        if (ktExpression3 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No RHS in " + ktExpression.getText())));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"ktExpression.right ?: th\u2026in ${ktExpression.text}\")");
        KtExpression ktRight = ktExpression3;
        KotlinType kotlinType2 = this.getContext().getBindingContext().getType(ktExpression);
        if (kotlinType2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No type for " + ktExpression.getText())));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.bindingContext.g\u2026or ${ktExpression.text}\")");
        KotlinType kotlinType3 = kotlinType2;
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(ktExpression);
        int endOffset = PsiUtilsKt.getEndOffset(ktExpression);
        IrType irType = this.toIrType(kotlinType3);
        if (Intrinsics.areEqual((Object)ktExpression.getOperationToken(), (Object)KtTokens.IDENTIFIER)) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, ktExpression);
            if (resolvedCall2 == null) {
                Intrinsics.throwNpe();
            }
            return this.generateCall(resolvedCall2, ktExpression, null);
        }
        IrDynamicOperator operator = DynamicCallsKt.getDynamicOperator(ktExpression);
        IrDynamicOperatorExpressionImpl irDynamicOperatorExpressionImpl = new IrDynamicOperatorExpressionImpl(startOffset, endOffset, irType, operator);
        boolean bl = false;
        boolean bl2 = false;
        IrDynamicOperatorExpressionImpl $this$apply = irDynamicOperatorExpressionImpl;
        boolean bl3 = false;
        IrDynamicExpressionKt.setLeft($this$apply, this.genExpr(ktLeft));
        IrDynamicExpressionKt.setRight($this$apply, this.genExpr(ktRight));
        return irDynamicOperatorExpressionImpl;
    }

    private final KotlinType getResultTypeForElvis(KtExpression expression2) {
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize(expression2);
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"KtPsiUtil.safeDeparenthesize(expression)");
        KtExpression binaryExpression = ktExpression;
        KotlinType kotlinType2 = this.getContext().getBindingContext().getType(binaryExpression);
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.bindingContext.getType(binaryExpression)!!");
        KotlinType expressionType = kotlinType2;
        if (!(binaryExpression instanceof KtBinaryExpression) || Intrinsics.areEqual((Object)((KtBinaryExpression)binaryExpression).getOperationToken(), (Object)KtTokens.ELVIS) ^ true) {
            return expressionType;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, binaryExpression);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        KotlinType kotlinType3 = resolvedCall2.getResultingDescriptor().getReturnType();
        if (kotlinType3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"getResolvedCall(binaryEx\u2026ngDescriptor.returnType!!");
        KotlinType inferredType = kotlinType3;
        if (this.getContext().getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            return inferredType;
        }
        if (!KotlinTypeKt.isError(inferredType)) {
            return inferredType;
        }
        KtExpression ktExpression2 = ((KtBinaryExpression)binaryExpression).getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"binaryExpression.right!!");
        UnwrappedType rightType = this.getResultTypeForElvis(ktExpression2).unwrap();
        KtExpression ktExpression3 = ((KtBinaryExpression)binaryExpression).getLeft();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"binaryExpression.left!!");
        UnwrappedType leftType = this.getResultTypeForElvis(ktExpression3).unwrap();
        Object[] objectArray = new UnwrappedType[2];
        objectArray[0] = leftType;
        SimpleType simpleType2 = this.getContext().getBuiltIns().getAnyType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.anyType");
        objectArray[1] = simpleType2;
        UnwrappedType leftNNType = IntersectionTypeKt.intersectTypes(CollectionsKt.listOf((Object[])objectArray));
        return NewCommonSuperTypeCalculator.INSTANCE.commonSuperType(CollectionsKt.listOf((Object[])new UnwrappedType[]{rightType, leftNNType}));
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateElvis(KtBinaryExpression expression2) {
        void endOffset$iv;
        void startOffset$iv;
        void $this$irBlock$iv;
        IrType resultType = this.toIrType(this.getResultTypeForElvis(expression2));
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = this.genExpr(ktExpression);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = this.genExpr(ktExpression2);
        OperatorExpressionGenerator operatorExpressionGenerator = this;
        int n = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int n2 = PsiUtilsKt.getEndOffset(expression2);
        IrStatementOrigin origin$iv = IrStatementOrigin.ELVIS.INSTANCE;
        boolean $i$f$irBlock = false;
        IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType, false, 64, null);
        boolean $i$f$block = false;
        IrBlockBuilder $this$irBlock = this_$iv$iv;
        boolean bl = false;
        IrVariable temporary = ExpressionHelpersKt.irTemporary$default($this$irBlock, irArgument0, "elvis_lhs", null, null, 12, null);
        $this$irBlock.unaryPlus(ExpressionHelpersKt.irIfNull($this$irBlock, resultType, ExpressionHelpersKt.irGet($this$irBlock, temporary.getType(), temporary.getSymbol()), irArgument1, ExpressionHelpersKt.irGet($this$irBlock, temporary.getType(), temporary.getSymbol())));
        return this_$iv$iv.doBuild();
    }

    private final IrExpression generateBinaryBooleanOperator(KtBinaryExpression ktExpression, IrStatementOrigin irOperator) {
        IrWhen irWhen;
        if (this.isDynamicBinaryOperator(ktExpression)) {
            return this.generateDynamicBinaryExpression(ktExpression);
        }
        KtExpression ktExpression2 = ktExpression.getLeft();
        if (ktExpression2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No LHS in " + ktExpression.getText())));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktExpression.left ?: thr\u2026in ${ktExpression.text}\")");
        KtExpression ktLeft = ktExpression2;
        KtExpression ktExpression3 = ktExpression.getRight();
        if (ktExpression3 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No RHS in " + ktExpression.getText())));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"ktExpression.right ?: th\u2026in ${ktExpression.text}\")");
        KtExpression ktRight = ktExpression3;
        IrExpression irArgument0 = this.genExpr(ktLeft);
        IrExpression irArgument1 = this.genExpr(ktRight);
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(ktExpression);
        int endOffset = PsiUtilsKt.getEndOffset(ktExpression);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.OROR.INSTANCE)) {
            irWhen = PrimitivesKt.oror$default(this.getContext(), startOffset, endOffset, irArgument0, irArgument1, null, 16, null);
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.ANDAND.INSTANCE)) {
            irWhen = PrimitivesKt.andand$default(this.getContext(), startOffset, endOffset, irArgument0, irArgument1, null, 16, null);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected binary boolean operator " + irOperator)));
        }
        return irWhen;
    }

    private final IrExpression generateInOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> containsCall = resolvedCall2;
        IrExpression irContainsCall = this.generateCall(containsCall, expression2, irOperator);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.IN.INSTANCE)) {
            irExpression = irContainsCall;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.NOT_IN.INSTANCE)) {
            irExpression = PrimitivesKt.primitiveOp1(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), this.getContext().getIrBuiltIns().getBooleanNotSymbol(), this.getContext().getIrBuiltIns().getBooleanType(), IrStatementOrigin.NOT_IN.INSTANCE, irContainsCall);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected in-operator " + irOperator)));
        }
        return irExpression;
    }

    private final IrExpression generateIdentityOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        if (this.isDynamicBinaryOperator(expression2)) {
            return this.generateDynamicBinaryExpression(expression2);
        }
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        IrExpression irArgument0 = this.genExpr(ktExpression);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        IrExpression irArgument1 = this.genExpr(ktExpression2);
        IrExpression irIdentityEquals = PrimitivesKt.primitiveOp2(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), this.getContext().getIrBuiltIns().getEqeqeqSymbol(), this.getContext().getIrBuiltIns().getBooleanType(), irOperator, irArgument0, irArgument1);
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQEQEQ.INSTANCE)) {
            irExpression = irIdentityEquals;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEQEQ.INSTANCE)) {
            irExpression = PrimitivesKt.primitiveOp1(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), this.getContext().getIrBuiltIns().getBooleanNotSymbol(), this.getContext().getIrBuiltIns().getBooleanType(), IrStatementOrigin.EXCLEQEQ.INSTANCE, irIdentityEquals);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected identity operator " + irOperator)));
        }
        return irExpression;
    }

    private final IrExpression generateAsPrimitiveNumericComparisonOperand(@NotNull KtExpression $this$generateAsPrimitiveNumericComparisonOperand, KotlinType expressionType, KotlinType comparisonType) {
        return this.promoteToPrimitiveNumericType(this.genExpr($this$generateAsPrimitiveNumericComparisonOperand), expressionType, comparisonType);
    }

    private final PrimitiveNumericComparisonInfo getPrimitiveNumericComparisonInfo(KtBinaryExpression ktExpression) {
        return (PrimitiveNumericComparisonInfo)this.getContext().getBindingContext().get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, ktExpression);
    }

    private final IrExpression generateEqualityOperator(KtBinaryExpression expression2, IrStatementOrigin irOperator) {
        IrExpression irExpression;
        PrimitiveNumericComparisonInfo comparisonInfo;
        if (this.isDynamicBinaryOperator(expression2)) {
            return this.generateDynamicBinaryExpression(expression2);
        }
        PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo = comparisonInfo = this.getPrimitiveNumericComparisonInfo(expression2);
        KotlinType comparisonType = primitiveNumericComparisonInfo != null ? primitiveNumericComparisonInfo.getComparisonType() : null;
        Map<SimpleType, IrSimpleFunctionSymbol> map2 = this.getContext().getIrBuiltIns().getIeee754equalsFunByOperandType();
        boolean bl = false;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = map2.get(comparisonType);
        if (irSimpleFunctionSymbol == null) {
            irSimpleFunctionSymbol = this.getContext().getIrBuiltIns().getEqeqSymbol();
        }
        IrSimpleFunctionSymbol eqeqSymbol = irSimpleFunctionSymbol;
        int n = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int n2 = PsiUtilsKt.getEndOffset(expression2);
        IrType irType = this.getContext().getIrBuiltIns().getBooleanType();
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
        PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo2 = comparisonInfo;
        IrExpression irExpression2 = this.generateAsPrimitiveNumericComparisonOperand(ktExpression, primitiveNumericComparisonInfo2 != null ? primitiveNumericComparisonInfo2.getLeftType() : null, comparisonType);
        KtExpression ktExpression2 = expression2.getRight();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
        PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo3 = comparisonInfo;
        IrExpression irEquals = PrimitivesKt.primitiveOp2(n, n2, eqeqSymbol, irType, irOperator, irExpression2, this.generateAsPrimitiveNumericComparisonOperand(ktExpression2, primitiveNumericComparisonInfo3 != null ? primitiveNumericComparisonInfo3.getRightType() : null, comparisonType));
        IrStatementOrigin irStatementOrigin = irOperator;
        if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EQEQ.INSTANCE)) {
            irExpression = irEquals;
        } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.EXCLEQ.INSTANCE)) {
            irExpression = PrimitivesKt.primitiveOp1(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), this.getContext().getIrBuiltIns().getBooleanNotSymbol(), this.getContext().getIrBuiltIns().getBooleanType(), IrStatementOrigin.EXCLEQ.INSTANCE, irEquals);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected equality operator " + irOperator)));
        }
        return irExpression;
    }

    @NotNull
    public final IrExpression generateEquality(int startOffset, int endOffset, @NotNull IrStatementOrigin irOperator, @NotNull IrExpression arg1, @NotNull IrExpression arg2, @Nullable PrimitiveNumericComparisonInfo comparisonInfo) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)irOperator, (String)"irOperator");
        Intrinsics.checkParameterIsNotNull((Object)arg1, (String)"arg1");
        Intrinsics.checkParameterIsNotNull((Object)arg2, (String)"arg2");
        if (comparisonInfo != null) {
            KotlinType comparisonType = comparisonInfo.getComparisonType();
            Map<SimpleType, IrSimpleFunctionSymbol> map2 = this.getContext().getIrBuiltIns().getIeee754equalsFunByOperandType();
            boolean bl = false;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = map2.get(comparisonType);
            if (irSimpleFunctionSymbol == null) {
                irSimpleFunctionSymbol = this.getContext().getIrBuiltIns().getEqeqSymbol();
            }
            IrSimpleFunctionSymbol eqeqSymbol = irSimpleFunctionSymbol;
            irExpression = PrimitivesKt.primitiveOp2(startOffset, endOffset, eqeqSymbol, this.getContext().getIrBuiltIns().getBooleanType(), irOperator, this.promoteToPrimitiveNumericType(arg1, comparisonInfo.getLeftType(), comparisonType), this.promoteToPrimitiveNumericType(arg2, comparisonInfo.getRightType(), comparisonType));
        } else {
            irExpression = PrimitivesKt.primitiveOp2(startOffset, endOffset, this.getContext().getIrBuiltIns().getEqeqSymbol(), this.getContext().getIrBuiltIns().getBooleanType(), irOperator, arg1, arg2);
        }
        return irExpression;
    }

    private final IrExpression promoteToPrimitiveNumericType(@NotNull IrExpression $this$promoteToPrimitiveNumericType, KotlinType operandType, KotlinType targetType) {
        IrExpression irExpression;
        if (targetType == null) {
            return $this$promoteToPrimitiveNumericType;
        }
        if (operandType == null) {
            throw (Throwable)((Object)new AssertionError((Object)"operandType should be non-null"));
        }
        KotlinType operandNNType = TypeUtilsKt.makeNotNullable(operandType);
        FunctionDescriptor conversionFunction = this.findConversionFunctionTo(operandNNType, targetType);
        if (!TypeUtilsKt.isPrimitiveNumberType(operandNNType)) {
            throw (Throwable)((Object)new AssertionError((Object)("Primitive number type or nullable primitive number type expected: " + $this$promoteToPrimitiveNumericType.getType())));
        }
        if (Intrinsics.areEqual((Object)operandType, (Object)targetType) || Intrinsics.areEqual((Object)operandNNType, (Object)targetType)) {
            irExpression = $this$promoteToPrimitiveNumericType;
        } else {
            KotlinType kotlinType2 = IrTypeBaseKt.getOriginalKotlinType($this$promoteToPrimitiveNumericType.getType());
            if (kotlinType2 == null) {
                Intrinsics.throwNpe();
            }
            if (KotlinUtilsKt.containsNull(kotlinType2)) {
                irExpression = SafeCallReceiverKt.safeCallOnDispatchReceiver($this$promoteToPrimitiveNumericType, this, $this$promoteToPrimitiveNumericType.getStartOffset(), $this$promoteToPrimitiveNumericType.getEndOffset(), (Function1<? super IrExpression, ? extends IrExpression>)((Function1)new Function1<IrExpression, IrExpression>(this, $this$promoteToPrimitiveNumericType, conversionFunction, targetType){
                    final /* synthetic */ OperatorExpressionGenerator this$0;
                    final /* synthetic */ IrExpression $this_promoteToPrimitiveNumericType;
                    final /* synthetic */ FunctionDescriptor $conversionFunction;
                    final /* synthetic */ KotlinType $targetType;

                    @NotNull
                    public final IrExpression invoke(@NotNull IrExpression dispatchReceiver) {
                        Intrinsics.checkParameterIsNotNull((Object)dispatchReceiver, (String)"dispatchReceiver");
                        FunctionDescriptor functionDescriptor = this.$conversionFunction;
                        if (functionDescriptor == null) {
                            throw (Throwable)((Object)new AssertionError((Object)("No conversion function for " + this.$this_promoteToPrimitiveNumericType.getType() + " ~> " + this.$targetType)));
                        }
                        return OperatorExpressionGenerator.access$invokeConversionFunction(this.this$0, this.$this_promoteToPrimitiveNumericType.getStartOffset(), this.$this_promoteToPrimitiveNumericType.getEndOffset(), functionDescriptor, dispatchReceiver);
                    }
                    {
                        this.this$0 = operatorExpressionGenerator;
                        this.$this_promoteToPrimitiveNumericType = irExpression;
                        this.$conversionFunction = functionDescriptor;
                        this.$targetType = kotlinType2;
                        super(1);
                    }
                }));
            } else {
                FunctionDescriptor functionDescriptor = conversionFunction;
                if (functionDescriptor == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("No conversion function for " + $this$promoteToPrimitiveNumericType.getType() + " ~> " + targetType)));
                }
                irExpression = this.invokeConversionFunction($this$promoteToPrimitiveNumericType.getStartOffset(), $this$promoteToPrimitiveNumericType.getEndOffset(), functionDescriptor, $this$promoteToPrimitiveNumericType);
            }
        }
        return irExpression;
    }

    private final IrExpression invokeConversionFunction(int startOffset, int endOffset, FunctionDescriptor functionDescriptor, IrExpression receiver) {
        KotlinType kotlinType2 = functionDescriptor.getReturnType();
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"functionDescriptor.returnType!!");
        IrType irType = this.toIrType(kotlinType2);
        ReferenceSymbolTable referenceSymbolTable = this.getContext().getSymbolTable();
        FunctionDescriptor functionDescriptor2 = functionDescriptor.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"functionDescriptor.original");
        IrCallImpl irCallImpl = new IrCallImpl(startOffset, endOffset, irType, IrUtilsKt.referenceFunction(referenceSymbolTable, functionDescriptor2), functionDescriptor, null, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl $this$apply = irCallImpl;
        boolean bl3 = false;
        $this$apply.setDispatchReceiver(receiver);
        return irCallImpl;
    }

    private final FunctionDescriptor findConversionFunctionTo(@NotNull KotlinType $this$findConversionFunctionTo, KotlinType targetType) {
        Object object = targetType.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = object.getName()) == null || (object = ((Name)object).asString()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"targetType.constructor.d\u2026asString() ?: return null");
        Object targetTypeName = object;
        MemberScope memberScope2 = $this$findConversionFunctionTo.getMemberScope();
        Name name = Name.identifier("to" + (String)targetTypeName);
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"to$targetTypeName\")");
        return KotlinUtilsKt.findSingleFunction(memberScope2, name);
    }

    private final IrExpression generateComparisonOperator(KtBinaryExpression ktExpression, IrStatementOrigin origin) {
        IrExpression irExpression;
        if (this.isDynamicBinaryOperator(ktExpression)) {
            return this.generateDynamicBinaryExpression(ktExpression);
        }
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(ktExpression);
        int endOffset = PsiUtilsKt.getEndOffset(ktExpression);
        PrimitiveNumericComparisonInfo comparisonInfo = this.getPrimitiveNumericComparisonInfo(ktExpression);
        KtExpression ktExpression2 = ktExpression.getLeft();
        if (ktExpression2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No LHS in " + ktExpression.getText())));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktExpression.left ?: thr\u2026in ${ktExpression.text}\")");
        KtExpression ktLeft = ktExpression2;
        KtExpression ktExpression3 = ktExpression.getRight();
        if (ktExpression3 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No RHS in " + ktExpression.getText())));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"ktExpression.right ?: th\u2026in ${ktExpression.text}\")");
        KtExpression ktRight = ktExpression3;
        if (comparisonInfo != null) {
            irExpression = PrimitivesKt.primitiveOp2(startOffset, endOffset, this.getComparisonOperatorSymbol(origin, comparisonInfo.getComparisonType()), this.getContext().getIrBuiltIns().getBooleanType(), origin, this.generateAsPrimitiveNumericComparisonOperand(ktLeft, comparisonInfo.getLeftType(), comparisonInfo.getComparisonType()), this.generateAsPrimitiveNumericComparisonOperand(ktRight, comparisonInfo.getRightType(), comparisonInfo.getComparisonType()));
        } else {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, ktExpression);
            if (resolvedCall2 == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No resolved call for comparison operator " + ktExpression.getText())));
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            irExpression = PrimitivesKt.primitiveOp2(startOffset, endOffset, this.getComparisonOperatorSymbol(origin, this.getContext().getIrBuiltIns().getInt()), this.getContext().getIrBuiltIns().getBooleanType(), origin, this.generateCall(resolvedCall3, ktExpression, origin), IrConstImpl.Companion.int(startOffset, endOffset, this.getContext().getIrBuiltIns().getIntType(), 0));
        }
        return irExpression;
    }

    private final IrExpression generateCall(ResolvedCall<?> resolvedCall2, KtExpression ktExpression, IrStatementOrigin origin) {
        return CallGeneratorKt.generateCall(new CallGenerator(this.getStatementGenerator()), ktExpression, ArgumentsGenerationUtilsKt.pregenerateCall(this.getStatementGenerator(), resolvedCall2), origin);
    }

    private final IrSimpleFunctionSymbol getComparisonOperatorSymbol(IrStatementOrigin origin, KotlinType primitiveNumericType) {
        Map<SimpleType, IrSimpleFunctionSymbol> map2;
        Object object = origin;
        if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.LT.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getLessFunByOperandType();
        } else if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.LTEQ.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getLessOrEqualFunByOperandType();
        } else if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.GT.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getGreaterFunByOperandType();
        } else if (Intrinsics.areEqual((Object)object, (Object)IrStatementOrigin.GTEQ.INSTANCE)) {
            map2 = this.getContext().getIrBuiltIns().getGreaterOrEqualFunByOperandType();
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected comparison operator: " + origin)));
        }
        object = map2;
        boolean bl = false;
        Object v = object.get(primitiveNumericType);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (IrSimpleFunctionSymbol)v;
    }

    private final IrExpression generateExclExclOperator(KtPostfixExpression expression2, IrStatementOrigin origin) {
        KtExpression ktExpression = expression2.getBaseExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.baseExpression!!");
        KtExpression ktArgument = ktExpression;
        IrExpression irArgument = this.genExpr(ktArgument);
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.operationReference");
        KtSimpleNameExpression ktOperator = ktSimpleNameExpression;
        KotlinType kotlinType2 = this.getContext().getBindingContext().getType(ktArgument);
        if (kotlinType2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)"No type for !! argument"));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.bindingContext.g\u2026No type for !! argument\")");
        KotlinType argumentType = kotlinType2;
        KotlinType expressionType = TypeUtilsKt.makeNotNullable(argumentType);
        FunctionDescriptor checkNotNull = this.getContext().getIrBuiltIns().getCheckNotNull();
        TypeParameterDescriptor typeParameterDescriptor = checkNotNull.getTypeParameters().get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"checkNotNull.typeParameters[0]");
        FunctionDescriptor functionDescriptor = checkNotNull.substitute(TypeSubstitutor.create(MapsKt.mapOf((Pair)TuplesKt.to((Object)typeParameterDescriptor.getTypeConstructor(), (Object)new TypeProjectionImpl(argumentType)))));
        if (functionDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Substitution failed for " + checkNotNull + ": T=" + argumentType)));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"checkNotNull.substitute(\u2026otNull: T=$argumentType\")");
        FunctionDescriptor checkNotNullSubstituted = functionDescriptor;
        IrCallImpl irCallImpl = new IrCallImpl(PsiUtilsKt.getStartOffsetSkippingComments(ktOperator), PsiUtilsKt.getEndOffset(ktOperator), this.toIrType(expressionType), (IrFunctionSymbol)this.getContext().getIrBuiltIns().getCheckNotNullSymbol(), checkNotNullSubstituted, origin, null, 64, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl $this$apply = irCallImpl;
        boolean bl3 = false;
        $this$apply.putTypeArgument(0, IrTypesKt.makeNotNull(this.toIrType(argumentType)));
        $this$apply.putValueArgument(0, irArgument);
        return irCallImpl;
    }

    private final IrExpression generateBinaryOperatorAsCall(KtBinaryExpression expression2, IrStatementOrigin origin) {
        IrExpression irExpression;
        if (this.isDynamicBinaryOperator(expression2)) {
            irExpression = this.generateDynamicBinaryExpression(expression2);
        } else {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
            if (resolvedCall2 == null) {
                Intrinsics.throwNpe();
            }
            irExpression = this.generateCall(resolvedCall2, expression2, origin);
        }
        return irExpression;
    }

    private final IrExpression generatePrefixOperatorAsCall(KtPrefixExpression expression2, IrStatementOrigin origin) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (expression2.getBaseExpression() instanceof KtConstantExpression) {
            CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, this.getContext().getBindingContext());
            if (compileTimeConstant != null) {
                KotlinType receiverType;
                CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
                boolean bl = false;
                boolean bl2 = false;
                CompileTimeConstant<?> constant = compileTimeConstant2;
                boolean bl3 = false;
                ReceiverValue receiverValue = resolvedCall3.getDispatchReceiver();
                KotlinType kotlinType2 = receiverType = receiverValue != null ? receiverValue.getType() : null;
                if (receiverType != null && KotlinBuiltIns.isPrimitiveType(receiverType)) {
                    return this.getStatementGenerator().generateConstantExpression(expression2, constant);
                }
            }
        }
        if (this.isDynamicUnaryOperator(expression2)) {
            return this.generateDynamicUnaryExpression(expression2);
        }
        return this.generateCall(resolvedCall3, expression2, origin);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression generateDynamicArrayAccess(@NotNull KtArrayAccessExpression ktArrayAccessExpression) {
        void $this$mapTo$iv;
        Intrinsics.checkParameterIsNotNull((Object)ktArrayAccessExpression, (String)"ktArrayAccessExpression");
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(ktArrayAccessExpression);
        int endOffset = PsiUtilsKt.getEndOffset(ktArrayAccessExpression);
        KotlinType kotlinType2 = this.getContext().getBindingContext().getType(ktArrayAccessExpression);
        if (kotlinType2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No type for " + ktArrayAccessExpression.getText())));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"context.bindingContext.g\u2026yAccessExpression.text}\")");
        KotlinType kotlinType3 = kotlinType2;
        IrDynamicOperatorExpressionImpl irDynamicOperatorExpressionImpl = new IrDynamicOperatorExpressionImpl(startOffset, endOffset, this.toIrType(kotlinType3), IrDynamicOperator.ARRAY_ACCESS);
        boolean bl = false;
        boolean bl2 = false;
        IrDynamicOperatorExpressionImpl $this$apply = irDynamicOperatorExpressionImpl;
        boolean bl3 = false;
        KtExpression ktExpression = ktArrayAccessExpression.getArrayExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"ktArrayAccessExpression.arrayExpression!!");
        $this$apply.setReceiver(this.genExpr(ktExpression));
        List<KtExpression> list2 = ktArrayAccessExpression.getIndexExpressions();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ktArrayAccessExpression.indexExpressions");
        Iterable iterable = list2;
        Collection destination$iv = $this$apply.getArguments();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KtExpression ktExpression2 = (KtExpression)item$iv;
            Collection collection = destination$iv;
            boolean bl4 = false;
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            IrExpression irExpression = this.genExpr((KtExpression)v3);
            collection.add(irExpression);
        }
        return irDynamicOperatorExpressionImpl;
    }

    public OperatorExpressionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }

    public static final /* synthetic */ IrExpression access$invokeConversionFunction(OperatorExpressionGenerator $this, int startOffset, int endOffset, FunctionDescriptor functionDescriptor, IrExpression receiver) {
        return $this.invokeConversionFunction(startOffset, endOffset, functionDescriptor, receiver);
    }
}

