/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;

class FlatMapProvider<S, T>
extends AbstractMinimalProvider<S> {
    private final ProviderInternal<? extends T> provider;
    private final Transformer<? extends Provider<? extends S>, ? super T> transformer;

    FlatMapProvider(ProviderInternal<? extends T> provider, Transformer<? extends Provider<? extends S>, ? super T> transformer) {
        this.provider = provider;
        this.transformer = transformer;
    }

    @Override
    @Nullable
    public Class<S> getType() {
        return null;
    }

    @Override
    public boolean isPresent() {
        Object value = this.provider.getOrNull();
        if (value == null) {
            return false;
        }
        return this.map(value).isPresent();
    }

    @Override
    protected ValueSupplier.Value<? extends S> calculateOwnValue() {
        ValueSupplier.Value<T> value = this.provider.calculateValue();
        if (value.isMissing()) {
            return value.asType();
        }
        return this.map(value.get()).calculateValue();
    }

    private ProviderInternal<? extends S> map(T value) {
        Provider result = (Provider)this.transformer.transform(value);
        if (result == null) {
            return Providers.notDefined();
        }
        return Providers.internal(result);
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        return Providers.internal(this.map(this.provider.get())).maybeVisitBuildDependencies(context);
    }

    @Override
    public String toString() {
        return "flatmap(" + this.provider + ")";
    }
}

