/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.plugins.internal.FeatureSpecInternal;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.util.TextUtil;

public class DefaultJavaFeatureSpec
implements FeatureSpecInternal {
    private final String name;
    private final JavaPluginConvention javaPluginConvention;
    private final ConfigurationContainer configurationContainer;
    private final ObjectFactory objectFactory;
    private final PluginManager pluginManager;
    private final SoftwareComponentContainer components;
    private final TaskContainer tasks;
    private final List<Capability> capabilities = Lists.newArrayListWithExpectedSize((int)2);
    private boolean overrideDefaultCapability = true;
    private SourceSet sourceSet;
    private boolean withJavadocJar = false;
    private boolean withSourcesJar = false;

    public DefaultJavaFeatureSpec(String name, Capability defaultCapability, JavaPluginConvention javaPluginConvention, ConfigurationContainer configurationContainer, ObjectFactory objectFactory, PluginManager pluginManager, SoftwareComponentContainer components, TaskContainer tasks) {
        this.name = name;
        this.javaPluginConvention = javaPluginConvention;
        this.configurationContainer = configurationContainer;
        this.objectFactory = objectFactory;
        this.pluginManager = pluginManager;
        this.components = components;
        this.tasks = tasks;
        this.capabilities.add(defaultCapability);
    }

    @Override
    public void usingSourceSet(SourceSet sourceSet) {
        this.sourceSet = sourceSet;
    }

    @Override
    public void capability(String group, String name, String version) {
        if (this.overrideDefaultCapability) {
            this.capabilities.clear();
            this.overrideDefaultCapability = false;
        }
        this.capabilities.add((Capability)new ImmutableCapability(group, name, version));
    }

    @Override
    public void create() {
        this.setupConfigurations(this.sourceSet);
    }

    @Override
    public void withJavadocJar() {
        this.withJavadocJar = true;
    }

    @Override
    public void withSourcesJar() {
        this.withSourcesJar = true;
    }

    private void setupConfigurations(SourceSet sourceSet) {
        String runtimeElementsConfigurationName;
        String apiElementsConfigurationName;
        String implConfigurationName;
        String apiConfigurationName;
        if (sourceSet == null) {
            throw new InvalidUserCodeException("You must specify which source set to use for feature '" + this.name + "'");
        }
        AdhocComponentWithVariants component = JvmPluginsHelper.findJavaComponent(this.components);
        boolean mainSourceSet = this.isMainSourceSet(sourceSet);
        if (mainSourceSet) {
            apiConfigurationName = this.name + "Api";
            implConfigurationName = this.name + "Implementation";
            apiElementsConfigurationName = apiConfigurationName + "Elements";
            runtimeElementsConfigurationName = this.name + "RuntimeElements";
        } else {
            apiConfigurationName = sourceSet.getApiConfigurationName();
            implConfigurationName = sourceSet.getImplementationConfigurationName();
            apiElementsConfigurationName = sourceSet.getApiElementsConfigurationName();
            runtimeElementsConfigurationName = sourceSet.getRuntimeElementsConfigurationName();
        }
        Configuration api = this.bucket("API", apiConfigurationName);
        Configuration impl = this.bucket("Implementation", implConfigurationName);
        impl.extendsFrom(new Configuration[]{api});
        Configuration apiElements = this.export(apiElementsConfigurationName);
        apiElements.extendsFrom(new Configuration[]{api});
        Configuration runtimeElements = this.export(runtimeElementsConfigurationName);
        runtimeElements.extendsFrom(new Configuration[]{impl});
        this.configureUsage(apiElements, "java-api");
        this.configureUsage(runtimeElements, "java-runtime");
        this.configurePacking(apiElements);
        this.configurePacking(runtimeElements);
        this.configureTargetPlatform(apiElements);
        this.configureTargetPlatform(runtimeElements);
        this.configureCategory(apiElements);
        this.configureCategory(runtimeElements);
        this.configureCapabilities(apiElements);
        this.configureCapabilities(runtimeElements);
        this.attachArtifactToConfiguration(apiElements);
        this.attachArtifactToConfiguration(runtimeElements);
        JvmPluginsHelper.configureJavaDocTask(this.name, sourceSet, this.tasks);
        if (this.withJavadocJar) {
            JvmPluginsHelper.configureDocumentationVariantWithArtifact(sourceSet.getJavadocElementsConfigurationName(), this.name, "javadoc", this.capabilities, sourceSet.getJavadocJarTaskName(), this.tasks.named(sourceSet.getJavadocTaskName()), component, this.configurationContainer, this.tasks, this.objectFactory);
        }
        if (this.withSourcesJar) {
            JvmPluginsHelper.configureDocumentationVariantWithArtifact(sourceSet.getSourcesElementsConfigurationName(), this.name, "sources", this.capabilities, sourceSet.getSourcesJarTaskName(), sourceSet.getAllSource(), component, this.configurationContainer, this.tasks, this.objectFactory);
        }
        JvmPluginsHelper.configureClassesDirectoryVariant(sourceSet, (Project)this.javaPluginConvention.getProject(), apiElementsConfigurationName, "java-api");
        if (mainSourceSet) {
            this.configurationContainer.getByName("compileClasspath").extendsFrom(new Configuration[]{impl});
            this.configurationContainer.getByName("runtimeClasspath").extendsFrom(new Configuration[]{impl});
            this.configurationContainer.getByName("testCompileClasspath").extendsFrom(new Configuration[]{impl});
            this.configurationContainer.getByName("testRuntimeClasspath").extendsFrom(new Configuration[]{impl});
        }
        if (component != null) {
            component.addVariantsFromConfiguration(apiElements, (Action)new JavaConfigurationVariantMapping("compile", true));
            component.addVariantsFromConfiguration(runtimeElements, (Action)new JavaConfigurationVariantMapping("runtime", true));
        }
    }

    private void configureTargetPlatform(Configuration configuration) {
        ((ConfigurationInternal)configuration).beforeLocking((Action)new Action<ConfigurationInternal>(){

            public void execute(ConfigurationInternal configuration) {
                String majorVersion = DefaultJavaFeatureSpec.this.javaPluginConvention.getTargetCompatibility().getMajorVersion();
                AttributeContainerInternal attributes = configuration.getAttributes();
                if (!attributes.contains(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE)) {
                    attributes.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, (Object)Integer.valueOf(majorVersion));
                }
            }
        });
    }

    private void configurePacking(Configuration configuration) {
        configuration.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.objectFactory.named(Bundling.class, "external")));
    }

    private void configureCategory(Configuration configuration) {
        configuration.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.objectFactory.named(Category.class, "library")));
    }

    private void attachArtifactToConfiguration(Configuration configuration) {
        String jarTaskName = this.sourceSet.getJarTaskName();
        if (!this.tasks.getNames().contains(jarTaskName)) {
            this.tasks.register(jarTaskName, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDescription("Assembles a jar archive containing the classes of the '" + DefaultJavaFeatureSpec.this.name + "' feature.");
                    jar.setGroup("build");
                    jar.from(new Object[]{DefaultJavaFeatureSpec.this.sourceSet.getOutput()});
                    jar.getArchiveClassifier().set((Object)TextUtil.camelToKebabCase((String)DefaultJavaFeatureSpec.this.name));
                }
            });
        }
        TaskProvider jar = this.tasks.named(jarTaskName);
        configuration.getArtifacts().add((Object)new LazyPublishArtifact((Provider)jar));
    }

    private void configureCapabilities(Configuration apiElements) {
        for (Capability capability : this.capabilities) {
            apiElements.getOutgoing().capability((Object)capability);
        }
    }

    private Configuration export(String configName) {
        Configuration configuration = (Configuration)this.configurationContainer.maybeCreate(configName);
        configuration.setCanBeConsumed(true);
        configuration.setCanBeResolved(false);
        return configuration;
    }

    private Configuration bucket(String kind, String configName) {
        Configuration configuration = (Configuration)this.configurationContainer.maybeCreate(configName);
        configuration.setDescription(kind + " dependencies for feature " + this.name);
        configuration.setCanBeResolved(false);
        configuration.setCanBeConsumed(false);
        return configuration;
    }

    private void configureUsage(Configuration conf, final String usage) {
        conf.attributes((Action)new Action<AttributeContainer>(){

            public void execute(AttributeContainer attrs) {
                attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)DefaultJavaFeatureSpec.this.objectFactory.named(Usage.class, usage)));
                attrs.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)DefaultJavaFeatureSpec.this.objectFactory.named(LibraryElements.class, "jar")));
            }
        });
    }

    private boolean isMainSourceSet(SourceSet sourceSet) {
        return sourceSet.getName().equals("main");
    }
}

