/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.caching.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.caching.BuildCacheKey;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.caching.CachingInputs;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.caching.CachingStateBuilder;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class DefaultCachingStateBuilder
implements CachingStateBuilder {
    private ImplementationSnapshot implementation;
    private ImmutableList<ImplementationSnapshot> additionalImplementations = ImmutableList.of();
    private final ImmutableSortedMap.Builder<String, HashCode> inputValueFingerprintsBuilder = ImmutableSortedMap.naturalOrder();
    private ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileFingerprints = ImmutableSortedMap.of();
    private final ImmutableSortedMap.Builder<String, String> nonCacheableInputPropertiesBuilder = ImmutableSortedMap.naturalOrder();
    private ImmutableSortedSet<String> outputProperties = ImmutableSortedSet.of();
    private final ImmutableList.Builder<CachingDisabledReason> noCachingReasonsBuilder = ImmutableList.builder();

    @Override
    public final void withImplementation(ImplementationSnapshot implementation) {
        this.implementation = implementation;
        this.processImplementation(implementation);
    }

    @OverridingMethodsMustInvokeSuper
    protected void processImplementation(ImplementationSnapshot implementation) {
        if (implementation.isUnknown()) {
            this.noCachingReasonsBuilder.add((Object)new CachingDisabledReason(CachingDisabledReasonCategory.NON_CACHEABLE_IMPLEMENTATION, "Implementation type " + implementation.getUnknownReason()));
        }
    }

    @Override
    public final void withAdditionalImplementations(Iterable<ImplementationSnapshot> additionalImplementations) {
        this.additionalImplementations = ImmutableList.copyOf(additionalImplementations);
        for (ImplementationSnapshot additionalImplementation : additionalImplementations) {
            this.processAdditionalImplementation(additionalImplementation);
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void processAdditionalImplementation(ImplementationSnapshot additionalImplementation) {
        if (additionalImplementation.isUnknown()) {
            this.noCachingReasonsBuilder.add((Object)new CachingDisabledReason(CachingDisabledReasonCategory.NON_CACHEABLE_ADDITIONAL_IMPLEMENTATION, "Additional implementation type " + additionalImplementation.getUnknownReason()));
        }
    }

    @Override
    public final void withInputValueFingerprints(Map<String, ValueSnapshot> fingerprints) {
        fingerprints.forEach((propertyName, fingerprint) -> {
            Hasher hasher = Hashing.newHasher();
            fingerprint.appendToHasher(hasher);
            if (hasher.isValid()) {
                HashCode hash = hasher.hash();
                this.recordInputValueFingerprint((String)propertyName, hash);
            } else {
                this.markInputValuePropertyNotCacheable((String)propertyName, hasher.getInvalidReason());
            }
        });
    }

    @OverridingMethodsMustInvokeSuper
    protected void recordInputValueFingerprint(String propertyName, HashCode fingerprint) {
        this.inputValueFingerprintsBuilder.put((Object)propertyName, (Object)fingerprint);
    }

    @OverridingMethodsMustInvokeSuper
    protected void markInputValuePropertyNotCacheable(String propertyName, String nonCacheableReason) {
        this.nonCacheableInputPropertiesBuilder.put((Object)propertyName, (Object)nonCacheableReason);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void withInputFilePropertyFingerprints(Map<String, CurrentFileCollectionFingerprint> fingerprints) {
        this.inputFileFingerprints = ImmutableSortedMap.copyOf(fingerprints);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void withOutputPropertyNames(Iterable<String> propertyNames) {
        this.outputProperties = ImmutableSortedSet.copyOf(propertyNames);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void markNotCacheable(CachingDisabledReason reason) {
        this.noCachingReasonsBuilder.add((Object)reason);
    }

    @Override
    public final CachingState build() {
        ImmutableSortedMap inputValueFingerprints = this.inputValueFingerprintsBuilder.build();
        Hasher hasher = Hashing.newHasher();
        this.implementation.appendToHasher(hasher);
        this.additionalImplementations.forEach(additionalImplementation -> additionalImplementation.appendToHasher(hasher));
        inputValueFingerprints.forEach((propertyName, fingerprint) -> {
            hasher.putString((CharSequence)propertyName);
            hasher.putHash(fingerprint);
        });
        this.inputFileFingerprints.forEach((propertyName, fingerprint) -> {
            hasher.putString((CharSequence)propertyName);
            hasher.putHash(fingerprint.getHash());
        });
        this.outputProperties.forEach(propertyName -> hasher.putString((CharSequence)propertyName));
        ImmutableSortedMap nonCacheableInputPropertiesMap = this.nonCacheableInputPropertiesBuilder.build();
        if (!nonCacheableInputPropertiesMap.isEmpty()) {
            StringBuilder builder = new StringBuilder("Non-cacheable inputs: ");
            boolean first = true;
            for (Map.Entry entry : nonCacheableInputPropertiesMap.entrySet()) {
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                builder.append("property '").append((String)entry.getKey()).append("' ").append((String)entry.getValue());
            }
            String message = builder.toString();
            this.noCachingReasonsBuilder.add((Object)new CachingDisabledReason(CachingDisabledReasonCategory.NON_CACHEABLE_INPUTS, message));
            hasher.markAsInvalid(message);
        }
        ImmutableSortedSet nonCacheableInputProperties = nonCacheableInputPropertiesMap.keySet();
        DefaultCachingInputs inputs = new DefaultCachingInputs(this.implementation, this.additionalImplementations, (ImmutableSortedMap<String, HashCode>)inputValueFingerprints, this.inputFileFingerprints, this.outputProperties, (ImmutableSortedSet<String>)nonCacheableInputProperties);
        ImmutableList cachingDisabledReasons = this.noCachingReasonsBuilder.build();
        if (cachingDisabledReasons.isEmpty()) {
            return new CachedState(hasher.hash(), inputs);
        }
        HashCode key = hasher.isValid() ? hasher.hash() : null;
        return new NonCachedState(key, (Iterable<CachingDisabledReason>)cachingDisabledReasons, inputs);
    }

    private static class DefaultCachingInputs
    implements CachingInputs {
        ImplementationSnapshot implementation;
        ImmutableList<ImplementationSnapshot> additionalImplementations;
        ImmutableSortedMap<String, HashCode> inputValueFingerprints;
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileFingerprints;
        ImmutableSortedSet<String> outputProperties;
        ImmutableSortedSet<String> nonCacheableInputProperties;

        public DefaultCachingInputs(ImplementationSnapshot implementation, ImmutableList<ImplementationSnapshot> additionalImplementations, ImmutableSortedMap<String, HashCode> inputValueFingerprints, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileFingerprints, ImmutableSortedSet<String> outputProperties, ImmutableSortedSet<String> nonCacheableInputProperties) {
            this.implementation = implementation;
            this.additionalImplementations = additionalImplementations;
            this.inputValueFingerprints = inputValueFingerprints;
            this.inputFileFingerprints = inputFileFingerprints;
            this.outputProperties = outputProperties;
            this.nonCacheableInputProperties = nonCacheableInputProperties;
        }

        @Override
        public ImplementationSnapshot getImplementation() {
            return this.implementation;
        }

        @Override
        public ImmutableList<ImplementationSnapshot> getAdditionalImplementations() {
            return this.additionalImplementations;
        }

        @Override
        public ImmutableSortedMap<String, HashCode> getInputValueFingerprints() {
            return this.inputValueFingerprints;
        }

        @Override
        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFileFingerprints() {
            return this.inputFileFingerprints;
        }

        @Override
        public ImmutableSortedSet<String> getOutputProperties() {
            return this.outputProperties;
        }

        @Override
        public ImmutableSortedSet<String> getNonCacheableInputProperties() {
            return this.nonCacheableInputProperties;
        }
    }

    private static class DefaultBuildCacheKey
    implements BuildCacheKey {
        private final HashCode hashCode;

        public DefaultBuildCacheKey(HashCode hashCode) {
            this.hashCode = hashCode;
        }

        public String getHashCode() {
            return this.hashCode.toString();
        }

        public byte[] toByteArray() {
            return this.hashCode.toByteArray();
        }

        public String getDisplayName() {
            return this.getHashCode();
        }

        public String toString() {
            return this.getHashCode();
        }
    }

    private static class NonCachedState
    implements CachingState {
        private final BuildCacheKey key;
        private final ImmutableList<CachingDisabledReason> disabledReasons;
        private final CachingInputs inputs;

        public NonCachedState(@Nullable HashCode key, Iterable<CachingDisabledReason> disabledReasons, CachingInputs inputs) {
            this.key = key == null ? null : new DefaultBuildCacheKey(key);
            this.disabledReasons = ImmutableList.copyOf(disabledReasons);
            this.inputs = inputs;
        }

        @Override
        public Optional<BuildCacheKey> getKey() {
            return Optional.ofNullable(this.key);
        }

        @Override
        public ImmutableList<CachingDisabledReason> getDisabledReasons() {
            return this.disabledReasons;
        }

        @Override
        public Optional<CachingInputs> getInputs() {
            return Optional.of(this.inputs);
        }
    }

    private static class CachedState
    implements CachingState {
        private final BuildCacheKey key;
        private final CachingInputs inputs;

        public CachedState(HashCode key, CachingInputs inputs) {
            this.key = new DefaultBuildCacheKey(key);
            this.inputs = inputs;
        }

        @Override
        public Optional<BuildCacheKey> getKey() {
            return Optional.of(this.key);
        }

        @Override
        public ImmutableList<CachingDisabledReason> getDisabledReasons() {
            return ImmutableList.of();
        }

        @Override
        public Optional<CachingInputs> getInputs() {
            return Optional.of(this.inputs);
        }
    }
}

