/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.VersionConstraintInternal;
import org.gradle.api.internal.artifacts.dependencies.AbstractVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;

public class DefaultMutableVersionConstraint
extends AbstractVersionConstraint
implements VersionConstraintInternal {
    private String requiredVersion;
    private String preferredVersion;
    private String strictVersion;
    private String branch;
    private final List<String> rejectedVersions = Lists.newArrayListWithExpectedSize((int)1);

    public DefaultMutableVersionConstraint(VersionConstraint versionConstraint) {
        this(versionConstraint.getPreferredVersion(), versionConstraint.getRequiredVersion(), versionConstraint.getStrictVersion(), versionConstraint.getRejectedVersions());
    }

    public DefaultMutableVersionConstraint(String version) {
        this(null, version, null);
    }

    private DefaultMutableVersionConstraint(String preferredVersion, String requiredVersion, String strictVersion) {
        this(preferredVersion, requiredVersion, strictVersion, Collections.emptyList());
    }

    private DefaultMutableVersionConstraint(String preferredVersion, String requiredVersion, String strictVersion, List<String> rejects) {
        this.updateVersions(preferredVersion, requiredVersion, strictVersion);
        for (String reject : rejects) {
            this.rejectedVersions.add(Strings.nullToEmpty((String)reject));
        }
    }

    private void updateVersions(String preferredVersion, String requiredVersion, String strictVersion) {
        this.preferredVersion = Strings.nullToEmpty((String)preferredVersion);
        this.requiredVersion = Strings.nullToEmpty((String)requiredVersion);
        this.strictVersion = Strings.nullToEmpty((String)strictVersion);
        this.rejectedVersions.clear();
    }

    public static DefaultMutableVersionConstraint withVersion(String version) {
        return new DefaultMutableVersionConstraint(version);
    }

    public static DefaultMutableVersionConstraint withStrictVersion(String version) {
        return new DefaultMutableVersionConstraint(null, version, version);
    }

    @Override
    public ImmutableVersionConstraint asImmutable() {
        return new DefaultImmutableVersionConstraint(this.preferredVersion, this.requiredVersion, this.strictVersion, this.rejectedVersions, this.branch);
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getRequiredVersion() {
        return this.requiredVersion;
    }

    public void require(String version) {
        this.updateVersions(this.preferredVersion, version, null);
    }

    public String getPreferredVersion() {
        return this.preferredVersion;
    }

    public void prefer(String version) {
        this.updateVersions(version, this.requiredVersion, this.strictVersion);
    }

    public String getStrictVersion() {
        return this.strictVersion;
    }

    public void strictly(String version) {
        this.updateVersions(this.preferredVersion, version, version);
    }

    public void reject(String ... versions) {
        this.rejectedVersions.clear();
        Collections.addAll(this.rejectedVersions, versions);
    }

    public void rejectAll() {
        this.updateVersions(null, null, null);
        this.rejectedVersions.add("+");
    }

    public List<String> getRejectedVersions() {
        return this.rejectedVersions;
    }

    public String getVersion() {
        return this.requiredVersion.isEmpty() ? this.preferredVersion : this.requiredVersion;
    }
}

