/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DependencyVerifyingModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.ArtifactVerificationOperation;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DefaultKeyServers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DependencyVerificationOverride;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.ChecksumEntry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.PgpEntry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.PgpKeyGrouper;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.VerificationEntry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.WriterSignatureVerificationResult;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.gradle.api.internal.artifacts.verification.model.IgnoredKey;
import org.gradle.api.internal.artifacts.verification.serializer.DependencyVerificationsXmlReader;
import org.gradle.api.internal.artifacts.verification.serializer.DependencyVerificationsXmlWriter;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationService;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationServiceFactory;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerificationConfiguration;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerifier;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerifierBuilder;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.security.internal.Fingerprint;
import org.gradle.security.internal.PublicKeyResultBuilder;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.security.internal.SecuritySupport;

public class WriteDependencyVerificationFile
implements DependencyVerificationOverride,
ArtifactVerificationOperation {
    private static final Logger LOGGER = Logging.getLogger(WriteDependencyVerificationFile.class);
    private static final Action<ArtifactView.ViewConfiguration> MODULE_COMPONENT_FILES = conf -> {
        conf.componentFilter(id -> id instanceof ModuleComponentIdentifier);
        conf.setLenient(true);
    };
    private static final String PGP = "pgp";
    private static final String MD5 = "md5";
    private static final String SHA1 = "sha1";
    private static final String SHA256 = "sha256";
    private static final String SHA512 = "sha512";
    private static final Set<String> SUPPORTED_CHECKSUMS = ImmutableSet.of((Object)"md5", (Object)"sha1", (Object)"sha256", (Object)"sha512", (Object)"pgp");
    private static final Set<String> SECURE_CHECKSUMS = ImmutableSet.of((Object)"sha256", (Object)"sha512", (Object)"pgp");
    private static final String PGP_VERIFICATION_FAILED = "PGP verification failed";
    private static final String KEY_NOT_DOWNLOADED = "Key couldn't be downloaded from any key server";
    private final DependencyVerifierBuilder verificationsBuilder = new DependencyVerifierBuilder();
    private final BuildOperationExecutor buildOperationExecutor;
    private final List<String> checksums;
    private final Set<VerificationEntry> entriesToBeWritten = Sets.newLinkedHashSetWithExpectedSize((int)512);
    private final ChecksumService checksumService;
    private final File verificationFile;
    private final File keyringsFile;
    private final SignatureVerificationServiceFactory signatureVerificationServiceFactory;
    private final boolean isDryRun;
    private final boolean generatePgpInfo;
    private final boolean isExportKeyring;
    private boolean hasMissingSignatures = false;
    private boolean hasMissingKeys = false;
    private boolean hasFailedVerification = false;

    public WriteDependencyVerificationFile(File gradleDir, BuildOperationExecutor buildOperationExecutor, List<String> checksums, ChecksumService checksumService, SignatureVerificationServiceFactory signatureVerificationServiceFactory, boolean isDryRun, boolean exportKeyRing) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.checksums = checksums;
        this.checksumService = checksumService;
        this.verificationFile = DependencyVerificationOverride.dependencyVerificationsFile(gradleDir);
        this.keyringsFile = DependencyVerificationOverride.keyringsFile(gradleDir);
        this.signatureVerificationServiceFactory = signatureVerificationServiceFactory;
        this.isDryRun = isDryRun;
        this.generatePgpInfo = checksums.contains(PGP);
        this.isExportKeyring = exportKeyRing;
    }

    private void validateChecksums() {
        this.assertSupportedChecksums();
        this.warnAboutInsecureChecksums();
    }

    private void assertSupportedChecksums() {
        for (String checksum : this.checksums) {
            if (SUPPORTED_CHECKSUMS.contains(checksum)) continue;
            LOGGER.warn("Invalid checksum type: '" + checksum + "'. You must choose one or more in " + SUPPORTED_CHECKSUMS);
        }
        if (this.checksums.isEmpty()) {
            throw new InvalidUserDataException("You must specify at least one checksum type to use. You must choose one or more in " + SUPPORTED_CHECKSUMS);
        }
        this.assertPgpHasChecksumFallback(this.checksums);
    }

    private void assertPgpHasChecksumFallback(List<String> kinds) {
        if (kinds.size() == 1 && PGP.equals(kinds.get(0))) {
            throw new InvalidUserDataException("Generating a file with signature verification requires at least one checksum type (sha256 or sha512) as fallback.");
        }
    }

    private void warnAboutInsecureChecksums() {
        if (this.checksums.stream().noneMatch(SECURE_CHECKSUMS::contains)) {
            LOGGER.warn("You chose to generate " + this.checksums.stream().collect(Collectors.joining(" and ")) + " checksums but they are all considered insecure. You should consider adding at least one of " + SECURE_CHECKSUMS.stream().collect(Collectors.joining(" or ")) + ".");
        }
    }

    @Override
    public ModuleComponentRepository overrideDependencyVerification(ModuleComponentRepository original, String resolveContextName, ResolutionStrategyInternal resolutionStrategy) {
        return new DependencyVerifyingModuleComponentRepository(original, this, this.generatePgpInfo);
    }

    @Override
    public void buildFinished(Gradle gradle) {
        this.ensureOutputDirCreated();
        this.maybeReadExistingFile();
        SignatureVerificationService signatureVerificationService = this.signatureVerificationServiceFactory.create(this.keyringsFile, DefaultKeyServers.getOrDefaults(this.verificationsBuilder.getKeyServers()));
        try {
            this.validateChecksums();
            this.resolveAllConfigurationsConcurrently(gradle);
            this.computeChecksumsConcurrently(signatureVerificationService);
            this.writeEntriesSerially();
            this.serializeResult(signatureVerificationService);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            signatureVerificationService.stop();
        }
    }

    public boolean ensureOutputDirCreated() {
        return this.verificationFile.getParentFile().mkdirs();
    }

    private void serializeResult(SignatureVerificationService signatureVerificationService) throws IOException {
        File out = this.verificationFile;
        if (this.isDryRun) {
            out = new File(this.verificationFile.getParent(), Files.getNameWithoutExtension((String)this.verificationFile.getName()) + ".dryrun.xml");
        }
        if (this.generatePgpInfo) {
            this.verificationsBuilder.setVerifySignatures(true);
        }
        DependencyVerifier verifier = this.verificationsBuilder.build();
        DependencyVerificationsXmlWriter.serialize(verifier, new FileOutputStream(out));
        if (this.isExportKeyring) {
            this.exportKeys(signatureVerificationService, verifier);
        }
    }

    private void exportKeys(SignatureVerificationService signatureVerificationService, DependencyVerifier verifier) throws IOException {
        String keyringFileName = this.isDryRun ? "verification-keyring-dryrun.gpg" : "verification-keyring.gpg";
        File keyringExportFile = new File(this.verificationFile.getParent(), keyringFileName);
        HashSet keysToExport = Sets.newHashSet();
        verifier.getConfiguration().getTrustedKeys().stream().map(DependencyVerificationConfiguration.TrustedKey::getKeyId).forEach(keysToExport::add);
        verifier.getConfiguration().getIgnoredKeys().stream().map(IgnoredKey::getKeyId).forEach(keysToExport::add);
        verifier.getVerificationMetadata().stream().flatMap(md -> md.getArtifactVerifications().stream()).flatMap(avm -> Stream.concat(avm.getTrustedPgpKeys().stream(), avm.getIgnoredPgpKeys().stream().map(IgnoredKey::getKeyId))).forEach(keysToExport::add);
        this.exportKeyRingCollection(signatureVerificationService.getPublicKeyService(), keyringExportFile, keysToExport);
    }

    private void maybeReadExistingFile() {
        if (this.verificationFile.exists()) {
            LOGGER.info("Found dependency verification metadata file, updating");
            try {
                DependencyVerificationsXmlReader.readFromXml(new FileInputStream(this.verificationFile), this.verificationsBuilder);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
    }

    private void writeEntriesSerially() {
        AtomicReference previousEntry = new AtomicReference();
        this.entriesToBeWritten.stream().sorted().filter(this::shouldWriteEntry).forEachOrdered(e -> this.registerEntryToBuilder((VerificationEntry)e, previousEntry));
        this.printWarnings();
    }

    private void printWarnings() {
        if (this.hasMissingKeys || this.hasFailedVerification) {
            StringBuilder sb = new StringBuilder("A verification file was generated but some problems were discovered:\n");
            if (this.hasMissingSignatures) {
                sb.append("   - some artifacts aren't signed or the signature couldn't be retrieved.");
                sb.append("\n");
            }
            if (this.hasMissingKeys) {
                sb.append("   - some keys couldn't be downloaded. They were automatically added as ignored keys but you should review if this is acceptable. Look for entries with the following comment: ");
                sb.append(KEY_NOT_DOWNLOADED);
                sb.append("\n");
            }
            if (this.hasFailedVerification) {
                sb.append("   - some signature verification failed. Checksums were generated for those artifacts but you MUST check if there's an actual problem. Look for entries with the following comment: ");
                sb.append(PGP_VERIFICATION_FAILED);
                sb.append("\n");
            }
            LOGGER.warn(sb.toString());
        }
    }

    private void registerEntryToBuilder(VerificationEntry entry, AtomicReference<PgpEntry> previousEntry) {
        PgpEntry pgpEntry = previousEntry.get();
        if (pgpEntry != null && !pgpEntry.id.equals(entry.id)) {
            pgpEntry = null;
            previousEntry.set(null);
        }
        if (entry instanceof ChecksumEntry) {
            ChecksumEntry checksum = (ChecksumEntry)entry;
            if (pgpEntry == null || entry.id.equals(pgpEntry.id) && pgpEntry.isRequiringChecksums()) {
                String label = "Generated by Gradle";
                if (pgpEntry != null) {
                    if (pgpEntry.isFailed()) {
                        this.hasFailedVerification = true;
                        label = label + " because PGP signature verification failed!";
                    } else if (pgpEntry.hasSignatureFile()) {
                        this.hasMissingKeys = true;
                        label = label + " because a key couldn't be downloaded";
                    } else {
                        this.hasMissingSignatures = true;
                        label = label + " because artifact wasn't signed";
                    }
                }
                this.verificationsBuilder.addChecksum(entry.id, checksum.getChecksumKind(), checksum.getChecksum(), label);
            }
        } else {
            PgpEntry pgp = (PgpEntry)entry;
            previousEntry.set(pgp);
            TreeSet failedKeys = Sets.newTreeSet(pgp.getFailed());
            for (String failedKey : failedKeys) {
                this.verificationsBuilder.addIgnoredKey(pgp.id, new IgnoredKey(failedKey, PGP_VERIFICATION_FAILED));
            }
            if (pgp.hasArtifactLevelKeys()) {
                for (String key : pgp.getArtifactLevelKeys()) {
                    if (failedKeys.contains(key)) continue;
                    this.verificationsBuilder.addTrustedKey(pgp.id, key);
                }
            }
        }
    }

    private boolean shouldWriteEntry(VerificationEntry entry) {
        if (entry instanceof ChecksumEntry) {
            return ((ChecksumEntry)entry).getChecksum() != null && !this.isTrustedArtifact(entry.id);
        }
        return !this.isTrustedArtifact(entry.id);
    }

    private void resolveAllConfigurationsConcurrently(Gradle gradle) {
        this.buildOperationExecutor.runAll(queue -> {
            Set allprojects = gradle.getRootProject().getAllprojects();
            for (final Project project : allprojects) {
                queue.add((BuildOperation)new RunnableBuildOperation(){

                    public void run(BuildOperationContext context) {
                        WriteDependencyVerificationFile.resolveAllConfigurationsAndForceDownload(project);
                    }

                    public BuildOperationDescriptor.Builder description() {
                        String displayName = "Resolving configurations of " + project.getDisplayName();
                        return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName);
                    }
                });
            }
        });
    }

    private void computeChecksumsConcurrently(SignatureVerificationService signatureVerificationService) {
        Set collectedIgnoredKeys = this.generatePgpInfo ? Sets.newConcurrentHashSet() : null;
        this.buildOperationExecutor.runAll(queue -> {
            for (VerificationEntry entry : this.entriesToBeWritten) {
                if (this.shouldSkipVerification(entry.getArtifactKind())) continue;
                if (!entry.getFile().exists()) {
                    LOGGER.warn("Cannot compute checksum for " + entry.getFile() + " because it doesn't exist. It may indicate a corrupt or tampered cache.");
                    continue;
                }
                if (entry instanceof ChecksumEntry) {
                    this.queueChecksumVerification((BuildOperationQueue<RunnableBuildOperation>)queue, (ChecksumEntry)entry);
                    continue;
                }
                this.queueSignatureVerification((BuildOperationQueue<RunnableBuildOperation>)queue, signatureVerificationService, (PgpEntry)entry, collectedIgnoredKeys);
            }
        });
        if (this.generatePgpInfo) {
            this.postProcessPgpResults(collectedIgnoredKeys);
        }
    }

    private void postProcessPgpResults(Set<String> collectedIgnoredKeys) {
        for (String ignoredKey : collectedIgnoredKeys) {
            this.verificationsBuilder.addIgnoredKey(new IgnoredKey(ignoredKey, KEY_NOT_DOWNLOADED));
        }
        PgpKeyGrouper grouper = new PgpKeyGrouper(this.verificationsBuilder, this.entriesToBeWritten);
        grouper.performPgpKeyGrouping();
    }

    private void queueSignatureVerification(BuildOperationQueue<RunnableBuildOperation> queue, final SignatureVerificationService signatureVerificationService, final PgpEntry entry, final Set<String> ignoredKeys) {
        queue.add((BuildOperation)new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                File signature = (File)entry.getSignatureFile().create();
                if (signature != null) {
                    WriterSignatureVerificationResult builder = new WriterSignatureVerificationResult(ignoredKeys, entry);
                    signatureVerificationService.verify(entry.file, signature, Collections.emptySet(), Collections.emptySet(), builder);
                }
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Verifying dependency signature").progressDisplayName("Verifying signature of " + entry.id);
            }
        });
    }

    private void queueChecksumVerification(BuildOperationQueue<RunnableBuildOperation> queue, final ChecksumEntry entry) {
        queue.add((BuildOperation)new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                entry.setChecksum(WriteDependencyVerificationFile.this.createHash(entry.getFile(), entry.getChecksumKind()));
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Computing checksums").progressDisplayName("Computing checksum of " + entry.id);
            }
        });
    }

    @Override
    public void onArtifact(ArtifactVerificationOperation.ArtifactKind kind, ModuleComponentArtifactIdentifier id, File mainFile, Factory<File> signatureFile, String repositoryName, String repositoryId) {
        for (String checksum : this.checksums) {
            if (PGP.equals(checksum)) {
                this.addPgp(id, kind, mainFile, signatureFile);
                continue;
            }
            this.addChecksum(id, kind, mainFile, ChecksumKind.valueOf(checksum));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPgp(ModuleComponentArtifactIdentifier id, ArtifactVerificationOperation.ArtifactKind kind, File mainFile, Factory<File> signatureFile) {
        PgpEntry entry = new PgpEntry(id, kind, mainFile, signatureFile);
        Set<VerificationEntry> set = this.entriesToBeWritten;
        synchronized (set) {
            this.entriesToBeWritten.add(entry);
        }
    }

    private boolean shouldSkipVerification(ArtifactVerificationOperation.ArtifactKind kind) {
        return kind == ArtifactVerificationOperation.ArtifactKind.METADATA && !this.verificationsBuilder.isVerifyMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChecksum(ModuleComponentArtifactIdentifier id, ArtifactVerificationOperation.ArtifactKind artifactKind, File file, ChecksumKind kind) {
        ChecksumEntry e = new ChecksumEntry(id, artifactKind, file, kind);
        Set<VerificationEntry> set = this.entriesToBeWritten;
        synchronized (set) {
            this.entriesToBeWritten.add(e);
        }
    }

    private boolean isTrustedArtifact(ModuleComponentArtifactIdentifier id) {
        return this.verificationsBuilder.getTrustedArtifacts().stream().anyMatch(artifact -> artifact.matches(id));
    }

    private String createHash(File file, ChecksumKind kind) {
        try {
            return this.checksumService.hash(file, kind.getAlgorithm()).toString();
        }
        catch (Exception e) {
            LOGGER.debug("Error while snapshotting " + file, (Throwable)e);
            return null;
        }
    }

    private static void resolveAllConfigurationsAndForceDownload(Project p) {
        ((ProjectInternal)p).getMutationState().withMutableState(() -> p.getConfigurations().all(cnf -> {
            if (((DeprecatableConfiguration)cnf).canSafelyBeResolved()) {
                try {
                    WriteDependencyVerificationFile.resolveAndDownloadExternalFiles(cnf);
                }
                catch (Exception e) {
                    LOGGER.debug("Cannot resolve configuration {}: {}", (Object)cnf.getName(), (Object)e.getMessage());
                }
            }
        }));
    }

    private static void resolveAndDownloadExternalFiles(Configuration cnf) {
        cnf.getIncoming().artifactView(MODULE_COMPONENT_FILES).getFiles().getFiles();
    }

    private void exportKeyRingCollection(PublicKeyService publicKeyService, File keyringFile, Set<String> publicKeys) throws IOException {
        List<PGPPublicKeyRing> existingRings = this.loadExistingKeyRing(keyringFile);
        PGPPublicKeyRingListBuilder builder = new PGPPublicKeyRingListBuilder();
        for (String publicKey : publicKeys) {
            if (publicKey.length() <= 16) {
                publicKeyService.findByLongId(new BigInteger(publicKey, 16).longValue(), (PublicKeyResultBuilder)builder);
                continue;
            }
            publicKeyService.findByFingerprint(Fingerprint.fromString((String)publicKey).getBytes(), (PublicKeyResultBuilder)builder);
        }
        List keysSeenInVerifier = builder.build().stream().filter(WriteDependencyVerificationFile::hasAtLeastOnePublicKey).filter(e -> existingRings.stream().noneMatch(ring -> WriteDependencyVerificationFile.keyIds(ring).equals(WriteDependencyVerificationFile.keyIds(e)))).collect(Collectors.toList());
        ImmutableList allKeyRings = ImmutableList.builder().addAll(existingRings).addAll(keysSeenInVerifier).build();
        try (FileOutputStream out = new FileOutputStream(keyringFile);){
            for (PGPPublicKeyRing keyRing : allKeyRings) {
                keyRing.encode((OutputStream)out, true);
            }
        }
        LOGGER.lifecycle("Exported {} keys to {}", new Object[]{allKeyRings.size(), keyringFile});
    }

    private static boolean hasAtLeastOnePublicKey(PGPPublicKeyRing ring) {
        return ring.getPublicKeys().hasNext();
    }

    private List<PGPPublicKeyRing> loadExistingKeyRing(File keyringFile) throws IOException {
        List existingRings;
        if (!this.isDryRun && keyringFile.exists()) {
            existingRings = SecuritySupport.loadKeyRingFile((File)keyringFile);
            LOGGER.info("Existing keyring file contains {} keyrings", (Object)existingRings.size());
        } else {
            existingRings = Collections.emptyList();
        }
        return existingRings;
    }

    private static Set<Long> keyIds(PGPPublicKeyRing ring) {
        return ImmutableList.copyOf((Iterator)ring.getPublicKeys()).stream().map(PGPPublicKey::getKeyID).collect(Collectors.toSet());
    }

    private static class PGPPublicKeyRingListBuilder
    implements PublicKeyResultBuilder {
        private final ImmutableList.Builder<PGPPublicKeyRing> builder = ImmutableList.builder();

        private PGPPublicKeyRingListBuilder() {
        }

        public void keyRing(PGPPublicKeyRing keyring) {
            this.builder.add((Object)keyring);
        }

        public void publicKey(PGPPublicKey publicKey) {
        }

        public List<PGPPublicKeyRing> build() {
            return this.builder.build();
        }
    }
}

