/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.AttributeSelectionSchema;
import org.gradle.internal.component.model.MultipleCandidateMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentAttributeMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentAttributeMatcher.class);
    private final Map<CachedQuery, int[]> cachedQueries = Maps.newConcurrentMap();

    public boolean isMatching(AttributeSelectionSchema schema, AttributeContainerInternal candidate, AttributeContainerInternal requested) {
        if (requested.isEmpty() || candidate.isEmpty()) {
            return true;
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        ImmutableAttributes candidateAttributes = candidate.asImmutable();
        for (Attribute attribute : requestedAttributes.keySet()) {
            AttributeValue requestedValue = requestedAttributes.findEntry(attribute);
            AttributeValue candidateValue = candidateAttributes.findEntry(attribute.getName());
            if (!candidateValue.isPresent()) continue;
            Object coercedValue = candidateValue.coerce(attribute);
            boolean match = schema.matchValue(attribute, requestedValue.get(), coercedValue);
            if (match) continue;
            return false;
        }
        return true;
    }

    public List<AttributeMatcher.MatchingDescription> describeMatching(AttributeSelectionSchema schema, AttributeContainerInternal candidate, AttributeContainerInternal requested) {
        if (requested.isEmpty() || candidate.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        ImmutableAttributes candidateAttributes = candidate.asImmutable();
        ImmutableSet attributes = requestedAttributes.keySet();
        ArrayList result = Lists.newArrayListWithCapacity((int)attributes.size());
        for (Attribute attribute : attributes) {
            AttributeValue requestedValue = requestedAttributes.findEntry(attribute);
            AttributeValue candidateValue = candidateAttributes.findEntry(attribute.getName());
            if (candidateValue.isPresent()) {
                Object coercedValue = candidateValue.coerce(attribute);
                boolean match = schema.matchValue(attribute, requestedValue.get(), coercedValue);
                result.add(new AttributeMatcher.MatchingDescription(attribute, requestedValue, candidateValue, match));
                continue;
            }
            result.add(new AttributeMatcher.MatchingDescription(attribute, requestedValue, candidateValue, false));
        }
        return result;
    }

    public <T extends HasAttributes> List<T> match(AttributeSelectionSchema schema, Collection<? extends T> candidates, AttributeContainerInternal requested, @Nullable T fallback, AttributeMatchingExplanationBuilder explanationBuilder) {
        int[] index;
        if (candidates.size() == 0) {
            if (fallback != null && this.isMatching(schema, (AttributeContainerInternal)fallback.getAttributes(), requested)) {
                explanationBuilder.selectedFallbackConfiguration(requested, fallback);
                return ImmutableList.of(fallback);
            }
            explanationBuilder.noCandidates(requested, fallback);
            return ImmutableList.of();
        }
        if (candidates.size() == 1) {
            HasAttributes candidate = (HasAttributes)candidates.iterator().next();
            if (this.isMatching(schema, (AttributeContainerInternal)candidate.getAttributes(), requested)) {
                explanationBuilder.singleMatch(candidate, candidates, requested);
                return Collections.singletonList(candidate);
            }
            explanationBuilder.candidateDoesNotMatchAttributes(candidate, requested);
            return ImmutableList.of();
        }
        ImmutableAttributes requestedAttributes = requested.asImmutable();
        CachedQuery query = null;
        if (explanationBuilder.canSkipExplanation() && (index = this.cachedQueries.get(query = CachedQuery.of(schema, requestedAttributes, candidates))) != null) {
            return CachedQuery.select(index, candidates);
        }
        List<? extends T> matches = new MultipleCandidateMatcher<T>(schema, candidates, requestedAttributes, explanationBuilder).getMatches();
        if (query != null) {
            LOGGER.debug("Selected matches {} from candidates {} for {}", new Object[]{matches, candidates, requested});
            this.cacheMatchingResult(candidates, query, matches);
        }
        return matches;
    }

    private synchronized <T extends HasAttributes> void cacheMatchingResult(Collection<? extends T> candidates, CachedQuery query, List<T> matches) {
        int[] queryResult;
        if (matches.isEmpty()) {
            queryResult = new int[]{};
        } else {
            queryResult = new int[matches.size()];
            int i = 0;
            int j = 0;
            Iterator<T> resultIterator = matches.iterator();
            HasAttributes next = (HasAttributes)resultIterator.next();
            for (HasAttributes candidate : candidates) {
                if (candidate == next) {
                    queryResult[i++] = j;
                    if (!resultIterator.hasNext()) break;
                    next = (HasAttributes)resultIterator.next();
                }
                ++j;
            }
        }
        this.cachedQueries.put(query, queryResult);
    }

    private static class CachedQuery {
        private final AttributeSelectionSchema schema;
        private final ImmutableAttributes requestedAttributes;
        private final ImmutableAttributes[] candidates;
        private final int hashCode;

        private CachedQuery(AttributeSelectionSchema schema, ImmutableAttributes requestedAttributes, ImmutableAttributes[] candidates) {
            this.schema = schema;
            this.requestedAttributes = requestedAttributes;
            this.candidates = candidates;
            this.hashCode = this.computeHashCode(schema, requestedAttributes, candidates);
        }

        private int computeHashCode(AttributeSelectionSchema schema, ImmutableAttributes requestedAttributes, ImmutableAttributes[] candidates) {
            int hash = schema.hashCode();
            hash = 31 * hash + requestedAttributes.hashCode();
            for (ImmutableAttributes candidate : candidates) {
                hash = 31 * hash + candidate.hashCode();
            }
            return hash;
        }

        public static <T extends HasAttributes> CachedQuery of(AttributeSelectionSchema schema, ImmutableAttributes requestedAttributes, Collection<T> candidates) {
            ImmutableAttributes[] attributes = new ImmutableAttributes[candidates.size()];
            int i = 0;
            for (HasAttributes candidate : candidates) {
                attributes[i++] = ((AttributeContainerInternal)candidate.getAttributes()).asImmutable();
            }
            return new CachedQuery(schema, requestedAttributes, attributes);
        }

        public static <T extends HasAttributes> List<T> select(int[] index, Collection<? extends T> unfiltered) {
            if (index.length == 0) {
                return Collections.emptyList();
            }
            ArrayList result = Lists.newArrayListWithCapacity((int)index.length);
            int i = 0;
            int j = 0;
            int k = index[j];
            for (HasAttributes t : unfiltered) {
                if (i == k) {
                    result.add(t);
                    if (result.size() == index.length) break;
                    k = index[++j];
                }
                ++i;
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedQuery that = (CachedQuery)o;
            return this.hashCode == that.hashCode && this.schema.equals(that.schema) && this.requestedAttributes.equals(that.requestedAttributes) && Arrays.equals(this.candidates, that.candidates);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "CachedQuery{requestedAttributes=" + this.requestedAttributes + ", candidates=" + Arrays.toString(this.candidates) + '}';
        }
    }
}

