/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.request;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.properties.annotations.OutputPropertyRoleAnnotationHandler;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.cache.internal.DefaultCrossBuildInMemoryCacheFactory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.dispatch.StreamCompletion;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.instantiation.PropertyRoleAnnotationHandler;
import org.gradle.internal.instantiation.generator.DefaultInstantiatorFactory;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.remote.internal.hub.StreamFailureHandler;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.internal.worker.RequestHandler;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.child.WorkerLogEventListener;
import org.gradle.process.internal.worker.child.WorkerLoggingProtocol;
import org.gradle.process.internal.worker.request.Request;
import org.gradle.process.internal.worker.request.RequestArgumentSerializers;
import org.gradle.process.internal.worker.request.RequestProtocol;
import org.gradle.process.internal.worker.request.RequestSerializerRegistry;
import org.gradle.process.internal.worker.request.ResponseProtocol;

public class WorkerAction
implements Action<WorkerProcessContext>,
Serializable,
RequestProtocol,
StreamFailureHandler,
Stoppable,
StreamCompletion {
    private final String workerImplementationName;
    private transient CountDownLatch completed;
    private transient ResponseProtocol responder;
    private transient WorkerLogEventListener workerLogEventListener;
    private transient RequestHandler<Object, Object> implementation;
    private transient InstantiatorFactory instantiatorFactory;
    private transient Exception failure;

    public WorkerAction(Class<?> workerImplementation) {
        this.workerImplementationName = workerImplementation.getName();
    }

    public void execute(WorkerProcessContext workerProcessContext) {
        this.completed = new CountDownLatch(1);
        RequestArgumentSerializers argumentSerializers = new RequestArgumentSerializers();
        try {
            ServiceRegistry parentServices = workerProcessContext.getServiceRegistry();
            if (this.instantiatorFactory == null) {
                this.instantiatorFactory = new DefaultInstantiatorFactory((CrossBuildInMemoryCacheFactory)new DefaultCrossBuildInMemoryCacheFactory((ListenerManager)new DefaultListenerManager()), Collections.emptyList(), (PropertyRoleAnnotationHandler)new OutputPropertyRoleAnnotationHandler(Collections.emptyList()));
            }
            DefaultServiceRegistry serviceRegistry = new DefaultServiceRegistry("worker-action-services", new ServiceRegistry[]{parentServices});
            serviceRegistry.add(RequestArgumentSerializers.class, (Object)argumentSerializers);
            serviceRegistry.add(InstantiatorFactory.class, (Object)this.instantiatorFactory);
            Class<?> workerImplementation = Class.forName(this.workerImplementationName);
            this.implementation = (RequestHandler)this.instantiatorFactory.inject((ServiceLookup)serviceRegistry).newInstance(workerImplementation, new Object[0]);
        }
        catch (Exception e) {
            this.failure = e;
        }
        ObjectConnection connection = workerProcessContext.getServerConnection();
        connection.addIncoming(RequestProtocol.class, (Object)this);
        this.responder = (ResponseProtocol)connection.addOutgoing(ResponseProtocol.class);
        this.workerLogEventListener = (WorkerLogEventListener)workerProcessContext.getServiceRegistry().get(WorkerLogEventListener.class);
        if (this.failure == null) {
            connection.useParameterSerializers(RequestSerializerRegistry.create(this.getClass().getClassLoader(), argumentSerializers));
        } else {
            connection.useParameterSerializers(RequestSerializerRegistry.createDiscardRequestArg());
            this.responder.infrastructureFailed(this.failure);
        }
        connection.connect();
        try {
            this.completed.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.completed.countDown();
        CurrentBuildOperationRef.instance().clear();
    }

    public void endStream() {
        this.stop();
    }

    @Override
    public void runThenStop(Request request) {
        try {
            this.run(request);
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(final Request request) {
        if (this.failure != null) {
            return;
        }
        try {
            Object result;
            CurrentBuildOperationRef.instance().set(request.getBuildOperation());
            try {
                result = this.workerLogEventListener.withWorkerLoggingProtocol((WorkerLoggingProtocol)this.responder, (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return WorkerAction.this.implementation.run(request.getArg());
                    }
                });
            }
            catch (Throwable failure) {
                if (failure instanceof NoClassDefFoundError) {
                    this.responder.infrastructureFailed(failure);
                } else {
                    this.responder.failed(failure);
                }
                CurrentBuildOperationRef.instance().clear();
                return;
            }
            this.responder.completed(result);
        }
        catch (Throwable t) {
            this.responder.infrastructureFailed(t);
        }
        finally {
            CurrentBuildOperationRef.instance().clear();
        }
    }

    public void handleStreamFailure(Throwable t) {
        this.responder.failed(t);
    }
}

