/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import com.google.common.collect.Interner;
import com.google.common.util.concurrent.Striped;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.Stat;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.AtomicSnapshotHierarchyReference;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileMetadata;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.internal.snapshot.impl.DirectorySnapshotter;
import org.gradle.internal.snapshot.impl.FileSystemSnapshotFilter;
import org.gradle.internal.vfs.impl.AbstractVirtualFileSystem;
import org.gradle.internal.vfs.impl.DefaultSnapshotHierarchy;

public class DefaultVirtualFileSystem
extends AbstractVirtualFileSystem {
    private final AtomicSnapshotHierarchyReference root;
    private final Stat stat;
    private final SnapshotHierarchy.DiffCapturingUpdateFunctionDecorator updateFunctionDecorator;
    private final DirectorySnapshotter directorySnapshotter;
    private final FileHasher hasher;
    private final StripedProducerGuard<String> producingSnapshots = new StripedProducerGuard();

    public DefaultVirtualFileSystem(FileHasher hasher, Interner<String> stringInterner, Stat stat, CaseSensitivity caseSensitivity, SnapshotHierarchy.DiffCapturingUpdateFunctionDecorator updateFunctionDecorator, String ... defaultExcludes) {
        this.stat = stat;
        this.updateFunctionDecorator = updateFunctionDecorator;
        this.directorySnapshotter = new DirectorySnapshotter(hasher, stringInterner, defaultExcludes);
        this.hasher = hasher;
        this.root = new AtomicSnapshotHierarchyReference(DefaultSnapshotHierarchy.empty(caseSensitivity));
    }

    @Override
    public <T> T read(String location, Function<CompleteFileSystemLocationSnapshot, T> visitor) {
        return visitor.apply(this.readLocation(location));
    }

    @Override
    public <T> Optional<T> readRegularFileContentHash(String location, Function<HashCode, T> visitor) {
        return this.root.get().getMetadata(location).flatMap(snapshot -> {
            if (snapshot.getType() != FileType.RegularFile) {
                return Optional.of(Optional.empty());
            }
            if (snapshot instanceof CompleteFileSystemLocationSnapshot) {
                return Optional.of(Optional.of(((CompleteFileSystemLocationSnapshot)snapshot).getHash()));
            }
            return Optional.empty();
        }).orElseGet(() -> {
            File file = new File(location);
            FileMetadataSnapshot stat = this.stat.stat(file);
            if (stat.getType() == FileType.Missing) {
                this.storeStatForMissingFile(location);
            }
            if (stat.getType() != FileType.RegularFile) {
                return Optional.empty();
            }
            HashCode hash = this.producingSnapshots.guardByKey(location, () -> this.root.get().getSnapshot(location).orElseGet(() -> {
                HashCode hashCode = this.hasher.hash(file, stat.getLength(), stat.getLastModified());
                RegularFileSnapshot snapshot = new RegularFileSnapshot(location, file.getName(), hashCode, FileMetadata.from(stat));
                this.updateRoot((root, changeListener) -> root.store(snapshot.getAbsolutePath(), snapshot, changeListener));
                return snapshot;
            }).getHash());
            return Optional.of(hash);
        }).map(visitor);
    }

    private void storeStatForMissingFile(String location) {
        this.updateRoot((root, changeListener) -> root.store(location, new MissingFileSnapshot(location), changeListener));
    }

    @Override
    public void read(String location, SnapshottingFilter filter, Consumer<CompleteFileSystemLocationSnapshot> visitor) {
        if (filter.isEmpty()) {
            visitor.accept(this.readLocation(location));
        } else {
            FileSystemSnapshot filteredSnapshot = this.root.get().getSnapshot(location).filter(CompleteFileSystemLocationSnapshot.class::isInstance).map(snapshot -> FileSystemSnapshotFilter.filterSnapshot(filter.getAsSnapshotPredicate(), snapshot)).orElseGet(() -> this.producingSnapshots.guardByKey(location, () -> this.root.get().getSnapshot(location).map(snapshot -> FileSystemSnapshotFilter.filterSnapshot(filter.getAsSnapshotPredicate(), snapshot)).orElseGet(() -> {
                AtomicBoolean hasBeenFiltered = new AtomicBoolean(false);
                CompleteFileSystemLocationSnapshot snapshot = this.directorySnapshotter.snapshot(location, filter.getAsDirectoryWalkerPredicate(), hasBeenFiltered);
                if (!hasBeenFiltered.get()) {
                    this.updateRoot((root, changeListener) -> root.store(snapshot.getAbsolutePath(), snapshot, changeListener));
                }
                return snapshot;
            })));
            if (filteredSnapshot instanceof CompleteFileSystemLocationSnapshot) {
                visitor.accept((CompleteFileSystemLocationSnapshot)filteredSnapshot);
            }
        }
    }

    private CompleteFileSystemLocationSnapshot snapshot(String location) {
        File file = new File(location);
        FileMetadataSnapshot stat = this.stat.stat(file);
        switch (stat.getType()) {
            case RegularFile: {
                HashCode hash = this.hasher.hash(file, stat.getLength(), stat.getLastModified());
                RegularFileSnapshot regularFileSnapshot = new RegularFileSnapshot(location, file.getName(), hash, FileMetadata.from(stat));
                this.updateRoot((root, changeListener) -> root.store(regularFileSnapshot.getAbsolutePath(), regularFileSnapshot, changeListener));
                return regularFileSnapshot;
            }
            case Missing: {
                MissingFileSnapshot missingFileSnapshot = new MissingFileSnapshot(location);
                this.updateRoot((root, changeListener) -> root.store(missingFileSnapshot.getAbsolutePath(), missingFileSnapshot, changeListener));
                return missingFileSnapshot;
            }
            case Directory: {
                CompleteFileSystemLocationSnapshot directorySnapshot = this.directorySnapshotter.snapshot(location, null, new AtomicBoolean(false));
                this.updateRoot((root, changeListener) -> root.store(directorySnapshot.getAbsolutePath(), directorySnapshot, changeListener));
                return directorySnapshot;
            }
        }
        throw new UnsupportedOperationException();
    }

    private void updateRoot(SnapshotHierarchy.DiffCapturingUpdateFunction updateFunction) {
        this.root.update(this.updateFunctionDecorator.decorate(updateFunction));
    }

    @Override
    AtomicSnapshotHierarchyReference getRoot() {
        return this.root;
    }

    private CompleteFileSystemLocationSnapshot readLocation(String location) {
        return this.root.get().getSnapshot(location).orElseGet(() -> this.producingSnapshots.guardByKey(location, () -> this.root.get().getSnapshot(location).orElseGet(() -> this.snapshot(location))));
    }

    @Override
    public void update(Iterable<String> locations, Runnable action) {
        this.root.update(root -> {
            SnapshotHierarchy result = root;
            for (String location : locations) {
                result = this.updateFunctionDecorator.decorate((currentRoot, changeListener) -> currentRoot.invalidate(location, changeListener)).updateRoot(result);
            }
            return result;
        });
        action.run();
    }

    @Override
    public void invalidateAll() {
        this.updateRoot((root, changeListener) -> {
            root.visitSnapshotRoots(changeListener::nodeRemoved);
            return root.empty();
        });
    }

    @Override
    public void updateWithKnownSnapshot(CompleteFileSystemLocationSnapshot snapshot) {
        this.updateRoot((root, changeListener) -> root.store(snapshot.getAbsolutePath(), snapshot, changeListener));
    }

    private static class StripedProducerGuard<T> {
        private final Striped<Lock> locks = Striped.lock((int)(Runtime.getRuntime().availableProcessors() * 4));

        private StripedProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <V> V guardByKey(T key, Supplier<V> supplier) {
            Lock lock = (Lock)this.locks.get(key);
            try {
                lock.lock();
                V v = supplier.get();
                return v;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

