/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import com.google.common.collect.EnumMultiset;
import com.google.common.collect.Multiset;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.gradle.internal.file.DefaultFileHierarchySet;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.vfs.WatchingAwareVirtualFileSystem;
import org.gradle.internal.vfs.impl.AbstractDelegatingVirtualFileSystem;
import org.gradle.internal.vfs.impl.AbstractVirtualFileSystem;
import org.gradle.internal.vfs.impl.DelegatingDiffCapturingUpdateFunctionDecorator;
import org.gradle.internal.vfs.impl.SnapshotCollectingDiffListener;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.gradle.internal.vfs.watch.FileWatcherRegistryFactory;
import org.gradle.internal.vfs.watch.WatchingNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchingVirtualFileSystem
extends AbstractDelegatingVirtualFileSystem
implements WatchingAwareVirtualFileSystem,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchingVirtualFileSystem.class);
    private final FileWatcherRegistryFactory watcherRegistryFactory;
    private final DelegatingDiffCapturingUpdateFunctionDecorator delegatingUpdateFunctionDecorator;
    private final AtomicReference<FileHierarchySet> producedByCurrentBuild = new AtomicReference<FileHierarchySet>(DefaultFileHierarchySet.of());
    private FileWatcherRegistry watchRegistry;
    private final BlockingQueue<FileEvent> fileEvents = new ArrayBlockingQueue<FileEvent>(4096);
    private volatile boolean buildRunning;
    private final Thread eventConsumerThread;
    private volatile boolean consumeEvents = true;
    private final SnapshotHierarchy.SnapshotDiffListener snapshotDiffListener = (removedSnapshots, addedSnapshots) -> this.updateWatchRegistry(watchRegistry -> watchRegistry.changed(removedSnapshots, addedSnapshots));

    public WatchingVirtualFileSystem(FileWatcherRegistryFactory watcherRegistryFactory, AbstractVirtualFileSystem delegate, DelegatingDiffCapturingUpdateFunctionDecorator delegatingUpdateFunctionDecorator, Predicate<String> watchFilter) {
        super(delegate);
        this.watcherRegistryFactory = watcherRegistryFactory;
        this.delegatingUpdateFunctionDecorator = delegatingUpdateFunctionDecorator;
        this.eventConsumerThread = new Thread(() -> {
            block4: while (true) {
                try {
                    while (this.consumeEvents) {
                        FileEvent nextEvent = this.fileEvents.take();
                        try {
                            if (nextEvent.lostState) {
                                LOGGER.warn("Dropped VFS state due to lost state");
                                this.stopWatching();
                                continue block4;
                            }
                            FileWatcherRegistry.Type type = nextEvent.type;
                            Path path = nextEvent.path;
                            LOGGER.debug("Handling VFS change {} {}", (Object)type, (Object)path);
                            String absolutePath = path.toString();
                            if (this.buildRunning && this.producedByCurrentBuild.get().contains(absolutePath)) continue block4;
                            this.getRoot().update(root -> {
                                SnapshotCollectingDiffListener diffListener = new SnapshotCollectingDiffListener(watchFilter);
                                SnapshotHierarchy newRoot = root.invalidate(absolutePath, diffListener);
                                diffListener.publishSnapshotDiff(this.snapshotDiffListener);
                                return newRoot;
                            });
                            continue block4;
                        }
                        catch (Exception e) {
                            LOGGER.error("Error while processing file events", (Throwable)e);
                            this.stopWatching();
                        }
                    }
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        });
        this.eventConsumerThread.setDaemon(true);
        this.eventConsumerThread.setName("File watcher consumer");
        this.eventConsumerThread.start();
    }

    @Override
    public void afterBuildStarted(boolean watchingEnabled) {
        if (watchingEnabled) {
            this.startWatching();
            this.handleWatcherRegistryEvents("since last build");
            this.printStatistics("retained", "since last build");
            this.producedByCurrentBuild.set(DefaultFileHierarchySet.of());
            this.buildRunning = true;
        } else {
            this.stopWatching();
        }
    }

    private void updateWatchRegistry(Consumer<FileWatcherRegistry> updateFunction) {
        this.updateWatchRegistry(updateFunction, () -> {});
    }

    private synchronized void updateWatchRegistry(Consumer<FileWatcherRegistry> updateFunction, Runnable noWatchRegistry) {
        if (this.watchRegistry == null) {
            noWatchRegistry.run();
        } else {
            this.handleWatcherChanges(updateFunction);
        }
    }

    @Override
    public void updateMustWatchDirectories(Collection<File> mustWatchDirectories) {
        this.updateWatchRegistry(watchRegistry -> watchRegistry.updateMustWatchDirectories(mustWatchDirectories));
    }

    @Override
    public void beforeBuildFinished(boolean watchingEnabled) {
        if (watchingEnabled) {
            this.handleWatcherRegistryEvents("for current build");
            this.buildRunning = false;
            this.producedByCurrentBuild.set(DefaultFileHierarchySet.of());
            this.printStatistics("retains", "till next build");
            this.updateWatchRegistry(watchRegistry -> {}, this::invalidateAll);
        } else {
            this.invalidateAll();
        }
    }

    private synchronized void startWatching() {
        if (this.watchRegistry != null) {
            if (!this.eventConsumerThread.isAlive()) {
                throw new RuntimeException("The thread consuming the file events stopped for an unknown reason");
            }
            return;
        }
        try {
            long startTime = System.currentTimeMillis();
            this.watchRegistry = this.watcherRegistryFactory.startWatcher(new FileWatcherRegistry.ChangeHandler(){

                @Override
                public void handleChange(FileWatcherRegistry.Type type, Path path) {
                    boolean addedToQueue = WatchingVirtualFileSystem.this.fileEvents.offer(FileEvent.changed(path, type));
                    if (!addedToQueue) {
                        LOGGER.warn("Gradle file event buffer overflow, dropping state");
                        this.signalLostState();
                    }
                }

                @Override
                public void handleLostState() {
                    LOGGER.warn("Native file event watching reported lost state");
                    this.signalLostState();
                }

                private void signalLostState() {
                    WatchingVirtualFileSystem.this.fileEvents.clear();
                    try {
                        WatchingVirtualFileSystem.this.fileEvents.put(FileEvent.lostState());
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        throw new RuntimeException(e);
                    }
                }
            });
            this.getRoot().update(SnapshotHierarchy::empty);
            this.delegatingUpdateFunctionDecorator.setSnapshotDiffListener(this.snapshotDiffListener);
            long endTime = System.currentTimeMillis() - startTime;
            LOGGER.warn("Spent {} ms registering watches for file system events", (Object)endTime);
        }
        catch (Exception ex) {
            LOGGER.error("Couldn't create watch service, not tracking changes between builds", (Throwable)ex);
            this.invalidateAll();
            this.close();
        }
    }

    private void handleWatcherChanges(Consumer<FileWatcherRegistry> consumer) {
        try {
            consumer.accept(this.watchRegistry);
        }
        catch (WatchingNotSupportedException ex) {
            LOGGER.warn("Watching not supported, not tracking changes between builds: {}", (Object)ex.getMessage());
            this.stopWatching();
        }
        catch (Exception ex) {
            LOGGER.error("Couldn't update watches, not watching anymore", (Throwable)ex);
            this.stopWatching();
        }
    }

    private void stopWatching() {
        this.updateWatchRegistry(fileWatcherRegistry -> {
            try {
                this.watchRegistry = null;
                this.delegatingUpdateFunctionDecorator.setSnapshotDiffListener(null);
                fileWatcherRegistry.close();
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't fetch file changes, dropping VFS state", (Throwable)ex);
                this.getRoot().update(SnapshotHierarchy::empty);
            }
            finally {
                this.fileEvents.clear();
            }
        });
        this.getRoot().update(SnapshotHierarchy::empty);
    }

    private void handleWatcherRegistryEvents(String eventsFor) {
        this.updateWatchRegistry(watchRegistry -> {
            FileWatcherRegistry.FileWatchingStatistics statistics = watchRegistry.getAndResetStatistics();
            LOGGER.warn("Received {} file system events {}", (Object)statistics.getNumberOfReceivedEvents(), (Object)eventsFor);
            if (statistics.isUnknownEventEncountered()) {
                LOGGER.warn("Dropped VFS state due to lost state");
                this.stopWatching();
            }
            if (statistics.getErrorWhileReceivingFileChanges().isPresent()) {
                LOGGER.warn("Dropped VFS state due to error while receiving file changes", statistics.getErrorWhileReceivingFileChanges().get());
                this.stopWatching();
            }
        });
    }

    private void printStatistics(String verb, String statisticsFor) {
        VirtualFileSystemStatistics statistics = this.getStatistics();
        LOGGER.warn("Virtual file system {} information about {} files, {} directories and {} missing files {}", new Object[]{verb, statistics.getRetained(FileType.RegularFile), statistics.getRetained(FileType.Directory), statistics.getRetained(FileType.Missing), statisticsFor});
    }

    @Override
    public void update(Iterable<String> locations, Runnable action) {
        if (this.buildRunning) {
            this.producedByCurrentBuild.updateAndGet(currentValue -> {
                FileHierarchySet newValue = currentValue;
                for (String location : locations) {
                    newValue = newValue.plus(new File(location));
                }
                return newValue;
            });
        }
        super.update(locations, action);
    }

    private VirtualFileSystemStatistics getStatistics() {
        final EnumMultiset retained = EnumMultiset.create(FileType.class);
        this.getRoot().get().visitSnapshotRoots(snapshot -> snapshot.accept(new FileSystemSnapshotVisitor(){

            @Override
            public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
                retained.add((Object)directorySnapshot.getType());
                return true;
            }

            @Override
            public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
                retained.add((Object)fileSnapshot.getType());
            }

            @Override
            public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            }
        }));
        return new VirtualFileSystemStatistics((Multiset<FileType>)retained);
    }

    @Override
    public void close() {
        this.consumeEvents = false;
        this.producedByCurrentBuild.set(DefaultFileHierarchySet.of());
        this.updateWatchRegistry(fileWatcherRegistry -> {
            try {
                fileWatcherRegistry.close();
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't close watch service", (Throwable)ex);
            }
            this.watchRegistry = null;
        });
    }

    private static class VirtualFileSystemStatistics {
        private final Multiset<FileType> retained;

        public VirtualFileSystemStatistics(Multiset<FileType> retained) {
            this.retained = retained;
        }

        public int getRetained(FileType fileType) {
            return this.retained.count((Object)fileType);
        }
    }

    private static class FileEvent {
        final Path path;
        final FileWatcherRegistry.Type type;
        final boolean lostState;

        public static FileEvent lostState() {
            return new FileEvent(null, null, true);
        }

        public static FileEvent changed(Path path, FileWatcherRegistry.Type type) {
            return new FileEvent(path, type, false);
        }

        private FileEvent(@Nullable Path path, @Nullable FileWatcherRegistry.Type type, boolean lostState) {
            this.path = path;
            this.type = type;
            this.lostState = lostState;
        }
    }
}

