/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.cache;

import java.io.Closeable;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysisCache;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysisSerializer;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.DefaultClassAnalysisCache;
import org.gradle.api.internal.tasks.compile.incremental.cache.GeneralCompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.cache.UserHomeScopedCompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotDataSerializer;
import org.gradle.api.internal.tasks.compile.incremental.classpath.DefaultClasspathEntrySnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.classpath.SplitClasspathEntrySnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationData;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationStore;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.vfs.AdditiveCacheLocations;
import org.gradle.internal.vfs.VirtualFileSystem;

public class DefaultGeneralCompileCaches
implements GeneralCompileCaches,
Closeable {
    private final ClassAnalysisCache classAnalysisCache;
    private final ClasspathEntrySnapshotCache classpathEntrySnapshotCache;
    private final PersistentCache cache;
    private final PersistentIndexedCache<String, PreviousCompilationData> previousCompilationCache;

    public DefaultGeneralCompileCaches(AdditiveCacheLocations additiveCacheLocations, CacheRepository cacheRepository, Gradle gradle, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory, StringInterner interner, UserHomeScopedCompileCaches userHomeScopedCompileCaches, VirtualFileSystem virtualFileSystem) {
        this.cache = cacheRepository.cache((Object)gradle, "javaCompile").withDisplayName("Java compile cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.OnDemand)).open();
        PersistentIndexedCacheParameters classCacheParameters = PersistentIndexedCacheParameters.of((String)"classAnalysis", (Serializer)new HashCodeSerializer(), (Serializer)new ClassAnalysisSerializer(interner)).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(400000, true));
        this.classAnalysisCache = new DefaultClassAnalysisCache((PersistentIndexedCache<HashCode, ClassAnalysis>)this.cache.createCache(classCacheParameters));
        PersistentIndexedCacheParameters jarCacheParameters = PersistentIndexedCacheParameters.of((String)"jarAnalysis", (Serializer)new HashCodeSerializer(), (Serializer)new ClasspathEntrySnapshotDataSerializer(interner)).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(20000, true));
        this.classpathEntrySnapshotCache = new SplitClasspathEntrySnapshotCache(additiveCacheLocations, userHomeScopedCompileCaches.getClasspathEntrySnapshotCache(), new DefaultClasspathEntrySnapshotCache(virtualFileSystem, (PersistentIndexedCache<HashCode, ClasspathEntrySnapshotData>)this.cache.createCache(jarCacheParameters)));
        PersistentIndexedCacheParameters previousCompilationCacheParameters = PersistentIndexedCacheParameters.of((String)"taskHistory", String.class, (Serializer)new PreviousCompilationData.Serializer(interner)).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(2000, false));
        this.previousCompilationCache = this.cache.createCache(previousCompilationCacheParameters);
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public ClassAnalysisCache getClassAnalysisCache() {
        return this.classAnalysisCache;
    }

    @Override
    public ClasspathEntrySnapshotCache getClasspathEntrySnapshotCache() {
        return this.classpathEntrySnapshotCache;
    }

    @Override
    public PreviousCompilationStore createPreviousCompilationStore(String taskPath) {
        return new PreviousCompilationStore(taskPath, this.previousCompilationCache);
    }
}

