/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0016\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u00150\u0018H\u0016J(\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0016\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a\u0012\u0004\u0012\u00020\u00150\u0018H\u0016J(\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0016\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u00150\u0018H\u0016R$\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirSelfImportingScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/FirSession;)V", "callableCache", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "classifierCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/FirSymbolProvider;", "processClassifiersByName", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "name", "processor", "Lkotlin/Function1;", "processFunctionsByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "processPropertiesByName", "resolve"})
public final class FirSelfImportingScope
extends FirScope {
    private final FirSymbolProvider symbolProvider;
    private final Map<Name, FirClassifierSymbol<?>> classifierCache;
    private final Map<Name, List<FirCallableSymbol<?>>> callableCache;
    @NotNull
    private final FqName fqName;
    @NotNull
    private final FirSession session;

    @Override
    @NotNull
    public ProcessorAction processClassifiersByName(@NotNull Name name, @NotNull Function1<? super FirClassifierSymbol<?>, ? extends ProcessorAction> processor2) {
        FirClassifierSymbol symbol2;
        FirClassifierSymbol firClassifierSymbol;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        String string2 = name.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name.asString()");
        CharSequence charSequence = string2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return ProcessorAction.NONE;
        }
        Map<Name, FirClassifierSymbol<?>> $this$getOrPut$iv = this.classifierCache;
        boolean $i$f$getOrPut = false;
        FirClassifierSymbol value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl2 = false;
            ClassId unambiguousFqName = new ClassId(this.fqName, name);
            FirClassifierSymbol answer$iv = this.symbolProvider.getClassLikeSymbolByFqName(unambiguousFqName);
            $this$getOrPut$iv.put(name, answer$iv);
            firClassifierSymbol = answer$iv;
        } else {
            firClassifierSymbol = value$iv;
        }
        return (symbol2 = firClassifierSymbol) != null ? (ProcessorAction)((Object)processor2.invoke(symbol2)) : ProcessorAction.NONE;
    }

    @Override
    @NotNull
    public ProcessorAction processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirFunctionSymbol<?>, ? extends ProcessorAction> processor2) {
        List<FirCallableSymbol<?>> list2;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Map<Name, List<FirCallableSymbol<?>>> $this$getOrPut$iv = this.callableCache;
        boolean $i$f$getOrPut = false;
        List<FirCallableSymbol<?>> value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            List<FirCallableSymbol<?>> answer$iv = this.symbolProvider.getTopLevelCallableSymbols(this.fqName, name);
            $this$getOrPut$iv.put(name, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        List<FirCallableSymbol<?>> symbols2 = list2;
        for (FirCallableSymbol<?> symbol2 : symbols2) {
            if (!(symbol2 instanceof FirFunctionSymbol) || !((ProcessorAction)((Object)processor2.invoke(symbol2))).not()) continue;
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    @Override
    @NotNull
    public ProcessorAction processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction> processor2) {
        List<FirCallableSymbol<?>> list2;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Map<Name, List<FirCallableSymbol<?>>> $this$getOrPut$iv = this.callableCache;
        boolean $i$f$getOrPut = false;
        List<FirCallableSymbol<?>> value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            List<FirCallableSymbol<?>> answer$iv = this.symbolProvider.getTopLevelCallableSymbols(this.fqName, name);
            $this$getOrPut$iv.put(name, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        List<FirCallableSymbol<?>> symbols2 = list2;
        for (FirCallableSymbol<?> symbol2 : symbols2) {
            if (!(symbol2 instanceof FirPropertySymbol) || !((ProcessorAction)((Object)processor2.invoke(symbol2))).not()) continue;
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    @NotNull
    public final FqName getFqName() {
        return this.fqName;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    public FirSelfImportingScope(@NotNull FqName fqName2, @NotNull FirSession session) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.fqName = fqName2;
        this.session = session;
        this.symbolProvider = FirSymbolProvider.Companion.getInstance(this.session);
        FirSelfImportingScope firSelfImportingScope = this;
        boolean bl = false;
        firSelfImportingScope.classifierCache = map2 = (Map)new LinkedHashMap();
        firSelfImportingScope = this;
        bl = false;
        firSelfImportingScope.callableCache = map2 = (Map)new LinkedHashMap();
    }
}

