/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.instantexecution.problems;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.instantexecution.problems.ProblemDescriptionKt;
import org.gradle.instantexecution.problems.PropertyProblem;
import org.gradle.instantexecution.problems.StructuredMessage;
import org.gradle.internal.logging.ConsoleRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001e\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a.\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u001c\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000bH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0010\u001a\n \u0011*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a,\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002*$\b\u0002\u0010\u0013\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u0014"}, d2={"buildConsoleSummary", "", "problems", "", "Lorg/gradle/instantexecution/problems/PropertyProblem;", "reportFile", "Ljava/io/File;", "buildSummaryHeader", "totalProblemCount", "", "uniquePropertyProblems", "", "Lkotlin/Pair;", "Lorg/gradle/instantexecution/problems/StructuredMessage;", "Lorg/gradle/instantexecution/problems/UniquePropertyProblem;", "buildSummaryReportLink", "clickableUrlFor", "kotlin.jvm.PlatformType", "file", "UniquePropertyProblem", "gradle-instant-execution"})
public final class ProblemsSummaryKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String buildConsoleSummary(@NotNull List<PropertyProblem> problems, @NotNull File reportFile) {
        Intrinsics.checkParameterIsNotNull(problems, (String)"problems");
        Intrinsics.checkParameterIsNotNull((Object)reportFile, (String)"reportFile");
        Set<Pair<String, StructuredMessage>> uniquePropertyProblems = ProblemsSummaryKt.uniquePropertyProblems(problems);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        StringsKt.appendln((StringBuilder)$this$apply);
        StringBuilder stringBuilder2 = $this$apply;
        String string = ProblemsSummaryKt.buildSummaryHeader(problems.size(), uniquePropertyProblems);
        boolean bl4 = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        Iterable $this$forEach$iv = uniquePropertyProblems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void property;
            Pair $dstr$property$message = (Pair)element$iv;
            boolean bl5 = false;
            String string2 = (String)$dstr$property$message.component1();
            StructuredMessage message = (StructuredMessage)$dstr$property$message.component2();
            $this$apply.append("- ");
            $this$apply.append((String)property);
            $this$apply.append(": ");
            StringBuilder stringBuilder4 = $this$apply;
            boolean bl6 = false;
            StringBuilder stringBuilder5 = stringBuilder4.append(message);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
        }
        StringsKt.appendln((StringBuilder)$this$apply);
        $this$apply.append(ProblemsSummaryKt.buildSummaryReportLink(reportFile));
        String string3 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder().apply {\n\u2026rtFile))\n    }.toString()");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<Pair<String, StructuredMessage>> uniquePropertyProblems(List<PropertyProblem> problems) {
        void $this$groupByTo$iv$iv;
        Iterable $this$sortedBy$iv = problems;
        boolean $i$f$sortedBy = false;
        Iterable iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PropertyProblem it = (PropertyProblem)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)SequencesKt.toList(it.getTrace().getSequence())), (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
                it = (PropertyProblem)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)SequencesKt.toList(it.getTrace().getSequence())), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        Iterable $this$groupBy$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        boolean $i$f$groupBy = false;
        iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            PropertyProblem it = (PropertyProblem)element$iv$iv;
            boolean bl2 = false;
            Pair key$iv$iv = TuplesKt.to((Object)ProblemDescriptionKt.propertyDescriptionFor(it.getTrace()), (Object)it.getMessage());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv.keySet();
    }

    private static final String buildSummaryHeader(int totalProblemCount, Set<Pair<String, StructuredMessage>> uniquePropertyProblems) {
        String problemOrProblems = totalProblemCount == 1 ? "problem was" : "problems were";
        int uniqueProblemCount = uniquePropertyProblems.size();
        String seemsOrSeem = uniqueProblemCount == 1 ? "seems" : "seem";
        return totalProblemCount + " instant execution " + problemOrProblems + " found, " + uniqueProblemCount + " of which " + seemsOrSeem + " unique.";
    }

    private static final String buildSummaryReportLink(File reportFile) {
        return "See the complete report at " + ProblemsSummaryKt.clickableUrlFor(reportFile);
    }

    private static final String clickableUrlFor(File file) {
        return new ConsoleRenderer().asClickableFileUrl(file);
    }
}

