/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.vfs.WatchingAwareVirtualFileSystem;
import org.gradle.util.IncubationLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VirtualFileSystemBuildLifecycleListener
implements RootBuildLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualFileSystemBuildLifecycleListener.class);
    private final WatchingAwareVirtualFileSystem virtualFileSystem;
    private final StartParameterSwitch vfsRetention;
    private final StartParameterSwitch dropVfs;
    private final StartParameterValue changedPathsSinceLastBuildParameter;

    public VirtualFileSystemBuildLifecycleListener(WatchingAwareVirtualFileSystem virtualFileSystem, StartParameterSwitch vfsRetention, StartParameterSwitch dropVfs, StartParameterValue changedPathsSinceLastBuildParameter) {
        this.virtualFileSystem = virtualFileSystem;
        this.vfsRetention = vfsRetention;
        this.dropVfs = dropVfs;
        this.changedPathsSinceLastBuildParameter = changedPathsSinceLastBuildParameter;
    }

    @Override
    public void afterStart(GradleInternal gradle) {
        StartParameter startParameter = gradle.getStartParameter();
        boolean vfsRetentionEnabled = this.vfsRetention.isEnabled(startParameter);
        if (vfsRetentionEnabled) {
            IncubationLogger.incubatingFeatureUsed((String)"Virtual file system retention");
            BaseDirFileResolver fileResolver = new BaseDirFileResolver(startParameter.getCurrentDir());
            if (this.dropVfs.isEnabled(startParameter)) {
                this.virtualFileSystem.invalidateAll();
            } else {
                List<File> changedPathsSinceLastBuild = VirtualFileSystemBuildLifecycleListener.getChangedPathsSinceLastBuild((PathToFileResolver)fileResolver, this.changedPathsSinceLastBuildParameter.getValue(startParameter));
                for (File changedPathSinceLastBuild : changedPathsSinceLastBuild) {
                    LOGGER.warn("Marking as changed since last build: {}", (Object)changedPathSinceLastBuild);
                }
                this.virtualFileSystem.update((Iterable)changedPathsSinceLastBuild.stream().map(File::getAbsolutePath).collect(Collectors.toList()), () -> {});
            }
        }
        this.virtualFileSystem.afterBuildStarted(vfsRetentionEnabled);
        gradle.settingsEvaluated(settings -> this.virtualFileSystem.updateMustWatchDirectories((Collection)ImmutableList.of((Object)settings.getRootDir())));
    }

    private static List<File> getChangedPathsSinceLastBuild(PathToFileResolver resolver, @Nullable String changeList) {
        if (changeList == null) {
            return ImmutableList.of();
        }
        return Stream.of(changeList.split(",")).filter(path -> !path.isEmpty()).map(arg_0 -> ((PathToFileResolver)resolver).resolve(arg_0)).collect(Collectors.toList());
    }

    @Override
    public void beforeComplete(GradleInternal gradle) {
        this.virtualFileSystem.beforeBuildFinished(this.vfsRetention.isEnabled(gradle.getStartParameter()));
    }

    public static interface StartParameterValue {
        @Nullable
        public String getValue(StartParameter var1);
    }

    public static interface StartParameterSwitch {
        public boolean isEnabled(StartParameter var1);
    }
}

