/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.io.Closeable;
import java.io.IOException;
import org.gradle.StartParameter;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultCollectionCallbackActionDecorator;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.configuration.internal.DefaultListenerBuildOperationDecorator;
import org.gradle.configuration.internal.DefaultUserCodeApplicationContext;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.initialization.DefaultGradleLauncherFactory;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.DefaultParallelismConfiguration;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.logging.sink.OutputEventListenerManager;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.BuildOperationQueueFactory;
import org.gradle.internal.operations.DefaultBuildOperationExecutor;
import org.gradle.internal.operations.DefaultBuildOperationQueueFactory;
import org.gradle.internal.operations.DelegatingBuildOperationExecutor;
import org.gradle.internal.operations.logging.LoggingBuildOperationProgressBroadcaster;
import org.gradle.internal.operations.notify.BuildOperationNotificationBridge;
import org.gradle.internal.operations.notify.BuildOperationNotificationListenerRegistrar;
import org.gradle.internal.operations.notify.BuildOperationNotificationValve;
import org.gradle.internal.operations.trace.BuildOperationTrace;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.time.Clock;
import org.gradle.internal.work.DefaultWorkerLeaseService;
import org.gradle.internal.work.StopShieldingWorkerLeaseService;
import org.gradle.internal.work.WorkerLeaseService;

public class CrossBuildSessionScopeServices
implements Closeable {
    private final BuildOperationTrace buildOperationTrace;
    private final BuildOperationNotificationBridge buildOperationNotificationBridge;
    private final LoggingBuildOperationProgressBroadcaster loggingBuildOperationProgressBroadcaster;
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final Services services;

    public CrossBuildSessionScopeServices(ServiceRegistry parent, StartParameter startParameter) {
        this.services = new Services(parent, startParameter);
        this.buildOperationListenerManager = (BuildOperationListenerManager)parent.get(BuildOperationListenerManager.class);
        ListenerManager generalListenerManager = (ListenerManager)parent.get(ListenerManager.class);
        this.buildOperationTrace = new BuildOperationTrace(startParameter, this.buildOperationListenerManager);
        this.buildOperationNotificationBridge = new BuildOperationNotificationBridge(this.buildOperationListenerManager, generalListenerManager);
        this.loggingBuildOperationProgressBroadcaster = new LoggingBuildOperationProgressBroadcaster((OutputEventListenerManager)parent.get(OutputEventListenerManager.class), this.buildOperationListenerManager.getBroadcaster());
    }

    GradleLauncherFactory createGradleLauncherFactory() {
        return (GradleLauncherFactory)this.services.get(GradleLauncherFactory.class);
    }

    WorkerLeaseService createWorkerLeaseService() {
        return new StopShieldingWorkerLeaseService((WorkerLeaseService)this.services.get(WorkerLeaseService.class));
    }

    BuildOperationListenerManager createBuildOperationListenerManager() {
        return this.buildOperationListenerManager;
    }

    LoggingBuildOperationProgressBroadcaster createLoggingBuildOperationProgressBroadcaster() {
        return this.loggingBuildOperationProgressBroadcaster;
    }

    BuildOperationExecutor createBuildOperationExecutor() {
        return new DelegatingBuildOperationExecutor((BuildOperationExecutor)this.services.get(BuildOperationExecutor.class));
    }

    ListenerBuildOperationDecorator createListenerBuildOperationDecorator() {
        return (ListenerBuildOperationDecorator)this.services.get(ListenerBuildOperationDecorator.class);
    }

    UserCodeApplicationContext createUserCodeApplicationContext() {
        return (UserCodeApplicationContext)this.services.get(UserCodeApplicationContext.class);
    }

    BuildOperationNotificationListenerRegistrar createBuildOperationNotificationListenerRegistrar() {
        return this.buildOperationNotificationBridge.getRegistrar();
    }

    BuildOperationNotificationValve createBuildOperationNotificationValve() {
        return this.buildOperationNotificationBridge.getValve();
    }

    CollectionCallbackActionDecorator createDomainObjectCollectioncallbackActionDecorator(BuildOperationExecutor buildOperationExecutor, UserCodeApplicationContext userCodeApplicationContext) {
        return (CollectionCallbackActionDecorator)this.services.get(CollectionCallbackActionDecorator.class);
    }

    @Override
    public void close() throws IOException {
        new CompositeStoppable().add(new Object[]{this.buildOperationTrace, this.buildOperationNotificationBridge, this.loggingBuildOperationProgressBroadcaster, this.services}).stop();
    }

    private class Services
    extends DefaultServiceRegistry {
        private final StartParameter startParameter;

        public Services(ServiceRegistry parent, StartParameter startParameter) {
            super(new ServiceRegistry[]{parent});
            this.startParameter = startParameter;
        }

        ParallelismConfiguration createParallelismConfiguration() {
            return new DefaultParallelismConfiguration(this.startParameter.isParallelProjectExecutionEnabled(), this.startParameter.getMaxWorkerCount());
        }

        GradleLauncherFactory createGradleLauncherFactory(GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry) {
            return new DefaultGradleLauncherFactory(userHomeDirServiceRegistry, CrossBuildSessionScopeServices.this);
        }

        WorkerLeaseService createWorkerLeaseService(ResourceLockCoordinationService resourceLockCoordinationService, ParallelismConfiguration parallelismConfiguration) {
            return new DefaultWorkerLeaseService(resourceLockCoordinationService, parallelismConfiguration);
        }

        BuildOperationExecutor createBuildOperationExecutor(Clock clock, ProgressLoggerFactory progressLoggerFactory, WorkerLeaseService workerLeaseService, ExecutorFactory executorFactory, ParallelismConfiguration parallelismConfiguration, BuildOperationIdFactory buildOperationIdFactory) {
            return new DefaultBuildOperationExecutor(CrossBuildSessionScopeServices.this.buildOperationListenerManager.getBroadcaster(), clock, progressLoggerFactory, (BuildOperationQueueFactory)new DefaultBuildOperationQueueFactory(workerLeaseService), executorFactory, parallelismConfiguration, buildOperationIdFactory);
        }

        UserCodeApplicationContext createUserCodeApplicationContext() {
            return new DefaultUserCodeApplicationContext();
        }

        ListenerBuildOperationDecorator createListenerBuildOperationDecorator(BuildOperationExecutor buildOperationExecutor, UserCodeApplicationContext userCodeApplicationContext) {
            return new DefaultListenerBuildOperationDecorator(buildOperationExecutor, userCodeApplicationContext);
        }

        CollectionCallbackActionDecorator createDomainObjectCollectioncallbackActionDecorator(BuildOperationExecutor buildOperationExecutor, UserCodeApplicationContext userCodeApplicationContext) {
            return new DefaultCollectionCallbackActionDecorator(buildOperationExecutor, userCodeApplicationContext);
        }
    }
}

