/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.api;

import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.launcher.daemon.protocol.InvalidateVirtualFileSystem;
import org.gradle.launcher.daemon.protocol.Success;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleInvalidateVirtualFileSystem
implements DaemonCommandAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandleInvalidateVirtualFileSystem.class);
    private final GradleUserHomeScopeServiceRegistry gradleUserHomeScopeServiceRegistry;

    public HandleInvalidateVirtualFileSystem(GradleUserHomeScopeServiceRegistry gradleUserHomeScopeServiceRegistry) {
        this.gradleUserHomeScopeServiceRegistry = gradleUserHomeScopeServiceRegistry;
    }

    @Override
    public void execute(DaemonCommandExecution execution) {
        if (execution.getCommand() instanceof InvalidateVirtualFileSystem) {
            InvalidateVirtualFileSystem command = (InvalidateVirtualFileSystem)execution.getCommand();
            this.gradleUserHomeScopeServiceRegistry.getCurrentServices().ifPresent(currentServices -> {
                LOGGER.info("Invalidating {}", command.getChangedPaths());
                VirtualFileSystem virtualFileSystem = currentServices.get(VirtualFileSystem.class);
                virtualFileSystem.update(command.getChangedPaths(), () -> {});
            });
            execution.getConnection().completed(new Success((Object)null));
        } else {
            execution.proceed();
        }
    }
}

