/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.parser;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.kotlin.com.intellij.lang.PsiParser;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/kdoc/parser/KDocLinkParser;", "Lorg/jetbrains/kotlin/com/intellij/lang/PsiParser;", "()V", "isName", "", "tokenType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "parse", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "root", "builder", "Lorg/jetbrains/kotlin/com/intellij/lang/PsiBuilder;", "parseQualifiedName", "", "Companion", "psi"})
public final class KDocLinkParser
implements PsiParser {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ASTNode parse(@NotNull IElementType root2, @NotNull PsiBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkExpressionValueIsNotNull((Object)marker, (String)"builder.mark()");
        PsiBuilder.Marker rootMarker = marker;
        boolean hasLBracket = Intrinsics.areEqual((Object)builder.getTokenType(), (Object)KtTokens.LBRACKET);
        if (hasLBracket) {
            builder.advanceLexer();
        }
        this.parseQualifiedName(builder);
        if (hasLBracket) {
            if (!builder.eof() && Intrinsics.areEqual((Object)builder.getTokenType(), (Object)KtTokens.RBRACKET) ^ true) {
                builder.error("Closing bracket expected");
                while (!builder.eof() && Intrinsics.areEqual((Object)builder.getTokenType(), (Object)KtTokens.RBRACKET) ^ true) {
                    builder.advanceLexer();
                }
            }
            if (Intrinsics.areEqual((Object)builder.getTokenType(), (Object)KtTokens.RBRACKET)) {
                builder.advanceLexer();
            }
        } else if (!builder.eof()) {
            builder.error("Expression expected");
            while (!builder.eof()) {
                builder.advanceLexer();
            }
        }
        rootMarker.done(root2);
        ASTNode aSTNode = builder.getTreeBuilt();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"builder.treeBuilt");
        return aSTNode;
    }

    private final void parseQualifiedName(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        Intrinsics.checkExpressionValueIsNotNull((Object)marker, (String)"builder.mark()");
        PsiBuilder.Marker marker2 = marker;
        while (true) {
            if (!this.isName(builder.getTokenType())) {
                marker2.drop();
                builder.error("Identifier expected");
                break;
            }
            builder.advanceLexer();
            marker2.done(KDocElementTypes.KDOC_NAME);
            if (Intrinsics.areEqual((Object)builder.getTokenType(), (Object)KtTokens.DOT) ^ true) break;
            Intrinsics.checkExpressionValueIsNotNull((Object)marker2.precede(), (String)"marker.precede()");
            builder.advanceLexer();
        }
    }

    private final boolean isName(IElementType tokenType) {
        return Intrinsics.areEqual((Object)tokenType, (Object)KtTokens.IDENTIFIER) || KtTokens.KEYWORDS.contains(tokenType);
    }

    @JvmStatic
    @NotNull
    public static final ASTNode parseMarkdownLink(@NotNull IElementType root2, @NotNull ASTNode chameleon) {
        return Companion.parseMarkdownLink(root2, chameleon);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/kdoc/parser/KDocLinkParser$Companion;", "", "()V", "parseMarkdownLink", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "root", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "chameleon", "psi"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ASTNode parseMarkdownLink(@NotNull IElementType root2, @NotNull ASTNode chameleon) {
            PsiElement parentElement;
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Intrinsics.checkParameterIsNotNull((Object)chameleon, (String)"chameleon");
            ASTNode aSTNode = chameleon.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"chameleon.treeParent");
            PsiElement psiElement = parentElement = aSTNode.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parentElement");
            Project project = psiElement.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"parentElement.project");
            Project project2 = project;
            PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(project2, chameleon, (Lexer)new KotlinLexer(), root2.getLanguage(), (CharSequence)chameleon.getText());
            Intrinsics.checkExpressionValueIsNotNull((Object)psiBuilder, (String)"PsiBuilderFactory.getIns\u2026meleon.text\n            )");
            PsiBuilder builder = psiBuilder;
            KDocLinkParser parser = new KDocLinkParser();
            ASTNode aSTNode2 = parser.parse(root2, builder).getFirstChildNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"parser.parse(root, builder).firstChildNode");
            return aSTNode2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

