/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import java.util.Collections;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TmpDirTemporaryFileProvider;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.internal.FileUtils;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.BuildSessionScopeServices;
import org.gradle.internal.service.scopes.BuildTreeScopeServices;
import org.gradle.internal.service.scopes.CrossBuildSessionScopeServices;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.time.Time;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.invocation.DefaultGradle;
import org.gradle.testfixtures.internal.TestBuildScopeServices;
import org.gradle.testfixtures.internal.TestGlobalScopeServices;
import org.gradle.util.Path;

public class ProjectBuilderImpl {
    private static ServiceRegistry globalServices;

    public Project createChildProject(String name, Project parent, File projectDir) {
        ProjectInternal parentProject = (ProjectInternal)parent;
        ProjectDescriptorRegistry descriptorRegistry = (ProjectDescriptorRegistry)parentProject.getServices().get(ProjectDescriptorRegistry.class);
        DefaultProjectDescriptor parentDescriptor = (DefaultProjectDescriptor)descriptorRegistry.getProject(parentProject.getPath());
        projectDir = projectDir != null ? projectDir.getAbsoluteFile() : new File(parentProject.getProjectDir(), name);
        DefaultProjectDescriptor projectDescriptor = new DefaultProjectDescriptor(parentDescriptor, name, projectDir, descriptorRegistry, (PathToFileResolver)parentProject.getServices().get(FileResolver.class));
        descriptorRegistry.addProject(projectDescriptor);
        ((ProjectStateRegistry)parentProject.getServices().get(ProjectStateRegistry.class)).registerProject((BuildState)parentProject.getServices().get(BuildState.class), projectDescriptor);
        ProjectInternal project = ((IProjectFactory)parentProject.getServices().get(IProjectFactory.class)).createProject(parentProject.getGradle(), projectDescriptor, parentProject, parentProject.getClassLoaderScope().createChild("project-" + name), parentProject.getBaseClassLoaderScope());
        ResourceLockCoordinationService coordinationService = (ResourceLockCoordinationService)project.getServices().get(ResourceLockCoordinationService.class);
        coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock((ResourceLock[])new ResourceLock[]{project.getMutationState().getAccessLock()}));
        return project;
    }

    public Project createProject(String name, File inputProjectDir, File gradleUserHomeDir) {
        File projectDir = this.prepareProjectDir(inputProjectDir);
        File homeDir = new File(projectDir, "gradleHome");
        StartParameterInternal startParameter = new StartParameterInternal();
        File userHomeDir = gradleUserHomeDir == null ? new File(projectDir, "userHome") : FileUtils.canonicalize((File)gradleUserHomeDir);
        startParameter.setGradleUserHomeDir(userHomeDir);
        NativeServices.initialize((File)userHomeDir);
        DefaultBuildRequestMetaData buildRequestMetaData = new DefaultBuildRequestMetaData(Time.currentTimeMillis());
        CrossBuildSessionScopeServices crossBuildSessionScopeServices = new CrossBuildSessionScopeServices(ProjectBuilderImpl.getGlobalServices(), startParameter);
        ServiceRegistry userHomeServices = this.getUserHomeServices(userHomeDir);
        BuildSessionScopeServices buildSessionScopeServices = new BuildSessionScopeServices(userHomeServices, crossBuildSessionScopeServices, startParameter, buildRequestMetaData, ClassPath.EMPTY, new DefaultBuildCancellationToken(), buildRequestMetaData.getClient(), new NoOpBuildEventConsumer());
        BuildTreeScopeServices buildTreeScopeServices = new BuildTreeScopeServices((ServiceRegistry)buildSessionScopeServices);
        TestBuildScopeServices buildServices = new TestBuildScopeServices((ServiceRegistry)buildTreeScopeServices, homeDir);
        TestRootBuild build = new TestRootBuild();
        buildServices.add(BuildState.class, build);
        ((BuildStateRegistry)buildServices.get(BuildStateRegistry.class)).attachRootBuild(build);
        GradleInternal gradle = (GradleInternal)((InstantiatorFactory)buildServices.get(InstantiatorFactory.class)).decorateLenient().newInstance(DefaultGradle.class, new Object[]{null, startParameter, buildServices.get(ServiceRegistryFactory.class)});
        gradle.setIncludedBuilds(Collections.emptyList());
        ProjectDescriptorRegistry projectDescriptorRegistry = (ProjectDescriptorRegistry)buildServices.get(ProjectDescriptorRegistry.class);
        DefaultProjectDescriptor projectDescriptor = new DefaultProjectDescriptor(null, name, projectDir, projectDescriptorRegistry, (PathToFileResolver)buildServices.get(FileResolver.class));
        projectDescriptorRegistry.addProject(projectDescriptor);
        ClassLoaderScope baseScope = gradle.getClassLoaderScope();
        ClassLoaderScope rootProjectScope = baseScope.createChild("root-project");
        ((ProjectStateRegistry)buildServices.get(ProjectStateRegistry.class)).registerProject(build, projectDescriptor);
        ProjectInternal project = ((IProjectFactory)buildServices.get(IProjectFactory.class)).createProject(gradle, projectDescriptor, null, rootProjectScope, baseScope);
        gradle.setRootProject(project);
        gradle.setDefaultProject(project);
        ResourceLockCoordinationService coordinationService = (ResourceLockCoordinationService)buildServices.get(ResourceLockCoordinationService.class);
        WorkerLeaseService workerLeaseService = (WorkerLeaseService)buildServices.get(WorkerLeaseService.class);
        coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock((ResourceLock[])new ResourceLock[]{workerLeaseService.getWorkerLease(), project.getMutationState().getAccessLock()}));
        return project;
    }

    private ServiceRegistry getUserHomeServices(File userHomeDir) {
        ServiceRegistry globalServices = ProjectBuilderImpl.getGlobalServices();
        GradleUserHomeScopeServiceRegistry userHomeScopeServiceRegistry = (GradleUserHomeScopeServiceRegistry)globalServices.get(GradleUserHomeScopeServiceRegistry.class);
        return userHomeScopeServiceRegistry.getServicesFor(userHomeDir);
    }

    public static synchronized ServiceRegistry getGlobalServices() {
        if (globalServices == null) {
            globalServices = ServiceRegistryBuilder.builder().displayName("global services").parent((ServiceRegistry)LoggingServiceRegistry.newNestedLogging()).parent((ServiceRegistry)NativeServices.getInstance()).provider((Object)new TestGlobalScopeServices()).build();
            ((LegacyTypesSupport)globalServices.get(LegacyTypesSupport.class)).injectEmptyInterfacesIntoClassLoader(ProjectBuilderImpl.class.getClassLoader());
        }
        return globalServices;
    }

    public File prepareProjectDir(File projectDir) {
        if (projectDir == null) {
            TmpDirTemporaryFileProvider temporaryFileProvider = new TmpDirTemporaryFileProvider();
            projectDir = temporaryFileProvider.createTemporaryDirectory("gradle", "projectDir", new String[0]);
            projectDir.deleteOnExit();
        } else {
            projectDir = FileUtils.canonicalize((File)projectDir);
        }
        return projectDir;
    }

    private static class TestRootBuild
    extends AbstractBuildState
    implements RootBuildState {
        private TestRootBuild() {
        }

        @Override
        public BuildIdentifier getBuildIdentifier() {
            return DefaultBuildIdentifier.ROOT;
        }

        @Override
        public Path getIdentityPath() {
            return Path.ROOT;
        }

        @Override
        public boolean isImplicitBuild() {
            return false;
        }

        @Override
        public SettingsInternal getLoadedSettings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NestedBuildFactory getNestedBuildFactory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Path getCurrentPrefixForProjectsInChildBuilds() {
            return Path.ROOT;
        }

        @Override
        public Path getIdentityPathForProject(Path projectPath) {
            return projectPath;
        }

        @Override
        public StartParameter getStartParameter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T run(Transformer<T, ? super BuildController> buildAction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProjectComponentIdentifier getIdentifierForProject(Path projectPath) {
            String name = projectPath.getName();
            if (name == null) {
                name = "root";
            }
            return new DefaultProjectComponentIdentifier(this.getBuildIdentifier(), projectPath, projectPath, name);
        }
    }
}

