/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.base.Function;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.AbstractMultiset;
import org.jetbrains.kotlin.com.google.common.collect.CollectPreconditions;
import org.jetbrains.kotlin.com.google.common.collect.CollectSpliterators;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.google.common.collect.Multiset;
import org.jetbrains.kotlin.com.google.common.collect.Multisets;
import org.jetbrains.kotlin.com.google.common.collect.TransformedIterator;
import org.jetbrains.kotlin.com.google.j2objc.annotations.Weak;

public final class Multimaps {
    static boolean equalsImpl(Multimap<?, ?> multimap, @Nullable Object object) {
        if (object == multimap) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap that = (Multimap)object;
            return multimap.asMap().equals(that.asMap());
        }
        return false;
    }

    static final class AsMap<K, V>
    extends Maps.ViewCachingAbstractMap<K, Collection<V>> {
        @Weak
        private final Multimap<K, V> multimap;

        AsMap(Multimap<K, V> multimap) {
            this.multimap = Preconditions.checkNotNull(multimap);
        }

        @Override
        public int size() {
            return this.multimap.keySet().size();
        }

        @Override
        protected Set<Map.Entry<K, Collection<V>>> createEntrySet() {
            return new EntrySet();
        }

        void removeValuesForKey(Object key) {
            this.multimap.keySet().remove(key);
        }

        @Override
        public Collection<V> get(Object key) {
            return this.containsKey(key) ? this.multimap.get(key) : null;
        }

        @Override
        public Collection<V> remove(Object key) {
            return this.containsKey(key) ? this.multimap.removeAll(key) : null;
        }

        @Override
        public Set<K> keySet() {
            return this.multimap.keySet();
        }

        @Override
        public boolean isEmpty() {
            return this.multimap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.multimap.containsKey(key);
        }

        @Override
        public void clear() {
            this.multimap.clear();
        }

        class EntrySet
        extends Maps.EntrySet<K, Collection<V>> {
            EntrySet() {
            }

            @Override
            Map<K, Collection<V>> map() {
                return AsMap.this;
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return Maps.asMapEntryIterator(AsMap.this.multimap.keySet(), new Function<K, Collection<V>>(){

                    @Override
                    public Collection<V> apply(K key) {
                        return AsMap.this.multimap.get(key);
                    }
                });
            }

            @Override
            public boolean remove(Object o) {
                if (!this.contains(o)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                AsMap.this.removeValuesForKey(entry.getKey());
                return true;
            }
        }
    }

    static abstract class Entries<K, V>
    extends AbstractCollection<Map.Entry<K, V>> {
        Entries() {
        }

        abstract Multimap<K, V> multimap();

        @Override
        public int size() {
            return this.multimap().size();
        }

        @Override
        public boolean contains(@Nullable Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return this.multimap().containsEntry(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(@Nullable Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return this.multimap().remove(entry.getKey(), entry.getValue());
            }
            return false;
        }

        @Override
        public void clear() {
            this.multimap().clear();
        }
    }

    static class Keys<K, V>
    extends AbstractMultiset<K> {
        @Weak
        final Multimap<K, V> multimap;

        Keys(Multimap<K, V> multimap) {
            this.multimap = multimap;
        }

        @Override
        Iterator<Multiset.Entry<K>> entryIterator() {
            return new TransformedIterator<Map.Entry<K, Collection<V>>, Multiset.Entry<K>>(this.multimap.asMap().entrySet().iterator()){

                @Override
                Multiset.Entry<K> transform(final Map.Entry<K, Collection<V>> backingEntry) {
                    return new Multisets.AbstractEntry<K>(){

                        @Override
                        public K getElement() {
                            return backingEntry.getKey();
                        }

                        @Override
                        public int getCount() {
                            return ((Collection)backingEntry.getValue()).size();
                        }
                    };
                }
            };
        }

        @Override
        public Spliterator<K> spliterator() {
            return CollectSpliterators.map(this.multimap.entries().spliterator(), Map.Entry::getKey);
        }

        @Override
        public void forEach(Consumer<? super K> consumer) {
            Preconditions.checkNotNull(consumer);
            this.multimap.entries().forEach((? super T entry) -> consumer.accept((Object)entry.getKey()));
        }

        @Override
        int distinctElements() {
            return this.multimap.asMap().size();
        }

        @Override
        public int size() {
            return this.multimap.size();
        }

        @Override
        public boolean contains(@Nullable Object element) {
            return this.multimap.containsKey(element);
        }

        @Override
        public Iterator<K> iterator() {
            return Maps.keyIterator(this.multimap.entries().iterator());
        }

        @Override
        public int count(@Nullable Object element) {
            Collection<V> values2 = Maps.safeGet(this.multimap.asMap(), element);
            return values2 == null ? 0 : values2.size();
        }

        @Override
        public int remove(@Nullable Object element, int occurrences) {
            CollectPreconditions.checkNonnegative(occurrences, "occurrences");
            if (occurrences == 0) {
                return this.count(element);
            }
            Collection<V> values2 = Maps.safeGet(this.multimap.asMap(), element);
            if (values2 == null) {
                return 0;
            }
            int oldCount = values2.size();
            if (occurrences >= oldCount) {
                values2.clear();
            } else {
                Iterator<V> iterator2 = values2.iterator();
                for (int i = 0; i < occurrences; ++i) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
            return oldCount;
        }

        @Override
        public void clear() {
            this.multimap.clear();
        }

        @Override
        public Set<K> elementSet() {
            return this.multimap.keySet();
        }

        @Override
        Iterator<K> elementIterator() {
            throw new AssertionError((Object)"should never be called");
        }
    }
}

