/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.coroutines;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.SuspendableNodesCollector;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u00a8\u0006\n"}, d2={"collectSuspendableNodes", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "function", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "needUnboxingOrUnit", "", "fromType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "toType", "backend.js"})
public final class SuspendLoweringUtilsKt {
    @NotNull
    public static final Set<IrElement> collectSuspendableNodes(@NotNull IrBlock function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        boolean bl = false;
        Set suspendableNodes = new LinkedHashSet();
        int size = 0;
        do {
            size = suspendableNodes.size();
            IrElementVisitorVoidKt.acceptVoid(function2, new SuspendableNodesCollector(suspendableNodes));
        } while (size != suspendableNodes.size());
        return suspendableNodes;
    }

    public static final boolean needUnboxingOrUnit(@NotNull IrType fromType, @NotNull IrType toType) {
        Intrinsics.checkParameterIsNotNull((Object)fromType, (String)"fromType");
        Intrinsics.checkParameterIsNotNull((Object)toType, (String)"toType");
        return InlineClassesKt.getInlinedClass(fromType) == null && InlineClassesKt.getInlinedClass(toType) != null || IrTypePredicatesKt.isUnit(fromType) && !IrTypePredicatesKt.isUnit(toType);
    }
}

