/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.internal.precompiled;

import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.gradle.plugin.devel.internal.precompiled.CompileGroovyScriptPluginsTask;
import org.gradle.plugin.devel.internal.precompiled.ExtractPluginRequestsTask;
import org.gradle.plugin.devel.internal.precompiled.GeneratePluginAdaptersTask;
import org.gradle.plugin.devel.internal.precompiled.PrecompiledGroovyScript;
import org.gradle.plugin.devel.plugins.JavaGradlePluginPlugin;

class PrecompiledGroovyPluginsPlugin
implements Plugin<Project> {
    PrecompiledGroovyPluginsPlugin() {
    }

    public void apply(Project project) {
        project.getPluginManager().apply(GroovyBasePlugin.class);
        project.getPluginManager().apply(JavaGradlePluginPlugin.class);
        project.afterEvaluate(this::exposeScriptsAsPlugins);
    }

    private void exposeScriptsAsPlugins(Project project) {
        GradlePluginDevelopmentExtension pluginExtension = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
        SourceSet pluginSourceSet = pluginExtension.getPluginSourceSet();
        FileTree scriptPluginFiles = pluginSourceSet.getAllSource().matching(PrecompiledGroovyScript::filterPluginFiles);
        List<PrecompiledGroovyScript> scriptPlugins = scriptPluginFiles.getFiles().stream().map(PrecompiledGroovyScript::new).collect(Collectors.toList());
        this.declarePluginMetadata(pluginExtension, scriptPlugins);
        DirectoryProperty buildDir = project.getLayout().getBuildDirectory();
        TaskContainer tasks = project.getTasks();
        TaskProvider extractPluginRequests = tasks.register("extractPluginRequests", ExtractPluginRequestsTask.class, task -> {
            task.getScriptPlugins().convention((Iterable)scriptPlugins);
            task.getScriptFiles().from(new Object[]{scriptPluginFiles.getFiles()});
            task.getExtractedPluginRequestsClassesDirectory().convention(buildDir.dir("groovy-dsl-plugins/plugin-requests"));
        });
        TaskProvider generatePluginAdapters = tasks.register("generatePluginAdapters", GeneratePluginAdaptersTask.class, task -> {
            task.getScriptPlugins().convention((Iterable)scriptPlugins);
            task.getExtractedPluginRequestsClassesDirectory().convention(extractPluginRequests.flatMap(ExtractPluginRequestsTask::getExtractedPluginRequestsClassesDirectory));
            task.getPluginAdapterSourcesOutputDirectory().convention(buildDir.dir("groovy-dsl-plugins/output/adapter-src"));
        });
        TaskProvider precompilePlugins = tasks.register("compileGroovyPlugins", CompileGroovyScriptPluginsTask.class, task -> {
            task.getScriptPlugins().convention((Iterable)scriptPlugins);
            task.getScriptFiles().from(new Object[]{scriptPluginFiles.getFiles()});
            task.getPrecompiledGroovyScriptsOutputDirectory().convention(buildDir.dir("groovy-dsl-plugins/output/plugin-classes"));
            SourceDirectorySet javaSource = pluginSourceSet.getJava();
            SourceDirectorySet groovySource = ((GroovySourceSet)new DslObject((Object)pluginSourceSet).getConvention().getPlugin(GroovySourceSet.class)).getGroovy();
            task.getClasspath().from(new Object[]{pluginSourceSet.getCompileClasspath(), javaSource.getClassesDirectory(), groovySource.getClassesDirectory()});
        });
        pluginSourceSet.getJava().srcDir((Object)generatePluginAdapters.flatMap(GeneratePluginAdaptersTask::getPluginAdapterSourcesOutputDirectory));
        pluginSourceSet.getOutput().dir((Object)precompilePlugins.flatMap(CompileGroovyScriptPluginsTask::getPrecompiledGroovyScriptsOutputDirectory));
    }

    private void declarePluginMetadata(GradlePluginDevelopmentExtension pluginExtension, List<PrecompiledGroovyScript> scriptPlugins) {
        pluginExtension.plugins((Action<? super NamedDomainObjectContainer<PluginDeclaration>>)((Action)pluginDeclarations -> scriptPlugins.forEach(scriptPlugin -> pluginDeclarations.create(scriptPlugin.getId(), scriptPlugin::declarePlugin))));
    }
}

