/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.tasks;

import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.language.swift.tasks.internal.SymbolHider;
import org.gradle.process.ExecSpec;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;

@CacheableTask
public class UnexportMainSymbol
extends DefaultTask {
    private final ConfigurableFileCollection source = this.getProject().files(new Object[0]);
    private final DirectoryProperty outputDirectory = this.getProject().getObjects().directoryProperty();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @SkipWhenEmpty
    public ConfigurableFileCollection getObjects() {
        return this.source;
    }

    @Internal
    public FileCollection getRelocatedObjects() {
        return this.outputDirectory.getAsFileTree();
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    protected void unexport(InputChanges inputChanges) {
        for (FileChange change : inputChanges.getFileChanges((FileCollection)this.getObjects())) {
            if (change.getChangeType() == ChangeType.REMOVED) {
                File relocatedFileLocation = this.relocatedObject(change.getFile());
                relocatedFileLocation.delete();
                continue;
            }
            if (!change.getFile().isFile()) continue;
            this.unexportMainSymbol(change.getFile());
        }
    }

    private void unexportMainSymbol(final File object) {
        final File relocatedObject = this.relocatedObject(object);
        if (OperatingSystem.current().isWindows()) {
            try {
                SymbolHider symbolHider = new SymbolHider(object);
                symbolHider.hideSymbol("main");
                symbolHider.hideSymbol("_main");
                symbolHider.hideSymbol("wmain");
                symbolHider.hideSymbol("_wmain");
                symbolHider.saveTo(relocatedObject);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        } else {
            this.getProject().exec((Action)new Action<ExecSpec>(){

                public void execute(ExecSpec execSpec) {
                    if (OperatingSystem.current().isMacOsX()) {
                        execSpec.executable((Object)"ld");
                        execSpec.args(new Object[]{object});
                        execSpec.args(new Object[]{"-o", relocatedObject});
                        execSpec.args(new Object[]{"-r"});
                        execSpec.args(new Object[]{"-unexported_symbol", "_main"});
                    } else if (OperatingSystem.current().isLinux()) {
                        execSpec.executable((Object)"objcopy");
                        execSpec.args(new Object[]{"-L", "main"});
                        execSpec.args(new Object[]{object});
                        execSpec.args(new Object[]{relocatedObject});
                    } else {
                        throw new IllegalStateException("Do not know how to unexport a main symbol on " + OperatingSystem.current());
                    }
                }
            });
        }
    }

    private File relocatedObject(File object) {
        return ((RegularFile)this.outputDirectory.file(object.getName()).get()).getAsFile();
    }
}

