/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.CachedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.DefaultCachedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ModuleArtifactCache;
import org.gradle.internal.hash.HashCode;
import org.gradle.util.BuildCommencedTimeProvider;

public class InMemoryModuleArtifactCache
implements ModuleArtifactCache {
    private final Map<ArtifactAtRepositoryKey, CachedArtifact> inMemoryCache = Maps.newConcurrentMap();
    private final BuildCommencedTimeProvider timeProvider;
    private final ModuleArtifactCache delegate;

    public InMemoryModuleArtifactCache(BuildCommencedTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        this.delegate = null;
    }

    public InMemoryModuleArtifactCache(BuildCommencedTimeProvider timeProvider, ModuleArtifactCache delegate) {
        this.timeProvider = timeProvider;
        this.delegate = delegate;
    }

    @Override
    public void store(ArtifactAtRepositoryKey key, File artifactFile, HashCode moduleDescriptorHash) {
        this.inMemoryCache.put(key, new DefaultCachedArtifact(artifactFile, this.timeProvider.getCurrentTime(), moduleDescriptorHash));
        if (this.delegate != null) {
            this.delegate.store(key, artifactFile, moduleDescriptorHash);
        }
    }

    @Override
    public void storeMissing(ArtifactAtRepositoryKey key, List<String> attemptedLocations, HashCode descriptorHash) {
        this.inMemoryCache.put(key, new DefaultCachedArtifact(attemptedLocations, this.timeProvider.getCurrentTime(), descriptorHash));
        if (this.delegate != null) {
            this.delegate.storeMissing(key, attemptedLocations, descriptorHash);
        }
    }

    @Override
    @Nullable
    public CachedArtifact lookup(ArtifactAtRepositoryKey key) {
        CachedArtifact cachedArtifact = this.inMemoryCache.get(key);
        if (cachedArtifact == null && this.delegate != null && (cachedArtifact = this.delegate.lookup(key)) != null) {
            this.inMemoryCache.put(key, cachedArtifact);
        }
        return cachedArtifact;
    }

    @Override
    public void clear(ArtifactAtRepositoryKey key) {
        this.inMemoryCache.remove(key);
        if (this.delegate != null) {
            this.delegate.clear(key);
        }
    }
}

